pro pearlinit,teff
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Procedure to initialize effective temperature regions and maps.
; If Teff map is not specified, fit a blackbody to the SED in "fl".
;
common PearlBoxes,clbox_x,clbox_y,ncl,crbox_x,crbox_y,ncr
common PearlData,ov,ow,uc,vc,cv,mv,si,bi,ci,wl,bw,fl,db,cb,dm,rm,cm,cc,rt,rg,rf
;
nc=n_elements(fl)
logg=4.5	; This is not used anymore
tgran=50.0
;
;  Try to fit Teff to photometry
if n_elements(teff) eq 0 then begin
	ncl=0
	mcl=20
	clbox_x=fltarr(5,mcl)
	clbox_y=fltarr(5,mcl)
	teff=5000
	a=[teff,1.0]
	index=unique(ci)-1
	xc=wl[index]*1d-9
	yc=fl[index]
	if n_elements(xc) ge 2 then begin
		r=curvefit(xc,yc,yc*0+1,a, $
			function_name='blackbody_pro',/noderiv)
		teff=nint(a[0]/tgran)*tgran
		print,'Fitted Teff = ',teff
	endif
	cm.teff=teff
	cm.logg=logg
	cc.teff=cm.teff
	cc.logg=cm.logg
endif
;
tu=unique(teff)
ncr=n_elements(tu)
mcr=ncr > 20
rt=fltarr(mcr)
rg=fltarr(mcr)+logg
rf=fltarr(nc,mcr)
crbox_x=fltarr(5,mcr)
crbox_y=fltarr(5,mcr)
;
index=unique(ci)-1
;
for i=0,ncr-1 do begin
	rt[i]=tu[i]
	rf[*,i]=pearlflux(tu[i],wl[index],bw[index])
; 	Normalize rf with total flux
	rf[*,i]=rf[*,i]/fl[index]
endfor
; Scale with geometric mean
rf=rf/gavg(rf[*,0:ncr-1])
;
end
