function pearlmap,lambda,channel=channel
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; For a given wavelength, return image. Convolve with circular Gaussian
; assuming the width is 3 pixels. Lambda is in meters.
;
common PearlData,ov,ow,uc,vc,cv,mv,si,bi,ci,wl,bw,fl,db,cb,dm,rm,cm,cc,rt,rg,rf
;
MAS2RAD=!pi/(180l*3600000l)
;
; nr is the number of non-zero effective temperature regions
ir=where(rt ne 0,nr)
;
cmap=cm.maps[0].map+cc.maps[0].map
;
for i=0,nr-1 do begin
        flux=stellarfluxes( $
              {teff:-rt[i],logg:rg[i], $
               diameter:1.0,ratio:1.0, $
               code:13}, $
               lambda,ld_coeffs)
	index=where(cm.teff eq rt[i])
	cmap[index]=cmap[index]*flux
endfor
;
cellsze=cm.x[0]-cm.x[1]
;
; When read from a file, we don't know the CLEAN beam for this PEARL image
if not keyword_set(channel) then begin
	r=size(cmap,/dim)
	imsze=r[0]/4+1
	cbm=pearlimage(imsze,cellsze/MAS2RAD,1)
	r=sqrt(cbm.x^2+cbm.y^2)
	a=3*cellsze
	result=machar() & tiny=result.xmin*1e6 & toosmall=alog(tiny)
	y=(-(r/a)^2)
	index=where(y lt toosmall,count)
	if count gt 0 then y[index]=1
	cbm.maps[0].map(*)=exp(y)
	if count gt 0 then cbm.maps[0].map(index)=0
	ch=0
endif else begin
	cbm=cb
	ch=channel
endelse
;
fmap=convol(cmap,cbm.maps[ch].map,/edge_wrap,/center)
;
return,fmap
;
end
