pro pearlmodel,vis,flux,mv_in=mv_in,cv_in=cv_in,night=n
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Interface for calcmodel to pass complex model visibilities for
; self-calibration and component subtraction. The two options
; cannot be used together.
;
; Option /mv: initialize mv (pearl) to vis, must then run selfcal in Pearl
; Option /cv: must specify flux, convert cv (pearl) and mv to corr. fluxes,
;	      then subtract vis*flux from cv*flux and re-normalize.
;	      This option is useful for the analysis of triple stars.
;
common PearlData,ov,ow,uc,vc,cv,mv,si,bi,ci,wl,bw,fl,db,cb,dm,rm,cm,cc,rt,rg,rf
;
if keyword_set(mv_in) then begin
	mv=vis
	print,'Please run selfcal!'
endif
if keyword_set(cv_in) then begin
	print,'Subtracting model...'
	uci=unique(ci)
;	Convert to correlated fluxes
	for j=0,n_elements(uci)-1 do begin
		index=where(ci eq uci[j])
		cv[index]=cv[index]*fl[j]
		vis[index]=vis[index]*flux[j]
	endfor
;	Subtract correlated flux from model
	cv=cv-vis
	fl=fl-flux
;	Re-normalize visibilities
	for j=0,n_elements(uci)-1 do begin
		index=where(ci eq uci[j])
		cv[index]=cv[index]/fl[j]
	endfor
	if n_elements(dm) ne 0 then begin
		print,'Computing new dirty map...'
		dirtymap
		tvrm
		tvcm
	endif
endif
;
end
