pro pearson
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
nuv=61L
uvc=set_uvc([nuv,nuv],1.0)
uvc.map=sqrt(exp(-0.40*sqrt(uvc.u^2+uvc.v^2)))
c=float(uvc.map)
nim=127L
map=pearlimage([nim,nim],2.0d0)
uvc.u=uvc.u*1e6
uvc.v=uvc.v*1e6
img=dft(map,reform(uvc.map,nuv*nuv),uvc.u,uvc.v)
m=img.map
x=findgen(nim)-nim/2
y=m[*,nim/2]
ym=max(y)
index=where(y gt ym/2,fwhm)
a=[max(y),1.50,40.0]
a=[ym,1.5,fwhm]
xc=x
yc=y
r=curvefit(xc,yc,yc*0+1,a,function_name='pearson_pro',/noderiv)
!p.multi=[0,1,2]
plot,findgen(nuv)-nuv/2,c[*,nuv/2],psym=0
plot,x,y
oplot,x,pearson_funct(x,a),psym=0
print,a
;
; Check the back transformation
imsize=[nim,nim]
x=(lindgen(imsize[0]*imsize[1]) mod imsize[0]) - (imsize[0]/2)
y=(lindgen(imsize[0]*imsize[1]) / imsize[0]) - (imsize[1]/2)
img.map=pearson_funct(sqrt(float(x)^2+float(y)^2),a)
img.teff=1
t=mft(img,reform(uvc.map*0,nuv*nuv),uvc.u,uvc.v,1,1,lonarr(nuv*nuv)+1)
t=reform(t,nuv,nuv)
window,/free
!p.multi=0
y1=float(uvc.map[*,nuv/2])
plot,y1,psym=0
y2=float(t[*,nuv/2])
f=median(y1/y2)
oplot,y2*f,psym=1
;
end
