function perifit,x_in,y_in,period,yft
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
if n_elements(period) eq 0 then begin
	print,'***Error(PERIFIT): period not defined!'
	return,0
endif
num=n_elements(x_in)
if num eq 0 then begin
	print,'***Error(PERIFIT): x undefined!'
	return,0
endif
if num ne n_elements(y_in) then begin
	print,'***Error(PERIFIT): number of elements in x and y not equal!'
	return,0
endif
;
; Make sure to remove leading empty dimensions and convert to double
x=double(reform(x_in,num))/period*2*!pi
y=double(reform(y_in,num))
;
m=dblarr(num,4,/nozero)
m[*,0]=1
m[*,1]=x
m[*,2]=sin(x)
m[*,3]=cos(x)
;
tm=transpose(m)
n=tm#m & m=0
r=tm#y & tm=0
svd8,n,w,u,v
tol=1e-13
small=where(w lt max(w)*tol,count)
print,'SVD: will edit',count,' singular values!'
if count gt 0 then w[small]=0
svb8,u,w,v,r,s
; s=invert(n)#r
;
yft=perinom(x,s)
return,s
;
end
