function phasescan,t,p,wrap=wrap
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; For given times t [s] and phases p [rad], compute mean phase in tint second
; intervals, using histogram averaging in four bins.
;
common LocalPhaseScan,lastphase
;
if n_elements(lastphase) eq 0 then lastphase=0
if n_elements(wrap) eq 0 then wrap=0 else wrap=wrap gt 0
;
bin=2*!pi/4
pmin=-!pi
pmax=+!pi
;
ts=t-t[0]
tint=5.0
n=ceil(max(ts)/tint)
;
phase=fltarr(n)
time=findgen(n)*tint+tint/2
;
for i=0L,n-1 do begin
	index=where(ts gt i*tint and ts lt (i+1)*tint,count)
	if count gt 0 then begin
		r=histogram(p[index],binsize=bin,max=pmax,min=pmin)
		phase[i]=atan(r[3]-r[1],r[2]-r[0])+!pi/4
	endif else phase[i]=4
endfor
;
index=where(phase ne 4)
time=time[index]
phase=phase[index]
phase=phaseunwrap(phase)
if wrap then phase=phase-nint((phase[0]-lastphase)/(2*!pi))*(2*!pi)
wrap=1
lastphase=phase[n_elements(phase)-1]
;
case n_elements(time) of
	1: return,fltarr(n_elements(ts))+phase[0]
	2: return,interpol(phase,time,ts)
     else: return,spline(time,phase,ts)
endcase
;
end
