function phaseshift,r,l
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Return the phase shift (group delay phase) between the central fringe
; and the peak of the power spectrum (group delay) for a given residual
; delay r[m] and l=lambda [m]. Approximate.
;
; Write the refractive index n as: n=n0+a*s where s=1/l.
; Then the phase p after tracking is: p=2*Pi*s*A*(n0+a*s)-2*Pi*d*s,
; with A the differential air path, and d the delay compensation.
; If we use the group delay for d, i.e. d=A*n0, then the tracked fringe
; phase will be: p=2*Pi*A*a*s^2. To return the white light phase shift,
; we have to sum this over all wavelengths.
;
n=edlen(l*1e6)-1
s=1/(l*1e6)
c=poly_fit(s,n,1)
return,total(2*!pi*(r*1e6)/c[0]#(c[1]*s^2),2)/n_elements(l)
;
; Old code using simulated fringe frames
n=20
a=findgen(n)*1e3
g=findgen(n)/3
frames=fringeframe(a,-g,l*1e6)
v=fringevis(frames)
d=gitter(41,-4e-6)
p=visdft(v,l,d)
gd=groupdelay[p,l,d]
gp=cphase(visdft(v,l,gd))
c=poly_fit(g,gp,1,yfit)
;plot,g,gp,psym=1 & oplot,g,yfit,psym=0
return,poly(r*1e6,c)
;
end
