pro photom,scan_ids,y=roc,e=eoc,init=init,nonl=nonl
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Attempt to assign relative throughputs to all stations, per spectrometer,
; based on changes in photon rate between different scan configurations.
; If the configurations don't change or there are too few configuration changes,
; let SVD assign values arbitrarily. This is OK since the results, stored in
; genconfig.reflux, are only used to put the visibility normalization at the
; time of averaging onto the same footing.
;
; Combine all scans, which requires normalization of the stellar fluxes. The
; alternative is to do this calculation on a star-by-star basis, but then there
; could be an insufficient number of configuration changes for any given star.
;
; The data for file linear.xdr are in linear.dat, created by rflinear(misc.pro).
;
common LocalPhotom,rates
common StarBase,startable,notes
common SysConfig,SystemId,Date,MetroConfig,GenConfig,GeoParms,GenInfo,GeoInfo
common Tables,ScanTable,BGTable,StationTable
common ScanData,scans,bgscans,bufferinfo,positions,velocities,magnitudes
;
; Obtain and store predicted count rates for all stars
if n_elements(init) eq 0 then init=0 else init=init gt 0
if n_elements(nonl) eq 0 then nonl=0 else nonl=nonl gt 0
if n_elements(rates) eq 0 or init then begin
	numstar=n_elements(startable)
	rates=fltarr(genconfig.numoutbeam,max(GenConfig.NumSpecChan),numstar)
	for i=0,numstar-1 do begin
		if startable[i].starid ne 'FKV0000' then begin
			apdrates,startable[i].starid,r
			rates[*,*,i]=r
		endif
	endfor
endif
;
; Include non-linearity corrections
restore,!oyster_dir+'npoi/linear.xdr'
n_lin=n
q_lin=q
n_lin_ob=n_elements(q_lin[*,0,0])
n_lin_ch=n_elements(q_lin[0,*,0])
if n_lin_ob ne genconfig.numoutbeam $
or n_lin_ch ne max(genconfig.numspecchan) then begin
	n_lin=fltarr(genconfig.numoutbeam,max(genconfig.numspecchan),2)
	q_lin=n_lin+1
	for i=0,n_elements(q_lin[*,0,0])-1 do $
	for j=0,n_elements(q_lin[0,*,0])-1 do n_lin[i,j,1]=1000
endif
;
; Process only data for specified scans; use all otherwise
if n_elements(scan_ids) eq 0 then scan_index=indgen(n_elements(scans)) $
			     else scan_index=scan_ids-1
stars=unique(scans[scan_index].starid)
numstar=n_elements(stars)
star_index=intarr(n_elements(startable))
for i=0,numstar-1 do begin
	index=where(startable.starid eq stars[i],count)
	if count gt 0 then star_index[index]=1
endfor
index=where(star_index eq 1,count)
if count eq 0 then begin
	print,'***Error(PHOTOM): none of these stars exist in the startable!'
	return
endif
rates1=rates[*,*,index]
star_index=scan_index*0-1
for i=0,numstar-1 do begin
	index=where(scans[scan_index].starid eq stars[i],count)
	if count gt 0 then star_index[index]=i
endfor
s=scantable[scan_index].station
;
roc=scans[scan_index].photonrate*0
eoc=scans[scan_index].photonrate*0
;
for ob=0,genconfig.numoutbeam-1 do begin
	sindex=intarr(genconfig.numsid)
	for i=0,genconfig.numsid-1 do $
		sindex[i]=strpos(strjoin(genconfig.baselineid[*,ob]), $
				genconfig.stationid[i])
	s_index=where(total(s,2) ne 0 and sindex ne -1)
	for j=0,genconfig.numspecchan[ob]-1 do begin
		x=extinct(scans[scan_index].za)
		n=scans[scan_index].natcounts(s_index)
		p=scans[scan_index].photonrate(ob,j)
		q=spline8(n_lin[ob,j,*],q_lin[ob,j,*],p)
		if not nonl then q[*]=1
		r=(p/x*q)/rates1[ob,j,star_index]
		re=scans[scan_index].photonrateerr(ob,j)
		index=where(re gt 0,count)
		if count gt 0 then begin
		se=s[*,index]
		dm=transpose(float(se[s_index,*]))
		tm=transpose(dm)
		nm=tm#dm
		y=tm#r[index]
		if n_elements(nm) eq 1 then begin
			sol=y/nm
		endif else begin
			svdc,nm,w,u,v
			small=where(w lt max(w)*1e-08,count)
			if count gt 0 then w[small]=0
			sol=svsol(u,w,v,y)
		endelse
		genconfig.apdflux[      *,j,ob]=0
		genconfig.apdflux[s_index,j,ob]=sol/total(sol)
		c=dm#sol
		jndex=where(c eq 0,count)
		if count gt 0 then c[jndex]=1
		roc[ob,j,index]=r[index]/c
		eoc[ob,j,index]=0.1
		if count gt 0 then eoc[ob,j,index[jndex]]=-0.1
;
		tm=tm*n
		dm=transpose(tm)
		nm=tm#dm
		y=tm#p[index]
		if n_elements(nm) eq 1 then begin
			sol=y/nm
		endif else begin
			svdc,nm,w,u,v
			small=where(w lt max(w)*1e-08,count)
			if count gt 0 then w[small]=0
			sol=svsol(u,w,v,y)
		endelse
		genconfig.natflux[      *,j,ob]=0
		genconfig.natflux[s_index,j,ob]=sol
		endif
	endfor
endfor
;
end
