pro pivotcorr,base_time,base_xyz,remove=remove,apply=apply,compute=compute
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; This procedure computes delay corrections from the pivot motion as
; measured with the baseline metrology system. It is mathematically identical
; to metrocorr, except it works with ScanData instead of PointData.
; Note that the correction, as in whitecorr, is only applied to the
; calibrated delay data. The FDL data are not corrected.
;
; Use the averaged INCHWORM solution data to compute delay correction, or
; derive the correction from the procedure parameters if supplied. The
; corrections are stored in the MetroDelay field of a scan. Note that they
; may be inconsistent with the solution data if they were derived from
; the procedure parameters.
;
; The optional parameters are the station coordinates for epochs given
; in the first parameter.
; Optional parameters: base_time(NumTime) [s]
;		       base_xyz(3,NumSid,NumTime) [microns]
;
; Every second call to this procedure reverses the action of the previous call!
;
; Every second call to this procedure reverses the action of the previous call!
; The remove and apply keywords force action, level 1 checks the status of the
; toggle switch (sign), level 2 forces application or removal of metrodelay.
;
common StarBase,StarTable,Notes
common SysConfig,SystemId,Date,MetroConfig,GenConfig,GeoParms,GenInfo,GeoInfo
common ScanData,scans,bgscans,bufferinfo,positions,velocities,magnitudes
common Constants,c_light,pi_circle,e_euler,i_complex,a_disp,b_disp
common LocalPivotCorr,sign
;
if checkdata([3,8,9]) ne 0 then return
;
if n_params() eq 1 then begin
	print,'***Error(PIVOTCORR): must have both time and corrections!'
	return
endif
;
; If compute=0 then take correction from metrodelay variable
if n_elements(compute) eq 0 then compute=1 else compute=compute gt 0
if n_elements(remove) eq 0 then remove=0
;
if n_elements(base_xyz) eq 0 and compute $
	and total(abs(scans.parxerr) $
	         +abs(scans.paryerr) $
	         +abs(scans.parzerr)) eq 0 then begin
	if remove eq 0 then print,'***Error(PIVOTCORR): no metrology data!'
	return
endif
;
RAD=180/pi_circle
;
; This makes the procedure work like a toggle switch
if n_elements(sign) eq 0 then sign=1 else sign=-sign
;
if remove eq 1 and sign gt 0 then begin
	sign=-sign
	return
endif else if remove eq 2 then sign=-1
;
if n_elements(apply) eq 0 then apply=0
if apply eq 1 and sign lt 0 then begin
	sign=-sign
	return
endif else if apply eq 2 then sign=1
;
if sign gt 0 and compute then begin
;
;	MetroConfig has to be present before we continue
	if checkdata([21]) ne 0 then begin
		sign=-sign
		return
	endif
;
; 	Remove the sign from negative time stamps
	times=abs(scans.time)
;
; 	Compute apparent star positions
	topostar,times,scans.starid,StarTable,ra_app,dec_app
;
; 	Compute UT1
	ut1=utc2ut1(times)
;
; 	Compute Greenwich apparent sidereal time
	gst=ut12gst(times,ut1)
;
; 	Compute hour angle
	ha=hourangle(gst,ra_app)
;
	for j=0,GenConfig.NumSid-1 do begin
;
;       	Deal with FKV0000, i.e. the white light source, alias Alpha Lab
		index=where(scans.starid eq 'FKV0000',count_white)
		if count_white gt 0 then begin
			hadec=equatorial2hadec( $
			  horizon2equatorial( $
			  azel2horizon(MetroConfig.SidModel.FeedbeamAng[*,j])))
			ha[index]=hadec[0]
			dec_app[index]=hadec[1]
		endif
		if n_elements(base_xyz) ne 0 then begin
			base_x=spline(base_time,reform(base_xyz[0,j,*]),times)
			base_y=spline(base_time,reform(base_xyz[1,j,*]),times)
			base_z=spline(base_time,reform(base_xyz[2,j,*]),times)
			dec_r=dec_app/RAD & ha_r=ha*15/RAD
			x=-cos(dec_r)*sin(ha_r)
			y=+sin(dec_r)*cos(GeoParms.Latitude/rad) $
			  -cos(dec_r)*sin(GeoParms.Latitude/rad)*cos(ha_r)
			z=+cos(dec_r)*cos(GeoParms.Latitude/rad)*cos(ha_r) $
			  +sin(dec_r)*sin(GeoParms.Latitude/rad)
			d=base_x*x+base_y*y+base_z*z
			e=d*0+1
		endif else begin
			parx=scans.ParX[j,*]
			pary=scans.ParY[j,*]
			parz=scans.ParZ[j,*]
			d=catseyedelay(MetroConfig.SidModel.FeedbeamAng[*,j], $
		   	  parx,pary,parz, $
		   	  ha,dec_app,MetroConfig.SidModel.CatsEyeOff[j], $
		   	  scans.ParXErr[j,*], $
			  scans.ParYErr[j,*], $
			  scans.ParZErr[j,*],e)
		endelse
		if count_white gt 0 then begin
			index=where(scans.starid eq 'FKV0000')
			d[index]=d[index]/2
			e[index]=e[index]/2
		endif
		index=where(e le 0,count)
		if count gt 0 then begin
			print,'***Warning(PIVOTCORR): '+ $
                              'will interpolate/extrapolate MetroDelay for scan(
				retroparse(index+1)+', Sid ',j+1,'!', $
				format='(a,i2,a)'
			for k=0,n_elements(startable)-1 do begin
				kndex=where(scans.starid eq startable[k].starid)
				jndex=where(e[kndex] le 0,count)
				if count gt 0 then begin
				lndex=where(e[kndex] gt 0,count)
				if count eq 0 then begin
				print,'***Error(PIVOTVORR): '+ $
				'no valid scans for interpolation for star ', $
				startable[k].starid,'!'
				endif else begin
				d[kndex[jndex]]= $
					spline(scans[kndex[lndex]].time, $
						 d[kndex[lndex]], $
						 scans[kndex[jndex]].time)
				print,'Repaired scans for star ', $
					startable[k].starid
				endelse
				endif
			endfor
		endif
		scans[*].metrodelay(j)=d
		scans[*].metrodelayerr(j)=e
	endfor
; 	Convert to "delay" format
	for j=0,GenConfig.NumSid-1 do begin
        	if j ne GenConfig.RefStation-1 then $
        	scans[*].metrodelay(j)=scans[*].metrodelay(j) $
			      	      -scans[*].metrodelay(GenConfig.RefStation-1)
	endfor
	scans[*].metrodelay(GenConfig.RefStation-1)=0
endif
;
scans.grpdelay=scans.grpdelay-scans.metrodelay*1d-6*sign
scans.drydelay=scans.drydelay-scans.metrodelay*1d-6*sign
scans.wetdelay=scans.wetdelay-scans.metrodelay*1d-6*sign
;
if sign gt 0 then print,'Pivot correction applied.' $
             else print,'Pivot correction removed.'
;
end
