pro pivotfit,order=order
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Fit mean pivot and axis offset vectors to XYZ data.
;
common SysConfig,SystemId,Date,MetroConfig,GenConfig,GeoParms,GenInfo,GeoInfo
common InchData,Sol0,SolN,Jscan,MetroTime,FeedVector, $
        ParX,ParXErr,ParY,ParYErr,ParZ,ParZErr,MetroPath,MetroPathErr, $
	MotorAngle,MotorAngleErr
common ScanData,scans,bgscans,bufferinfo,positions,velocities,magnitudes
;
; Check presence of data
if checkdata([1,8,16,21]) ne 0 then return
;
if n_elements(order) eq 0 then order=intarr(GenConfig.NumSid)+3
if n_elements(order) eq 1 then order=replicate(order[0],GenConfig.NumSid)
;
PivotMotion=fltarr(n_elements(MetroTime),3,GenConfig.NumSid)
;
for i=0,GenConfig.NumSid-1 do begin
	y=lmpivot(x,a,/init,sid=i+1)
	if total(abs(y)) eq 0 then conv=0 else $
	r=lmfit(x,y,a,function_name='lmpivot',/double,conv=conv,sigma=e)
	if conv eq 1 then begin
		MetroConfig.Sidmodel.PivotOffset[*,i]=a
		MetroConfig.Sidmodel.PivotOffsetErr[*,i]=e
		print,'Siderostat ',i+1,' RMS [microns] = ',stddev(y-r)
;		Fit mean pivot motion
		index=where(parxerr[i,*] gt 0 and solindex(metrotime))
		hadec=sidpointing(sidmodel(i+1),motorangle[*,i,index],1)
		mp=mirrorpivot(sidmodel(i+1),hadec[0,*],hadec[1,*],a)
;		Polynomial
		PivotMotion[*,0,i]=polynom(MetroTime/60, $
			polyfit(MetroTime[index]/60,parx[i,index]-mp[*,0],order[i]))
		PivotMotion[*,1,i]=polynom(MetroTime/60, $
			polyfit(MetroTime[index]/60,pary[i,index]-mp[*,1],order[i]))
		PivotMotion[*,2,i]=polynom(MetroTime/60, $
			polyfit(MetroTime[index]/60,parz[i,index]-mp[*,2],order[i]))
	endif
endfor
;
print,'Pivot coordinates fit.'
;
end
