pro plot_benhist,sid,counts=counts
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
common StarBase,StarTable,Notes
common RawData,TimeStamp,LaserPos,GeoPos,QuadCounts, $
	Raw0,RawN,OutputBeam,BinCounts
common SysConfig,SystemId,Date,MetroConfig,GenConfig,GeoParms,GenInfo,GeoInfo
;
if n_elements(counts) gt 0 then natcounts=counts else natcounts=quadcounts
;
if n_elements(genconfig) ne 0 then begin
	if n_elements(sid) eq 0 then sid=indgen(genconfig.numsid)+1
	stations=genconfig.stationid
endif else begin
	if n_elements(sid) eq 0 then sid=indgen(n_elements(natcounts[*,0,0]))+1
	stations=strarr(n_elements(sid))
endelse
;
!p.charsize=1.5
loadct,0,/silent
;
f_rebin=3
binsize=0.04
numbin=nint(2.0/binsize)+1
x=(findgen(numbin)-float(numbin-2)/2)*binsize
;
ben_rms=[0.35,0.30,0.25,0.20,0.15,0.10,0.00]
ben_bno=['B0','B1','B2','B3','B4','B5','B6']
;
xsize=numbin*f_rebin*n_elements(sid)
ysize=numbin*f_rebin
if xsize ne !d.x_size or ysize ne !d.y_size then $
	window,xsize=xsize,ysize=ysize,/free
;
for i=0,n_elements(sid)-1 do begin
;
	xy=natoffset(natcounts[sid[i]-1,*,*])
;
	y=lonarr(numbin,numbin)
	for j=0,numbin-1 do begin
		index=where(xy[*,1] ge x[j]-binsize/2 $
			and xy[*,1] lt x[j]+binsize/2,count)
		if count gt 0 then $
		y[*,j]=histogram(xy[index,0],min=-1,binsize=binsize,max=1)
	endfor
;
	tvscl,rebin(y,numbin*f_rebin,numbin*f_rebin,/sample),i*numbin*f_rebin,0
	s=abs(ben_rms-sqrt(stddev(xy[*,0])*stddev(xy[*,1])))
	xyouts,(numbin*f_rebin/2)+i*numbin*f_rebin,1,/device, $
		ben_bno[where(s eq min(s))] $
		+' ('+string(sqrt(stddev(xy[*,0])*stddev(xy[*,1])),format='(f4.2)')+')',color=
	xyouts,(numbin*f_rebin/2)+i*numbin*f_rebin,numbin*f_rebin-!d.y_ch_size-1,/devic
		stations[sid[i]-1]
;
;	Fit Gaussian profile to 2D histogram
	aparm=fltarr(7)
	r=gauss2dfit(y,aparm)
	print,'Widths in X and Y directions: ',aparm[2],aparm[3]
;
endfor
;
end
