pro plot_coherence,baseline,beam,channels,parms,untrack=untrack
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
common RawData,TimeStamp,LaserPos,GeoPos,QuadCounts, $
	Raw0,RawN,OutputBeam,BinCounts
common SysConfig,SystemId,Date,MetroConfig,GenConfig,GeoParms,GenInfo,GeoInfo
;
if n_elements(untrack) eq 0 then untrack=0
;
if n_elements(baseline) eq 0 then begin
	print,'***Error(PLOT_COHERENCE): you must specify baseline ID!'
	return
endif
bl=baseline-1
if n_elements(beam) ne 0 then get_bincounts,beam
ob=OutputBeam-1
;
d=fdldelay(baseline,beam,scan=0)
;
if n_elements(channels) eq 0 then ch=indgen(GenConfig.NumSpecChan[ob])  $
			     else ch=channels-1
l=genconfig.wavelength[ch]
nch=n_elements(ch)
if nch gt 4 then begin
	!p.charsize=1.5
	mf=2
endif else begin
	!p.charsize=1.0
	mf=1
endelse
;
; Set number of plots
ny=nint(sqrt(nch))
nx=nint((float(nch)/ny)+0.4999)
!p.multi=[0,nx,ny]
!p.color=tci(1)
!x.title='t [ms]'
!y.title='Squared visibility'
;
k=[1,2,3,4,6,8,10,15,20,25]
k=[1,2,4,8,15,25]
num=n_elements(k)
dt=fltarr(num)
v2=fltarr(num)
parms=fltarr(3,nch)
a=[0.4,4.0]
;
norm_factor=4.0/sinc(float(genconfig.fringemod[bl,ob])/genconfig.numbin)^2
for j=0,nch-1 do begin
for i=1,num do begin
	dt[i-1]=k[i-1]*genconfig.instrcohint
;v=add(visrotate(fringevis(bincounts(ob,*,ch(j),*)),l(j),-d),k(i-1))
;n=add(fringenphot(bincounts(ob,*,ch(j),*)),k(i-1))
;m=add(fringemphot(bincounts(ob,*,ch(j),*)),k(i-1))
	if untrack then c=rotateframe(bincounts[*,ch[j],*],l[ch[j]],d) $
		   else c=bincounts[*,ch[j],*]
;	c=add(fix(reform(c)),k(i-1),1)
	c=addbincounts(fix(reform(c)),k[i-1])
	v=fringevis(c,genconfig.fringemod[bl,ob])
	n=fringenphot(c)
	m=fringemphot(c)
	v2[i-1]=norm_factor*avg(abs(v)^2-m^2)/avg(n)^2
endfor
plot,dt,v2,psym=1,/xlog,/ylog, $
	title='ob '+string(OutputBeam,format='(i1)') $
	     +', ch '+string(ch[j]+1,format='(i2)')
if v2[0] gt 0 then begin
	a[0]=v2[0]
	v2fit=curvefit(dt,v2,v2*0+1,a, $
		function_name='funct_coherence',/noderivat)
	b=[a,v2[0]/a[0]]
	parms[*,j]=b
	x=dindgen(100)+1
	oplot,x,b[0]*corrloss(x/b[1]),psym=0
	xyouts,10^(!x.crange[0]+0.4),10^(!y.crange[0]+0.6), $
		't0 = '+string(b[1],format='(f4.1)'),charsize=!p.charsize/mf
	xyouts,10^(!x.crange[0]+0.4),10^(!y.crange[0]+0.5), $
		'C0 = '+string(b[0],format='(f4.2)'),charsize=!p.charsize/mf
	xyouts,10^(!x.crange[0]+0.4),10^(!y.crange[0]+0.4), $
		'Loss = '+string(b[2],format='(f4.2)'),charsize=!p.charsize/mf
endif
endfor
;
end
