pro plot_dispsol,baseline,beam,scanfile, $
	numav=numav,compute=compute,classic=classic
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
common StarBase,StarTable,Notes
common Tables,ScanTable,BGTable,StationTable
common SysConfig,SystemId,Date,MetroConfig,GenConfig,GeoParms,GenInfo,GeoInfo
common RawData,TimeStamp,LaserPos,GeoPos,QuadCounts, $
	Raw0,RawN,OutputBeam,BinCounts
;
if n_elements(numav) eq 0 then numav=100
if n_elements(compute) eq 0 then compute=1
if n_elements(classic) eq 0 then classic=1
;
if n_elements(scanfile) ne 0 then $
savefile=scanfile+'.'+string(baseline,format='(i1)') $
                 +'.'+string(beam,format='(i1)')+'.xdr'
;
IF compute THEN BEGIN
if n_elements(baseline) eq 0 then begin
	print,'***Error(PLOT_DISPSOL): you must specify baseline ID!'
	return
endif
if n_elements(scanfile) ne 0 then begin
	hds_close
	get_rawdata,scanfile
	scan=1
endif else scan=0
if n_elements(beam) eq 0 then begin
	if n_elements(OutputBeam) eq 0 then begin
		print,'***Error(PLOT_DISPSOL): you must specify beam ID!'
		return
	endif
	beam=OutputBeam
	do_read=0
endif else do_read=1
if n_elements(scanfile) ne 0 then begin
	v=coherentvis(baseline,beam,scanfile,classic=classic,delay=d)
endif else begin
	if do_read then v=coherentvis(baseline,beam,classic=classic,delay=d) $
		   else v=coherentvis(baseline,classic=classic,delay=d)
endelse
f=add(fdldelay(genconfig.baselineid[baseline-1,beam-1],scan=scan),numav)*1d4
t=add(double(fdlstamp(scan=scan))/1000,numav)/numav & t0=t[0] & t=t-t[0]
d=d*1e6
if n_elements(channels) eq 0 then $
	channels=channelindex[genconfig.spectrometerid[beam-1]]
l=genconfig.wavelength[channels-1,beam-1]
solve,v,l,s,/pt,/plot
if n_elements(scanfile) ne 0 then begin
	save,t,f,s,filename=savefile
	print,'Saved file: '+savefile
endif
ENDIF ELSE restore,savefile
;
set_screen
!p.charsize=1.5
!p.multi=[0,2,2]
!x.title='Time - '+hms(t0/3600)+' [s]'
!p.psym=3
!y.range=0
!x.range=0
;
if n_elements(t) lt 50000l then window,/free $
	else if n_elements(t) lt 100000l then window_slide,xsize=1000 $
	else if n_elements(t) lt 1000000l then window_slide,xsize=5000 $
	else window,/free,xsize=1000
if scantable[0].starid eq 'FKV0000' then sf=10 else sf=1
plot,t,f,ytitle='FDL residual [microns]', $
	title=date
plot,t,polyres(t,f-d,1),ytitle='GRP residual [microns]', $
	yrange=!y.crange,ystyle=1, $
	title=scantable[0].starid+' ('+string(scantable[0].scanid,format='(i0)')+')'
plot,t,polyres(t,f-d+s[0,*],1),ytitle='Disp. corr. delay', $
	yrange=!y.crange*sf,ystyle=1, $
	title=genconfig.baselineid[baseline-1,beam-1] $
	     +' ('+string(beam,format='(i1)')+')'
plot,t,s[2,*],ytitle='Fringe ID',yrange=[-2,2]
!p.psym=1
;
; Recover standard plot settings
set_screen
!x.range=0
!y.range=0
;
end
