pro plot_dmodstars
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Plot photometric distance modulus vs trigonometric distance modulus
; for all stars.
;
common StarBase,startable,notes
;
index=where((startable.mv ne +100) $
	and (startable.amv ne +100) $
	and (startable.px gt 0),count)
if count gt 0 then begin
	dmod_p=startable[index].amv-startable[index].mv
	dmod=-5*alog10(1./startable[index].px)+5
	!p.charsize=1.5
	plot,dmod,dmod_p,psym=1,title='All stars', $
		xtitle='Parallax distance modulus', $
		ytitle='Photometric distance modulus'
	oplot,findgen(40)-20,findgen(40)-20
endif else print,'Insufficient data!'
;
end
