pro plot_fdldelay,baseline,beam,slide=slide,scan=scan
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Compute and plot the groupdelay for the given baseline.
; Must have read raw data first.
;
common StarBase,StarTable,Notes
common Tables,ScanTable,BGTable,StationTable
common SysConfig,SystemId,Date,MetroConfig,GenConfig,GeoParms,GenInfo,GeoInfo
common RawData,TimeStamp,LaserPos,GeoPos,QuadCounts, $
	Raw0,RawN,OutputBeam,BinCounts
;
if n_elements(baseline) eq 0 then begin
	print,'***Error(PLOT_FDLDELAY): you must specify baseline ID!'
	return
endif
if n_elements(beam) eq 0 then begin
	if n_elements(OutputBeam) eq 0 then begin
		print,'***Error(PLOT_FDLDELAY): you must specify beam ID!'
		return
	endif
	beam=OutputBeam
endif
if n_elements(slide) eq 0 then slide=0
if n_elements(scan) eq 0 then scan=1
;
d=fdldelay(baseline,beam,scan=scan)
t=fdlstamp()/1000. & t0=t[0] & t=t-t[0]
;
set_screen
if slide then window_slide,xsize=20000 else window,/free
plot,t,d*1e6,psym=3,charsize=2, $
	title=startable[0].starid $
	     +' ('+string(scantable[0].scanid,format='(i0)')+') ' $
	     +genconfig.baselineid[baseline-1,beam-1] $
	     +' ('+string(beam,format='(i1)')+') '+date, $
	ytitle='FDL delay [microns]', $
	xtitle='Time - '+hms(t0/3600)+' [s]'
;
; Recover from window_slide settings
set_screen
!x.range=0
!y.range=0
;
end
