pro plot_fdlpower,baseline,beam,sf=sf
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; timestamp [ms], no fractional values allowed!
; delay [m]
;
common RawData,TimeStamp,LaserPos,GeoPos,QuadCounts, $
	Raw0,RawN,OutputBeam,BinCounts
;
if not keyword_set(sf) then sf=0 else sf=sf gt 0
;
if n_elements(baseline) eq 0 then begin
	print,'***Error(PLOT_FDLPOWER): you must specify baseline ID!'
	return
endif
if n_elements(beam) eq 0 then begin
	if n_elements(OutputBeam) eq 0 then begin
		print,'***Error(PLOT_FDLPOWER): you must specify beam ID!'
		return
	endif
	beam=OutputBeam
endif
;
d=fdldelay(baseline,beam)
; If the actual fringe position is needed, i.e. free from tracking errors
; g=fringedelays(baseline,beam) & d=d-g
t=fdlstamp()
;
series=powerpatch(t,d,limit=100000)*1d6
sampling_int=0.002
;
window,/free & set_screen
;
IF sf THEN BEGIN
;
; !y.title='Delay structure function [mu^2]'
strucfunc,series,sampling_int,intervals,values,accel=n_elements(series)/400
;
x=alog10(intervals)
y=alog10(values)
index=where(x gt -1.0 and x lt 0.0)
r=poly_fit(x[index],y[index],1)
t0=(10^(-(r[0]-alog10(1.44)-alog10(0.5^2))/(5.0/3.0))/7.5)*1000
t0=(10^(-(r[0]-alog10((0.5/(2*!pi))^2))/(5.0/3.0)))*1000
slope=r[1]
;
ENDIF ELSE BEGIN
;
series=poweroftwo(series)
print,'Length of series [s]: ',n_elements(series)*sampling_int
;
; !y.title='PSD [mu^2/Hz]'
tp=powerspectrum(series,sampling_int,f,p,f_avg,p_avg)
;
!x.ticks=0
!y.ticks=0
!p.charsize=1.5
;
; plot,f,alog10(p),xrange=[f(1),1/(2*sampling_int)],xstyle=1,ystyle=1,/xlog, $
;     xtitle='Frequency [Hz]',psym=3
;
plot,f_avg,alog10(p_avg),xrange=[f[1],1/(2*sampling_int)],xstyle=1,/xlog, $
     xtitle='Frequency [Hz]',psym=0, $
     title=!p.title, $
     xgridstyle=1,xticklen=1,ygridstyle=1,yticklen=1
;
x=alog10(f_avg)
y=alog10(p_avg)
index=where(x gt -1.0 and x lt 1.0)
r=poly_fit(x[index],y[index],1,yfit)
t0=10^(-(r[0]-alog10(5.68e-4)-alog10(0.5^2))/(5.0/3.0))*1000
slope=r[1]
xyouts,0.4,0.85,/normal,'t0 = '+string(t0,format='(f4.1)')+' [ms]' $
	              +', slope = '+string(slope,format='(f5.2)'), $
		charsize=2,charthick=2
;
ENDELSE
;
; Recover from plot settings
set_screen
!x.range=0
!y.range=0
;
end
