pro plot_fringedelay,baseline,beam,scanfile,numav=numav,classic=classic, $
	slide=slide
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Compute and plot the fringedelay for the given baseline.
; Must have read raw data first.
;
common StarBase,StarTable,Notes
common Tables,ScanTable,BGTable,StationTable
common SysConfig,SystemId,Date,MetroConfig,GenConfig,GeoParms,GenInfo,GeoInfo
common RawData,TimeStamp,LaserPos,GeoPos,QuadCounts, $
	Raw0,RawN,OutputBeam,BinCounts
;
if n_elements(baseline) eq 0 then begin
	print,'***Error(PLOT_GROUPDELAY): you must specify baseline ID!'
	return
endif
if n_elements(beam) eq 0 then begin
	if n_elements(OutputBeam) eq 0 then begin
		print,'***Error(PLOT_GROUPDELAY): you must specify beam ID!'
		return
	endif
	beam=OutputBeam
endif
if n_elements(numav) eq 0 then numav=1
if n_elements(classic) eq 0 then classic=1
if n_elements(slide) eq 0 then slide=0
if not classic then gindex=1
;
if classic then g=fringedelays(baseline,beam,scanfile) $
	   else g=fringedelays(baseline,beam,scanfile,gindex=gindex)
g=g*1e6
t=fdlstamp(scan=n_elements(scanfile))/1000. & t0=t[0] & t=t-t[0]
if classic then gindex=lonarr(n_elements(t))+1
;
set_screen
if slide then window_slide,xsize=20000 else window,/free
plot,t,g,psym=3,charsize=2, $
	title=startable[0].starid $
	     +' ('+string(scantable[0].scanid,format='(i0)')+') ' $
	     +genconfig.baselineid[baseline-1,beam-1] $
	     +' ('+string(beam,format='(i1)')+') '+date, $
	ytitle='Fringe delay [microns]', $
	xtitle='Time - '+hms(t0/3600)+' [s]'
;
gd=groupdelays(baseline,beam,scanfile,numav=1,gindex=gindex)
oplot,t[where(gindex eq 0)],g[where(gindex eq 0)],psym=3,color=tci(0)
;
; Recover from window_slide settings
set_screen
!x.range=0
!y.range=0
;
end
