pro plot_fringeimage,channels=channels
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Display image of fringes (bincounts) as a function of time and either
; channel (wavelength) or delay (bin number). The first option is chosen
; if more than one channel is specified, the latter if only one channel
; has been specified. If no channels are undefined, produce a color image
; of three single channels.
;
common RawData,TimeStamp,LaserPos,GeoPos,QuadCounts, $
	Raw0,RawN,OutputBeam,BinCounts
;
if n_elements(bincounts) eq 0 then begin
	print,'***Error(PLOT_FRINGEIMAGE): bincounts undefined!'
	return
endif
;
if n_elements(channels) eq 0 then color=1 else color=0
if n_elements(channels) gt 1 then channeled=1 else channeled=0
;
; Define color table
if color then begin
	m=6
	n=m*m*m
	k=256/m
	r=(bindgen(n) mod m)*k+k
	g=((bindgen(n)/m) mod m)*k+k
	b=((bindgen(n)/(m*m)) mod m)*k+k
endif else begin
	r=indgen(255)
	g=indgen(255)
	b=indgen(255)
endelse
;
bc=float(reform(bincounts[*,*,0:10000]))
r=size(bc)
numbin=r[1]
if color then begin
	ch1=2
	ch2=7
	ch3=12
	b1=fix((bc[*,ch1,*]/max(bc[*,ch1,*])*255)-(k/2))/k
	b2=fix((bc[*,ch2,*]/max(bc[*,ch2,*])*255)-(k/2))/k
	b3=fix((bc[*,ch3,*]/max(bc[*,ch3,*])*255)-(k/2))/k
	image=reform(b1+b2*m+b3*m*m)
endif else if channeled then begin
	ch=channels-1
;	image=reform(bc(0,ch,*)/max(bc(0,ch,*))*255)
	image=reform(bc[0,ch,*])
	for j=0,n_elements(ch)-1 do $
		image[j,*]=(image[j,*]/max(bc[*,ch[j],*]))*255*2
endif else begin
	ch=channels-1
	image=reform(bc[*,ch,*]/max(bc[*,ch,*])*255*2)
	image[where(image gt 255)]=255
endelse
;
xsize=long(800)
if channeled then yoffs=n_elements(channels)+4  else yoffs=numbin+4
ysize=n_elements(image[0,*])*yoffs/xsize
window,xsize=xsize,ysize=ysize,colors=256,/free
tvlct,r,g,b
;
for i=0L,n_elements(image[0,*])/xsize-1 do begin
	tv,transpose(image[*,i*xsize:(i+1)*xsize-1]),0,i*yoffs
endfor
;
end
