pro plot_fringephase,baseline,beam,scanfile,classic=classic
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Compute and plot the corrected visibility phases.
; Must have read raw data first.
;
common StarBase,StarTable,Notes
common Tables,ScanTable,BGTable,StationTable
common SysConfig,SystemId,Date,MetroConfig,GenConfig,GeoParms,GenInfo,GeoInfo
common RawData,TimeStamp,LaserPos,GeoPos,QuadCounts, $
	Raw0,RawN,OutputBeam,BinCounts
;
if n_elements(baseline) eq 0 then begin
	print,'***Error(PLOT_FRINGEPHASES): you must specify baseline ID!'
	return
endif
if n_elements(beam) eq 0 then begin
	if n_elements(OutputBeam) eq 0 then begin
		print,'***Error(PLOT_FRINGREPHASES): you must specify beam ID!'
		return
	endif
	beam=OutputBeam
endif
if n_elements(classic) eq 0 then classic=1
if not classic then gindex=1
;
if classic then p=fringephases(baseline,beam,scanfile) $
	   else p=fringephases(baseline,beam,scanfile,gindex=gindex)
t=fdlstamp(scan=n_elements(scanfile))/1000.& t0=t[0] & t=t-t0
if classic then gindex=lonarr(n_elements(t))+1
;
window,/free
set_screen
!p.charsize=1.5
!p.multi=[0,1,2]
!y.title='Residual phase [radians]'
!x.title='Time - '+hms(t0/3600)+' [s]'
!y.range=[-3,3]
!x.style=1
!y.style=1
num=n_elements(t)/20000L
if num eq 0 then num=1
index=lindgen(n_elements(t)/num)*num
plot,t[index],p[index],psym=3
index=where(gindex gt 0)
plot,findgen(n_elements(index))*0.002,p[index],psym=3, $
	title=startable[0].starid $
	     +' ('+string(scantable[0].scanid,format='(i0)')+') ' $
	     +genconfig.baselineid[baseline-1,beam-1] $
	     +' ('+string(beam,format='(i1)')+') '+date, $
	xtitle='Number of seconds'
print,'RMS of phase: ',stddev(p)
;
; Recover standard plot settings
set_screen
!x.range=0
!y.range=0
;
end
