pro plot_fringepowers,beam,channels=channels,numav=numav,stars=stars
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Plot fringe power as a function of modulation k.
;
common StarBase,StarTable,Notes
common Tables,ScanTable,BGTable,StationTable
common SysConfig,SystemId,Date,MetroConfig,GenConfig,GeoParms,GenInfo,GeoInfo
common RawData,TimeStamp,LaserPos,GeoPos,QuadCounts, $
	Raw0,RawN,OutputBeam,BinCounts
;
if n_elements(stars) eq 0 then stars=''
;
files=file_search('????-??-??.raw.???.??')
first=1
for nf=0,n_elements(files)-1 do begin
;
hds_open,files[nf]
get_rawdata
;
index=where(stars eq scantable[0].starid,count)
if strlen(stars[0]) eq 0 then count=1
if scantable[0].code eq 1 and count gt 0 then begin
if n_elements(starids) eq 0 then starids=scantable.starid $
else begin
	index=where(starids eq scantable[0].starid,count)
	if count eq 0 then starids=[starids,scantable[0].starid]
endelse
if n_elements(beam) eq 0 then begin
	if n_elements(OutputBeam) eq 0 then begin
		print,'***Error(PLOT_FRINGEPOWER): you must specify beam ID!'
		return
	endif
	beam=OutputBeam
endif
get_bincounts,beam
hds_close
;
if n_elements(channels) eq 0 then channels=1
if n_elements(numav) eq 0 then numav=10
;
ch=channels-1
c=reform(bincounts[*,ch,*])
;
r=size(c)
kmin=0.75
case r[1] of
	8:kmax=4+0.75
       64:kmax=10+0.75
     else:begin
	  print,'Error: unknown frame format!'
	  return
	  end
endcase
if r[0] eq 3 then nc=r[2] else begin
	nc=1
	c=reform(c,r[1],1,r[2])
	endelse
n=nint((kmax-kmin)/0.25)
x=findgen(n+1)/n*(kmax-kmin)+kmin
y=x
vdata=fltarr(n+1,n_elements(c[0,0,*])/numav)
for i=0,n do begin
	vdata[i,*]=fringevissq(c[*,0,*],x[i],numav,normal=1)
	y[i]=avg(vdata[i,*])
endfor
;
!p.charsize=1.5
!x.title='k'
!y.title='<X^2+Y^2-N>/<N>^2'
;
!p.color=tci(where(starids eq scantable[0].starid)+1)
if first then $
plot,x,y,psym=0,xrange=[kmin,kmax],xstyle=1, $
	title=date+', beam='+string(outputbeam,format='(i1)') $
else oplot,x,y,psym=0
first=0
xyouts,100,!d.y_size-50-!p.color*(!d.y_ch_size+2),scantable[0].starid,/device
;
for j=1,nc-1 do begin
for i=0,n do y[i]=avg(fringevissq(c[*,j,*],x[i],numav,normal=1))
oplot,x,y,psym=-1,color=getcolor(j+1)
endfor
endif else hds_close
endfor
;
; Recover from plot_slide settings
if !d.name eq 'PS' then device,/close
set_screen
!x.range=0
!y.range=0
;
end
