pro plot_iso,dev
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
common iso_data,z,age,table,current_data,current_age
common obs_data,ot,ote,ol,ole,do_obs
common aux_data,dotted_data,dashed_data,do_dotted,do_dashed
common interpol,l_d,c_d,l_i,c_i,l_a,c_a
common local,last_age
;
if n_elements(table) eq 0 then begin
	print,'***Error: no table loaded!'
	return
endif
;
set_plot,dev
if dev eq 'PS' then device,/encapsulated
;
if n_elements(last_age) eq 0 then last_age=0.0
if dev eq 'PS' then last_age=-1
;
if age ne last_age then begin
	if dev eq 'x' then begin
	 index=where(abs(table.age-age) eq min(abs(table.age-age)),count)
	endif else begin
	 index=where(fix(table.age*10+0.5) eq fix(current_age*10+0.5),count)
	endelse
	if count ne 0 then begin
		last_age=age
		if total(abs(!x.range)) eq 0 then begin
			range_auto=1
			t_min=min(table[index].teff)
			t_max=max(table[index].teff)
			l_max=max(table[index].lum)
			l_min=min(table[index].lum)
			!x.range=[t_max,t_min]
			!y.range=[l_min,l_max]
		endif else range_auto=0
		!p.charsize=1.5
		if dev eq 'x' then begin
		plot,table[index].teff,table[index].lum, $
			xtitle='log(effective temperature/K)', $
			ytitle='log(luminosity/solar luminosity)',psym=0
		endif else begin
		print,'Sending PostScript plot to file wave.ps...'
		plot,table[index].teff,table[index].lum, $
			xtitle='log(effective temperature/K)', $
			ytitle='log(luminosity/solar luminosity)'
		if not do_dotted and not do_dashed then begin
		xyouts,0.25,0.2,'log(age/yr)='+string(age,format='(f4.2)'), $
			/normal,charsize=1.5
		xyouts,0.25,0.25,'Z='+string(float(z)/10000,format='(f5.3)'), $
			/normal,charsize=1.5
		endif
		endelse
		if range_auto then begin
			!x.range=0
			!y.range=0
		endif
		if do_dotted then $
			oplot,dotted_data[*,0],dotted_data[*,1],linestyle=1
		if do_dashed then $
			oplot,dashed_data[*,0],dashed_data[*,1],linestyle=2
;
		current_data=fltarr(count,2)
		current_data[*,0]=table[index].teff
		current_data[*,1]=table[index].lum
		current_age=age
;
do_obs=1
		if do_obs then begin
ot=[3.892,3.892]
ol=[1.685,1.246]
ote=[0.026,0.026]
ole=[0.089,0.097]
			px1=[ot[0]-ote[0],ot[0]+ote[0]]
			py1=[ol[0],ol[0]]
			px2=[ot[0],ot[0]]
			py2=[ol[0]-ole[0],ol[0]+ole[0]]
			sx1=[ot[1]-ote[1],ot[1]+ote[1]]
			sy1=[ol[1],ol[1]]
			sx2=[ot[1],ot[1]]
			sy2=[ol[1]-ole[1],ol[1]+ole[1]]
			oplot,px1,py1,thick=3
			oplot,px2,py2,thick=3
			oplot,sx1,sy1,thick=3
			oplot,sx2,sy2,thick=3
		endif
	endif else begin
;		print,'***Error: invalid age: log(age)=',age
	endelse
endif
;
if dev eq 'PS' then device,/close
set_plot,'x'
;
end
