pro plot_nathist,sid
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Plot histograms of the X and Y offsets derived from the NAT quad counts.
;
common StarBase,StarTable,Notes
common RawData,TimeStamp,LaserPos,GeoPos,QuadCounts, $
	Raw0,RawN,OutputBeam,BinCounts
common SysConfig,SystemId,Date,MetroConfig,GenConfig,GeoParms,GenInfo,GeoInfo
;
if n_elements(sid) eq 0 then sid=indgen(genconfig.numsid)+1
if n_elements(sid) gt 2 then mf=2 else mf=1
;
!p.multi=[0,n_elements(sid),2]
!p.multi[4]=1
!p.charsize=1.5
;
binsize=0.01
numbin=nint(2.0/binsize)+1
x=(findgen(numbin)-float(numbin-2)/2)*binsize
;
for i=0,n_elements(sid)-1 do begin
;
	xy=natoffset(quadcounts[sid[i]-1,*,*])
;
	y=histogram(xy[*,0],min=-1,binsize=0.01,max=1)
	plot,x,y,psym=10,ystyle=0,xrange=[-1,1], $
		xtitle='NAT normalized X offset',ytitle='N', $
		title=genconfig.stationid[sid[i]-1]+' ' $
	     	     +startable[0].starid+' ' $
	     	     +date+' ' $
	     	     +string(avg(timestamp)/3600000.,format='(f5.2)')+' UT'
	a=[max(y),0,0.5]
	nfit=curvefit(x,y,y*0+1,a,function_name='funct_nathist',/noderivat)
	xyouts,-0.9,a[0]*0.95,'FWHM = '+string(a[2],format='(f4.2)'), $
		charsize=!p.charsize/mf
	xyouts,-0.9,a[0]*0.85,'RMS  = '+string(stddev(xy[*,0]),format='(f4.2)'), $
		charsize=!p.charsize/mf
	oplot,x,nfit,psym=0,color=tci(3)
;
	y=histogram(xy[*,1],min=-1,binsize=0.01,max=1)
	plot,x,y,psym=10,ystyle=0,xrange=[-1,1], $
		xtitle='NAT normalized Y offset',ytitle='N', $
		title=''
	nfit=curvefit(x,y,y*0+1,a,function_name='funct_nathist',/noderivat)
	xyouts,-0.9,a[0]*0.95,'FWHM = '+string(a[2],format='(f4.2)'), $
		charsize=!p.charsize/mf
	xyouts,-0.9,a[0]*0.85,'RMS  = '+string(stddev(xy[*,1]),format='(f4.2)'), $
		charsize=!p.charsize/mf
	oplot,x,nfit,psym=0,color=tci(3)
;
endfor
;
end
