pro plot_natpower,beam
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Plot power spectrum of NAT total quad counts for specified input beam.
;
common RawData,TimeStamp,LaserPos,GeoPos,QuadCounts, $
	Raw0,RawN,OutputBeam,BinCounts
;
if n_elements(beam) eq 0 then begin
	print,'***Error(PLOT_NATPOWER): you must specify beam ID!'
	return
endif
ib=beam-1
;
c=reform(total(quadcounts[ib,*,*],2))
t=fdlstamp()
n=avg(c)
c=c-n
;ts=(double(t)-t(0))/1000
;index=where(ts lt 30)
;c=c(index)
;t=t(index)
;
series=powerpatch(t,c,limit=100000)
sampling_int=0.002
;
window,/free & set_screen
;
series=poweroftwo(series)
print,'Length of series [s]: ',n_elements(series)*sampling_int
;
!y.title='Power'
tp=powerspectrum(series,sampling_int,f,p,f_avg,p_avg)
;
!x.ticks=0
!y.ticks=0
!p.charsize=1.5
;
plot,f_avg,alog10(p_avg),xrange=[f[1],1/(2*sampling_int)],xstyle=1,/xlog, $
     xtitle='Frequency [Hz]',psym=0, $
     title=!p.title, $
     xgridstyle=1,xticklen=1,ygridstyle=1,yticklen=1
;
x=alog10(f_avg)
y=alog10(p_avg)
index=where(x gt -1.0 and x lt 1.0)
r=poly_fit(x[index],y[index],1,yfit)
t0=10^(-(r[0]-alog10(5.68e-4)-alog10(0.5^2))/(5.0/3.0))*1000
slope=r[1]
xyouts,0.4,0.85,/normal,'<N> = '+string(long(n),format='(i4)') $
	              +', stddev = '+string(long(tp),format='(i4)'), $
		charsize=2,charthick=2
;
; Recover from plot settings
set_screen
!x.range=0
!y.range=0
;
end
