pro plot_powerhist,baseline,beam,scanfile,numav=numav
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Compute and plot histograms of primary and secondary peak heights
; in the fringe powerspectra.
; Must have read raw data first.
;
common StarBase,StarTable,Notes
common SysConfig,SystemId,Date,MetroConfig,GenConfig,GeoParms,GenInfo,GeoInfo
common RawData,TimeStamp,LaserPos,GeoPos,QuadCounts, $
	Raw0,RawN,OutputBeam,BinCounts
;
if n_elements(baseline) eq 0 then begin
	print,'***Error(PLOT_POWERHIST): you must specify baseline ID!'
	return
endif
if n_elements(beam) eq 0 then begin
	if n_elements(OutputBeam) eq 0 then begin
		print,'***Error(PLOT_POWERHIST): you must specify beam ID!'
		return
	endif
	beam=OutputBeam
endif
if n_elements(numav) eq 0 then numav=1
;
g=groupdelays(baseline,beam,scanfile,numav=numav,plot=1)
;
; Recover from plot settings
set_screen
!x.range=0
!y.range=0
;
end
