pro plot_ratehist,channels
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Plot histograms of the spectrometer photon count rate for the
; selected channels.
;
common RawData,TimeStamp,LaserPos,GeoPos,QuadCounts, $
	Raw0,RawN,OutputBeam,BinCounts
common SysConfig,SystemId,Date,MetroConfig,GenConfig,GeoParms,GenInfo,GeoInfo
;
ob=OutputBeam-1
;
if n_elements(channels) eq 0 then ch=indgen(GenConfig.NumSpecChan[ob])  $
			     else ch=channels-1
;
; Set number of plots
nch=n_elements(ch)
ny=nint(sqrt(nch))
nx=nint((float(nch)/ny)+0.4999)
!p.multi=[0,nx,ny]
!p.color=tci(1)
title='Rate histogram'
;
for j=0L,nch-1 do begin
	bc=float(reform(bincounts[*,ch[j],*]))
	tc=summe(bc,0)
;	tc=randomu(seed,n_elements(tc),poisson=median(long(tc)))
	binsize=1
	fr=histogram(tc,min=0,binsize=binsize)
	x=findgen(n_elements(fr))*binsize+binsize/2
;
	xtitle='Beam='+string(OutputBeam,format='(i1)')+ $
     	     ', channel='+string(ch[j]+1,format='(i2)')
	ytitle=' '
	plot,x,fr,psym=10,title=title,xtitle=xtitle,ytitle=ytitle
	oploterr,x,fr,sqrt(fr),3
;
	n=n_elements(fr)
;	x=dindgen(n)
	m=median(long(tc))
;	y=eqp(m,lindgen(n))*n_elements(tc)
	y=eqp(m,long(x))*n_elements(tc)*binsize
	oplot,x,y,psym=0,color=tci(5)
endfor
;
end
