pro plot_sky,center_ra,center_dec,center=star
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Plot the stars of the startable on a hemisphere.
;
common StarBase,startable,notes
;
n=n_elements(startable)
if n eq 0 then begin
	print,'***Error(PLOT_SKY): startable undefined!'
	return
endif
;
if n_elements(center_ra) eq 0 or n_elements(center_dec) eq 0 then begin
	x=sin(startable[where(startable.starid ne 'FKV0000')].ra/12*!pi)
	z=cos(startable[where(startable.starid ne 'FKV0000')].ra/12*!pi)
	xmid=(min(x)+max(x))/2
	zmid=(min(z)+max(z))/2
	center_ra=atan(xmid,zmid)*12/!pi
	center_dec=(min(startable.dec)+max(startable.dec))/2
	if n_elements(star) ne 0 then begin
		index=where(startable.starid eq star,count)
		if count eq 0 then $
		index=where(strpos(startable.starid,star) ge 0,count)
		if count eq 0 then $
		index=where(strpos(startable.starid,strmid(star,2,6)) ge 0,count)
		if count eq 0 then $
		index=where(strpos(startable.starid,strmid(star,3,6)) ge 0,count)
		if count ne 0 then begin
			center_ra=startable[index].ra
			center_dec=startable[index].dec
		endif
	endif
endif
;
; Add lines of constant dec to data
num_ra=144
dec_int=10
num_lat=170/dec_int
num_pts_dec=num_ra*num_lat
dec_g=fltarr(num_pts_dec)
ra_g=fltarr(num_pts_dec)
for i=1,num_lat do begin
	dec_g[(i-1)*num_ra:i*num_ra-1]=i*dec_int-90.0
	ra_g[(i-1)*num_ra:i*num_ra-1]=findgen(num_ra)/num_ra*24.0
endfor
f_density=2	; Densify the equator
ra_g=[ra_g,findgen(num_ra*f_density)/(num_ra*f_density)*24]
dec_g=[dec_g,fltarr(num_ra*f_density)]
num_pts_dec=num_pts_dec+num_ra*f_density	; Update num_pts_dec
ra=[ra_g,startable.ra]
dec=[dec_g,startable.dec]
;
; Add lines of constant ra to data
num_dec=180
ra_int=1
num_lon=24/ra_int
num_pts_ra=num_dec*num_lon
dec_g=fltarr(num_pts_ra)
ra_g=fltarr(num_pts_ra)
for i=1,num_lon do begin
	ra_g[(i-1)*num_dec:i*num_dec-1]=(i-1)*ra_int
	dec_g[(i-1)*num_dec:i*num_dec-1]=findgen(num_dec)/num_dec*180.0-90.0
endfor
ra=[ra_g,ra]
dec=[dec_g,dec]
;
; Convert to radians
ra=ra/12*!pi
dec=dec/180*!pi
ra0=float(center_ra)/12*!pi
dec0=float(center_dec)/180*!pi
;
; Get x,y,z coordinates of stars
; z towards observer, y up (north), x right (west)
x=-cos(dec)*sin(ra)
y=+sin(dec)
z=+cos(dec)*cos(ra)
;
; Get x,y,z coordinates of center, call this the new z' axis
xz0=-cos(dec0)*sin(ra0)
yz0=+sin(dec0)
zz0=+cos(dec0)*cos(ra0)
;
; Get new x' axis with x' = y  X  z'
xx0=zz0
yx0=0.0
zx0=-xz0
length=sqrt(xx0^2+yx0^2+zx0^2)
xx0=xx0/length
yx0=yx0/length
zx0=zx0/length
;
; Get new y' axis with y' = z' X  x'
xy0=yz0*zx0-zz0*yx0
yy0=zz0*xx0-xz0*zx0
zy0=xz0*yx0-yz0*xx0
length=sqrt(xy0^2+yy0^2+zy0^2)
xy0=xy0/length
yy0=yy0/length
zy0=zy0/length
;
; Get new x' coordinates for all stars
xp=x*xx0+y*yx0+z*zx0
yp=x*xy0+y*yy0+z*zy0
zp=x*xz0+y*yz0+z*zz0
;
; Extract the grid lines
xp_g_ra=xp[0:num_pts_ra-1]
yp_g_ra=yp[0:num_pts_ra-1]
zp_g_ra=zp[0:num_pts_ra-1]
xp_g_dec=xp[num_pts_ra:num_pts_ra+num_pts_dec-1]
yp_g_dec=yp[num_pts_ra:num_pts_ra+num_pts_dec-1]
zp_g_dec=zp[num_pts_ra:num_pts_ra+num_pts_dec-1]
;
xp=xp[num_pts_ra+num_pts_dec:num_pts_ra+num_pts_dec+n-1]
yp=yp[num_pts_ra+num_pts_dec:num_pts_ra+num_pts_dec+n-1]
zp=zp[num_pts_ra+num_pts_dec:num_pts_ra+num_pts_dec+n-1]
;
; These are the visible stars
visible=where(zp ge 0,n)
xpv=xp[visible]
ypv=yp[visible]
stars=startable[visible].starid
;
; Plot them
nummax=65
if n lt nummax then psym=2 else psym=3
!p.multi=0
if !d.name eq 'X' then begin
	window,xsize=!xsize,ysize=!xsize,/free
	lc=1
	fc=4
	bc=5
endif else if !d.name eq 'PS' then begin
	width=17.78
        factor=width/!xsize
        device,xsize=factor*!xsize,ysize=factor*!ysize, $
                xoffset=1,yoffset=1,color=tci(1)
	lc=0
	fc=5
	bc=4
endif else begin
        print,'***Error(SKY_PLOT): invalid device name!'
        return
endelse
plot,xpv,ypv,psym=psym,xstyle=4,ystyle=4,xrange=[-1,1],yrange=[-1,1],color=tci(l
;
!p.charsize=1.0
if n lt 20 then !p.charsize=1.5
if n lt nummax then begin
	for i=0,n-1 do xyouts,xpv[i],ypv[i],stars[i],color=tci(lc)
	invisible=where(zp lt 0,in)
	if in gt 0 then begin
		xpiv=xp[invisible]
		ypiv=yp[invisible]
		stars=startable[invisible].starid
		for i=0,in-1 do xyouts,xpiv[i],ypiv[i],stars[i],color=tci(fc)
	endif
endif
;
; Plot the grid lines data
if n lt nummax then begin
	invisible=where(zp_g_ra lt 0,in)
	xp_g_ra_nv=xp_g_ra[invisible]
	yp_g_ra_nv=yp_g_ra[invisible]
	oplot,xp_g_ra_nv,yp_g_ra_nv,psym=3,color=tci(fc)
	invisible=where(zp_g_dec lt 0,in)
	xp_g_dec_nv=xp_g_dec[invisible]
	yp_g_dec_nv=yp_g_dec[invisible]
	oplot,xp_g_dec_nv,yp_g_dec_nv,psym=3,color=tci(fc)
endif
if n lt nummax then color=bc else color=fc
visible=where(zp_g_ra ge 0)
xp_g_ra_v=xp_g_ra[visible]
yp_g_ra_v=yp_g_ra[visible]
oplot,xp_g_ra_v,yp_g_ra_v,psym=3,color=tci(color)
visible=where(zp_g_dec ge 0)
xp_g_dec_v=xp_g_dec[visible]
yp_g_dec_v=yp_g_dec[visible]
oplot,xp_g_dec_v,yp_g_dec_v,psym=3,color=tci(color)
;
if !d.name eq 'PS' then device,/close
;
end
