pro plot_slide,xvector,yarray,labels,x2vector=x2vector,y2array=y2array,wid=wid
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Plots y(*,i) vs x(*), with i selected using a widget.
;
common PlotSlideLocal,x,y,x2,y2,do2,plabels,d_wid
;
count=n_elements(yarray[0,*])
;
x=xvector
y=yarray
if n_elements(labels) eq 0 then labels=sindgen(count)
plabels=labels
if n_elements(y2array) gt 0 then begin
	if n_elements(x2vector) eq 0 then x2=x $
				     else x2=x2vector
	y2=y2array
	do2=1
endif else do2=0
;
base_wid=widget_base(/column) & wid=base_wid
d_wid=widget_draw(base_wid,notify_realize='plotslide_event', $
	event_pro='plotslide_event', $
	scr_xsize=600,scr_ysize=200)
i_wid=cw_fslider(base_wid,minimum=1,maximum=count,value=1,/drag, $
	title='Index I',xsize=600,format='(i0)',uvalue='i')
j_wid=cw_fslider(base_wid,minimum=0,maximum=100,value=0,/drag, $
	title='Index J',xsize=600,format='(i0)',uvalue='j')
widget_control,base_wid,/realize
xmanager,'plot_slide',base_wid,/no_block,event_handler='plotslide_event'
;
end
