pro plot_spectrumpeaks,baseline,beam,channels=channels,numav=numav
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Compute fringe spectra of the squared visibility amplitude
; averaged incoherently over numav samples as a function of
; fringe frequency. Make a scatter plot of the peak amplitude
; at the k value corresponding to the selected baseline, versus
; the maximum peak amplitude over all the other fringe frequencies
; which are not supposed to contain any signal.
;
common StarBase,StarTable,Notes
common SysConfig,SystemId,Date,MetroConfig,GenConfig,GeoParms,GenInfo,GeoInfo
common RawData,TimeStamp,LaserPos,GeoPos,QuadCounts, $
	Raw0,RawN,OutputBeam,BinCounts
;
if n_elements(baseline) eq 0 then begin
	print,'***Error(PLOT_SPECTRUMPEAKS): you must specify baseline ID!'
	return
endif
if n_elements(beam) eq 0 then begin
	if n_elements(OutputBeam) eq 0 then begin
		print,'***Error(PLOT_SPECTRUMPEAKS): you must specify beam ID!'
		return
	endif else beam=OutputBeam
endif else get_bincounts,beam
ob=beam-1
bl=baseline-1
if n_elements(channels) eq 0 then $
	channels=channelindex[genconfig.spectrometerid[ob]]
ch=channels-1
if n_elements(numav) eq 0 then numav=10
;
kmin=0.75
case genconfig.numbin of
	8:kmax=4+0.75
       64:kmax=8+0.75
     else:begin
	  print,'Error: unknown frame format!'
	  return
	  end
endcase
nc=n_elements(channels)
n=nint((kmax-kmin)/0.25)
x=findgen(n+1)/n*(kmax-kmin)+kmin
y=x
;
for j=0,nc-1 do begin
;
window,xsize=600,ysize=fix(600*(0.27/0.25)),/free & set_screen
!p.charsize=2.0
!p.title=genconfig.baselineid[bl,ob]+' ('+string(beam,format='(i1)')+') ' $
	+startable.starid+' '+date
!p.subtitle='<X^2+Y^2-N>/<N>^2, ' $
	+string(n_elements(timestamp)/numav,format='(i0)')+' exp, ' $
	+string(numav,format='(i0)')+' samples/exp.'
!x.title='Primary peak amplitude at k='+string(genconfig.fringemod[bl,ob], $
					format='(i0)') $
	+', ch='+string(channels[j],format='(i0)')
!y.title='Maximum secondary peak amplitude'
!x.margin=[10,5]
!y.margin=[6,3]
;
pps=fringevissq(bincounts[*,j,*],genconfig.fringemod[bl,ob],numav,normal=1)
for k=1,fix(kmax) do begin
	index=where(genconfig.fringemod[*,ob] eq k,count)
	if count eq 0 then begin
		kps=fringevissq(bincounts[*,j,*],k,numav,normal=1)
		if n_elements(sps) eq 0 then sps=kps $
					else sps=kps > sps
	endif
endfor
plot,pps,sps,xrange=[0,max(pps)],yrange=[0,max(pps)],psym=3
;
endfor
;
; Recover standard plot settings
set_screen
!x.range=0
!y.range=0
;
end
