pro plot_triplepower,c,numav=numav
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Plot fringe power as a function of modulation k.
;
common StarBase,StarTable,Notes
common Tables,ScanTable,BGTable,StationTable
common SysConfig,SystemId,Date,MetroConfig,GenConfig,GeoParms,GenInfo,GeoInfo
common RawData,TimeStamp,LaserPos,GeoPos,QuadCounts, $
	Raw0,RawN,OutputBeam,BinCounts
;
if n_elements(numav) eq 0 then numav=10
;
r=size(c)
kmin=0.75
case r[1] of
	8:kmax=4+0.75
       64:kmax=10+0.75
     else:begin
	  print,'Error: unknown frame format!'
	  return
	  end
endcase
if r[0] eq 3 then nc=r[2] else begin
	nc=1
	c=reform(c,r[1],1,r[2])
	endelse
n=nint((kmax-kmin)/0.25)
x=findgen(n+1)/n*(kmax-kmin)+kmin
y=x
vdata=fltarr(n+1,n_elements(c[0,0,*])/numav)
for i=0,n do begin
	vdata[i,*]=abs(fringetriple(c[*,0,*],1,x[i],numav))
	y[i]=avg(vdata[i,*])
endfor
;
if !d.name ne 'PS' then begin window,/free & set_screen & endif
!p.charsize=1.5
!x.title='k' $
	+' (<N0> = '+string(long(avg(fringenphot(c[*,0,*]))),format='(i4)')+')'
!y.title='<X^2+Y^2-N>/<N>^2'
!y.title='<X^2+Y^2-N>/<N>^2, '+string(r[r[0]],format='(i5)') $
     +' samples, '+string(numav,format='(i3)')+' samp./exp.'
;
plot,x,y,psym=-1,xrange=[kmin,kmax],xstyle=1
;
for j=1,nc-1 do begin
for i=0,n do y[i]=avg(fringevissq(c[*,j,*],x[i],numav,normal=1))
oplot,x,y,psym=-1,color=getcolor(j+1)
endfor
;
; Recover from plot_slide settings
if !d.name eq 'PS' then device,/close
set_screen
!x.range=0
!y.range=0
;
end
