pro plot_vispower,baseline,beam,numav=numav
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Compute and plot fringe power spectra.
; Must have read raw data first.
;
common StarBase,StarTable,Notes
common SysConfig,SystemId,Date,MetroConfig,GenConfig,GeoParms,GenInfo,GeoInfo
common RawData,TimeStamp,LaserPos,GeoPos,QuadCounts, $
	Raw0,RawN,OutputBeam,BinCounts
;
if n_elements(baseline) eq 0 then begin
	print,'***Error(PLOT_FRINGEPOWER): you must specify baseline ID!'
	return
endif
if n_elements(beam) eq 0 then begin
	if n_elements(OutputBeam) eq 0 then begin
		print,'***Error(PLOT_FRINGEPOWER): you must specify beam ID!'
		return
	endif
	beam=OutputBeam
endif
ob=beam-1
bl=baseline-1
if n_elements(channels) eq 0 then $
	channels=channelindex[genconfig.spectrometerid[ob]]
ch=channels-1
;
if n_elements(numav) eq 0 then numav=1
;
l=genconfig.wavelength[ch,ob]
d=gitter(121,-12e-6)
get_bincounts,beam
v=fringevis(bincounts[*,ch,*],genconfig.fringemod[bl,ob])
fp=box(abs(visdft(v,l,d)),numav,1)
g=groupdelay(fp,l,d,gindex)
;
set_screen
!x.title='Delay [microns]'
plot_slide,d*1e6,fp,string(gindex)
;
; Recover from plot_slide settings
set_screen
!x.range=0
!y.range=0
;
end
