pro plotbinary
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
common Model,gen_model,star_model,binary_model,gen_error,star_error,binary_error
common ScanData,scans,bgscans,bufferinfo,positions,velocities,magnitudes
;
if n_elements(binary_model) eq 0 then begin
	print,'Please load binary model first!'
	return
endif
if n_elements(positions) eq 0 then begin
	print,'Please read position data before!'
	return
endif
;
status=init_plotorbit()
;
a=binary_model[0].semimajoraxis
e=binary_model[0].eccentricity
i=binary_model[0].inclination
o=binary_model[0].periastron
n=binary_model[0].ascendingnode
;
base_wid=widget_base(/col, title='Binary orbit',resource_name='oyster')
;
d_wid=widget_draw(base_wid,scr_ysize=400,scr_xsize=400)
a_wid=cw_fslider(base_wid,title='Semi-major axis',uvalue='a',value=a, $
	minimum=a/10,maximum=a,/drag,xsize=400)
n_wid=cw_fslider(base_wid,title='Ascending node',uvalue='n',value=n, $
	minimum=0,maximum=360,/drag,xsize=400)
i_wid=cw_fslider(base_wid,title='Inclination',uvalue='i',value=i, $
	minimum=0,maximum=180,/drag,xsize=400)
e_wid=cw_fslider(base_wid,title='Eccentricity',uvalue='e',value=e, $
	minimum=-0.95,maximum=0.95,/drag,xsize=400)
o_wid=cw_fslider(base_wid,title='Periastron',uvalue='o',value=o, $
	minimum=0,maximum=360,/drag,xsize=400)
;
widget_control,base_wid,/realize
xmanager,'plotbinary',base_wid,/no_block,event_handler='plotbinary_event'
;
plot,findgen(10),findgen(10),/nodata, $
	xrange=2*[a,-a],yrange=2*[-a,a],ticklen=-0.02
;
; Plot periastron vector
plotthiele,'A-B'
p=modelpos(binary_model[0].epoch)
plots,[[fltarr(2)],[reform(p[0,0,*]-p[0,1,*])]],linestyle=0
;
; Plot line of nodes
RAD=180/!pi
e=binary_model[0].eccentricity
ea=2*atan(tan((-binary_model[0].periastron/RAD)/2)/sqrt((1+e)/(1-e)))
ma=ea-e*sin(ea)
p1=modelpos((ma/(2*!pi))*binary_model[0].period+binary_model[0].epoch)
ea=2*atan(tan((!pi-binary_model[0].periastron/RAD)/2)/sqrt((1+e)/(1-e)))
ma=ea-e*sin(ea)
p2=modelpos((ma/(2*!pi))*binary_model[0].period+binary_model[0].epoch)
plots,[[reform(p1[0,0,*]-p1[0,1,*])],[reform(p2[0,0,*]-p2[0,1,*])]],linestyle=1
;
end
