pro plotbinary_event,event
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
common Model,gen_model,star_model,binary_model,gen_error,star_error,binary_error
;
r=0.95
x=fix(poly(!x.crange,!x.s)*400) & xr=x[1]-x[0]
y=fix(poly(!y.crange,!y.s)*400) & yr=y[1]-y[0]
nx=xr-2
ny=yr-2
tv,bytarr(nx,ny),x[0]+1,y[0]+1
;
widget_control,event.id,get_uvalue=slider,get_value=value
case slider of
	'a':binary_model[0].semimajoraxis=value
	'n':binary_model[0].ascendingnode=value
	'i':binary_model[0].inclination=value
	'e':binary_model[0].eccentricity=value
	'o':binary_model[0].periastron=value
endcase
;
; Plot periastron vector
plotthiele,'A-B'
p=modelpos(binary_model[0].epoch)
plots,[[fltarr(2)],[reform(p[0,0,*]-p[0,1,*])]],linestyle=0
;
; Plot line of nodes
RAD=180/!pi
e=binary_model[0].eccentricity
ea=2*atan(tan((-binary_model[0].periastron/RAD)/2)/sqrt((1+e)/(1-e)))
ma=ea-e*sin(ea)
p1=modelpos((ma/(2*!pi))*binary_model[0].period+binary_model[0].epoch)
ea=2*atan(tan((!pi-binary_model[0].periastron/RAD)/2)/sqrt((1+e)/(1-e)))
ma=ea-e*sin(ea)
p2=modelpos((ma/(2*!pi))*binary_model[0].period+binary_model[0].epoch)
plots,[[reform(p1[0,0,*]-p1[0,1,*])],[reform(p2[0,0,*]-p2[0,1,*])]],linestyle=1
;
end
