pro plotdata,edit,reason,overplot=overplot,ms1=ms1,ms2=ms2,status=status, $
	keep_window=keep_window,charsize=charsize
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Main plotting routine. Plots data (2D, 3D), all classes, all slices.
;
; Input parms:
; edit=0: no editing; edit=1: auto; edit=2: zero
; reason: Flag reason (string).
; ms1,ms2: scan structures with other model data to be over-plotted
; Status: 0 if plotting OK, -1 otherwise
;
; Some information on symbols and colors:
; !p.psym=0: no symbol, connect points with lines
;	  1: +
;	  2: *
;	  3: .
;	  4: Diamond
;	  5: Triangle
;	  6: Square
;	  7: x
; tek_color
; !p.color=0: black
;	   1: white
;	   2: red
;	   3: green
;	   4: blue
;	   .
;	   .
;         31: <last color index>
;
common DataSelInfo,class,type,slice,ds_nights,ds_stars,ds_x,ds_y,ds_z,ps_options
common PlotDataInfo,plotscans,plotdata_x,plotdata_y,plotdata_y_bck
common SysConfig,SystemId,Date,MetroConfig,GenConfig,GeoParms,GenInfo,GeoInfo
common Tables,ScanTable,BGTable,StationTable
common StarBase,startable,notes
common FlagTables,pointflagtable,inchflagtable,bgflagtable,scanflagtable
common ScanData,scans,bgscans,bufferinfo,positions,velocities,magnitudes
common Model,gen_model,star_model,binary_model,gen_error,star_error,binary_error
common PointData,Rec0,RecN,Iscan,StarId,PointTime, $
        FDLPos,FDLPosErr,MetroPos,MetroPosErr,GeoDelay,GeoDelayErr, $
        DelayJitter,DelayJitterErr,SoftDelay,SoftDelayErr, $
        NATJitter,NATJitterErr,NATCounts,NATCountsErr, $
        GrpDelay,GrpDelayErr,DryDelay,DryDelayErr,WetDelay,WetDelayErr, $
        PhotonRate,PhotonRateErr,VisSq,VisSqErr, $
        ComplexVis,ComplexVisErr,ComplTriple,ComplTripleErr, $
        VisAmp,VisAmpErr,VisPhase,VisPhaseErr, $
        TripleAmp,TripleAmpErr,TriplePhase,TriplePhaseErr
common InchData,Sol0,SolN,Jscan,MetroTime,FeedVector, $
        ParX,ParXErr,ParY,ParYErr,ParZ,ParZErr,MetroPath,MetroPathErr, $
	MotorAngle,MotorAngleErr
common PlacementInfo,xpix_per_char,ypix_per_char, $
		     title_yoffset,title_xoffset, $
		     xtitle_xoffset,xtitle_yoffset, $
		     ytitle_xoffset,ytitle_yoffset, $
		     num_title,max_star_per_title,xpix_per_star, $
		     num_xtitle,max_xlabel_per_title,xpix_per_xlabel, $
		     num_ytitle,max_ylabel_per_title,xpix_per_ylabel
;
; Status is set to 0 once a plot has been produced
status=-1
;
; If overplot requested, y-axis labels may need to be offset from each other.
; Keyword overplot has value 0 or larger on input, input saved in overploti.
; If overplot is larger than 0, value is copied to counter ovplotno and
; overplot is set to true (value=1).
if n_elements(overplot) eq 0 then overplot=0
if n_elements(ovplotno) eq 0 then ovplotno=0
if overplot eq 0 then ovplotno=0
if overplot ge 1 then begin
	overploti=overplot
	ovplotno=overplot
	overplot=1
endif
;
; Option enables multiple plots for drop_list selected items
if n_elements(keep_window) eq 0 then keep_window=0
;
; Input charsize
if n_elements(charsize) eq 0 then charsize=1.0
;
; Do we want to edit?
if n_params() eq 0 then edit=0
if (edit lt 0) or (edit gt 2) then begin
	print,'***Error(PLOTDATA): invalid editing mode: ',edit,'!'
	return
endif
;
; NoTrace option not selected (default): X-selection will trace Y-selection
if not ps_options.t then begin
	xitem=ds_x.item
	ds_x=ds_y
	ds_x.item=xitem
endif
;
; Check data selection
if printselerror(checkplotsel('x')) ne 0 then return
if printselerror(checkplotsel('y')) ne 0 then return
if printselerror(checkplotsel('z')) ne 0 then return
;
; Set label indices
ax_items=set_axitems(item_ids,units,abbrs)
ax_items=ax_items+units
set_plotlabels,plot_xlabels,xlabel_index,ds_x.item
set_plotlabels,plot_ylabels,ylabel_index,ds_y.item
set_plotlabels,plot_zlabels,zlabel_index,ds_z.item
;
; Initial loop ranges
set_plotloops,'x',num_b_x,num_c_x,num_p_x
set_plotloops,'y',num_b_y,num_c_y,num_p_y
;
; NoTrace option not selected (default): loops controlled by Y-selection
if not ps_options.t then begin
	num_b_x=1
	num_c_x=1
	num_p_x=1
endif
;
; Initialize index counter
numarr=intarr(6,num_b_x*num_c_x*num_p_x*num_b_y*num_c_y*num_p_y)
num_plot=0
;
; Some options conflict
if ps_options.g and ps_options.d then begin
	print,'***Error(PLOT): incompatible options (Select Image or 3D)!'
	return
endif
;
; Check existence of data and prepare a structure array (datascans) holding
; star and time information for the selected data scans/points. It is used
; to select the data for a particular star and to provide time stamps for
; editing.
parms=init_class(class,datascans)
do_info=1
;
; Determine whether automatic scaling is requested
if total(abs(!x.range)) eq 0 then xrange_auto=1 else xrange_auto=0
if total(abs(!y.range)) eq 0 then yrange_auto=1 else yrange_auto=0
if total(abs(!z.range)) eq 0 then zrange_auto=1 else zrange_auto=0
;
; For option All in 1 we have to go through the data twice to find the
; number of plots in a window (num_plot) and the total range of data values.
; However, we now go through it twice anyway to see how many plots we have.
if ps_options.a or ps_options.g then num_run=2 else num_run=2
;
; Initialize the data selection for each stream
set_streamsel,'x',d,xinbeam,xoutbeam,xtriple,x_ds_ch,x_ds_bl,x_ds_pt
set_streamsel,'y',d,yinbeam,youtbeam,ytriple,y_ds_ch,y_ds_bl,y_ds_pt
xitem=ds_x.item
yitem=ds_y.item
zitem=ds_z.item
;
; Check for polar mode az-el plots
if ps_options.v and xitem eq 43 and yitem eq 78 then polar=1 else polar=0
;
; Various checks for editing mode
if edit ne 0 then begin
num_run=1
do_info=0
case class of
	'point':begin
		if n_elements(pointflagtable) eq 0 then create_pointflagtable
		index=where(pointflagtable.time ge 0,count)
		end
	'delay':begin
		if n_elements(pointflagtable) eq 0 then create_pointflagtable
		index=where(pointflagtable.time ge 0,count)
		end
	'scan' :begin
		if n_elements(scanflagtable) eq 0 then create_scanflagtable
		index=where(scanflagtable.time ge 0,count)
		end
	'phot' :begin
		if n_elements(scanflagtable) eq 0 then create_scanflagtable
		index=where(scanflagtable.time ge 0,count)
		end
	'bg'   :begin
		if n_elements(bgflagtable) eq 0 then create_bgflagtable
		index=where(bgflagtable.time ge 0,count)
		end
	'metro':begin
		if n_elements(inchflagtable) eq 0 then create_inchflagtable
		index=where(inchflagtable.time ge 0,count)
		end
	else:	begin
		print,'***Error(PLOTDATA): no editing allowed in this class!'
		return
		end
endcase
id0=count
id=id0
if slice ne 'pt' then begin
	print,'***Error(PLOTDATA): no automatic editing with slice other than pt!'
	return
endif
timestamp=strmid(systime(),0,24)
if n_elements(reason) eq 0 then begin
	reason=''
	read,'Please enter reason: ',reason
endif
reason=timestamp+' '+abbrs[ds_y.item-1]+'_'+reason
print,'Begin editing, REASON='+reason
endif
;
; Loops start here!
FOR run_no=1,num_run DO BEGIN
plot_no=0	; Current (sub)plot number; first plot will be no. 1
;
IF run_no eq 2 AND num_plot gt 0 THEN BEGIN
;
num_pt_x=n_elements(unique(numarr[0,0:num_plot-1]))
num_ch_x=n_elements(unique(numarr[1,0:num_plot-1]))
num_bl_x=n_elements(unique(numarr[2,0:num_plot-1]))
num_pt_y=n_elements(unique(numarr[3,0:num_plot-1]))
num_ch_y=n_elements(unique(numarr[4,0:num_plot-1]))
num_bl_y=n_elements(unique(numarr[5,0:num_plot-1]))
;
; Set number of plots in x and y
case class of
	'point' :begin
		 num_v=num_bl_x*num_bl_y
		 num_h=num_ch_x*num_ch_y
;		 Successive division method
		 if num_v eq 1 or num_h eq 1 then begin
		 	num_t=num_h*num_v
			num_v=num_t
			num_h=1
		 	while num_v/num_h ge 2 do begin
				num_h=num_h+1
				num_v=num_t/num_h
		 		if num_v*num_h lt num_t then num_v=num_v+1
		 	endwhile
		 endif
		 end
	'delay' :begin
		 if slice eq 'ch' then begin
			num_p=num_pt_x*num_pt_y
			num_h=long(sqrt(num_p))
			if num_h*num_h ne num_p then begin
				if num_p-num_h*num_h gt num_h then begin
					num_h=num_h+1
					num_v=num_h
				endif else num_v=num_h+1
			endif else num_v=num_h
		 endif else begin
			num_h=num_bl_x*num_bl_y
			num_v=num_ch_x*num_ch_y
		 endelse
		 end
	'bg'    :begin
;		 Square method
		 num_c=num_ch_x*num_ch_y
		 num_h=long(sqrt(num_c))
		 if num_h*num_h ne num_c then begin
			if num_c-num_h*num_h gt num_h then begin
				num_h=num_h+1
				num_v=num_h
			endif else num_v=num_h+1
		 endif else num_v=num_h
		 end
	'scan'  :begin
;		 Successive division method
		 num_v=num_bl_x*num_bl_y
		 num_h=num_ch_x*num_ch_y*num_pt_x*num_pt_y
;		 If number of plots determined in run 1 is less than expected...
		 if num_plot lt (num_v*num_h) then begin
			num_h=1
			num_v=num_plot
		 endif
		 if num_v eq 1 or num_h eq 1 then begin
		 	num_t=num_h*num_v
		 	num_v=num_t
		 	num_h=1
		 	while num_v/num_h ge 2 do begin
				num_h=num_h+1
				num_v=num_t/num_h
		 		if num_v*num_h lt num_t then num_v=num_v+1
		 	endwhile
		 endif
		 end
	'amoeba':begin
;		 Successive division method
		 num_v=num_bl_x*num_bl_y
		 num_h=num_ch_x*num_ch_y*num_pt_x*num_pt_y
;		 If number of plots determined in run 1 is less than expected...
		 if num_plot lt (num_v*num_h) then begin
			num_h=1
			num_v=num_plot
		 endif
		 if num_v eq 1 or num_h eq 1 then begin
		 	num_t=num_h*num_v
		 	num_v=num_t
		 	num_h=1
		 	while num_v/num_h ge 2 do begin
				num_h=num_h+1
				num_v=num_t/num_h
		 		if num_v*num_h lt num_t then num_v=num_v+1
		 	endwhile
		 endif
		 end
	'astrom':begin
		 num_h=num_bl_x*num_bl_y
		 num_v=num_ch_x*num_ch_y
		 end
	'seeing':begin
		 num_h=num_bl_x*num_bl_y
		 num_v=num_ch_x*num_ch_y
		 end
	'phot'	:begin
		 num_h=1
		 num_v=1
		 end
	'metro' :begin
;		 Successive division method
		 num_h=num_bl_x*num_bl_y
		 num_v=num_ch_x*num_ch_y
		 num_t=num_h*num_v
		 while num_v/num_h ge 2 do begin
			num_h=num_h+1
			num_v=num_t/num_h
		 	if num_v*num_h lt num_t then num_v=num_v+1
		 endwhile
		 end
	'amoeba0':begin
;		 Successive division method
		 num_v=num_bl_x*num_bl_y
		 num_h=num_ch_x*num_ch_y*num_pt_x*num_pt_y
		 num_t=num_h*num_v
		 if num_v eq 1 or num_h eq 1 then begin
			num_v=num_t
			num_h=1
		 	while num_v/num_h ge 2 do begin
				num_h=num_h+1
				num_v=num_t/num_h
		 	endwhile
		 		if num_v*num_h lt num_t then num_v=num_v+1
		 endif else if num_h/num_v gt 3 then begin
;			num_v=num_v+2
;			num_h=num_t/num_v
;			if num_v*num_h lt num_t then num_h=num_h+1
			num_v=num_v*2
			num_h=num_h/2
			if num_v*num_h gt num_plot then begin
				num_h=num_plot/num_v
				if num_v*num_h lt num_plot then num_h=num_h+1
			endif
		 endif
		 end
	'volvox':begin
;		 Successive division method
		 num_v=num_bl_x*num_bl_y
		 num_h=num_ch_x*num_ch_y*num_pt_x*num_pt_y
		 if num_v eq 1 or num_h eq 1 then begin
			num_t=num_h*num_v
			num_v=num_t
			num_h=1
		 	while num_v/num_h ge 2 do begin
				num_h=num_h+1
				num_v=num_t/num_h
		 		if num_v*num_h lt num_t then num_v=num_v+1
		 	endwhile
		 endif
		 end
	else	:begin
		 print,'***Error(PLOTDATA): this class not handled!'
		 return
		 end
endcase
;
!p.charsize=charsize
;
if not keep_window then begin
;
; !p.multi=[#plots remaining,#plot columns,#plot rows,#plots stacked in Z,
;           0:left to right and top to bottom;1:top to bottom and left to right]
;
if not overplot then begin
	if ps_options.a $
	or ps_options.d $
	or ps_options.g then !p.multi=[0,1,1,0,1] $
			else !p.multi=[0,num_h,num_v,0,1]
endif
;
; For multiple plots > 2x2, cancel IDL's reduction of charsize by a factor of 2
; We define factor scale_cs to force same in xyouts, and for plot margins
scale_cs=1
if !p.multi[1] gt 4 or !p.multi[2] gt 4 then begin
	scale_cs=1.5
	!p.charsize=!p.charsize*scale_cs
endif else $
if !p.multi[1] gt 2 or !p.multi[2] gt 2 then begin
	scale_cs=2
	!p.charsize=!p.charsize*scale_cs
endif
;
; Open a plot window for plotting and manual editing on the screen
if (edit eq 0) and (not ps_options.d) $
	       and (not ps_options.g) $
	       and (!d.name ne 'PS') then begin
	if not overplot or !d.window eq -1 then $
	window,/free,title=Date+', Class:'+class,xsize=!xsize,ysize=!ysize, $
		xpos=!dxsize-!xsize,ypos=!dysize-!ysize
; If producing PostScript output
endif else if (edit eq 0) and (not ps_options.d) $
              	 	  and (not ps_options.g) $
	      		  and (!d.name eq 'PS') then begin
	device,color=ps_options.c
	tek_color
	page_size=din_size(landscape)
	set_ps,page_size=page_size,landscape=landscape
endif
;
endif else begin
	scale_cs=1.0	; keep_window
endelse
;
if !d.name eq 'PS' then frame_color=0 else frame_color=1
!p.color=tci(frame_color)
;
; Do not maintain info about plotted data in some cases, e.g. multiple plots
if !p.multi[1]*!p.multi[2] gt 1 then do_info=0
if ps_options.d or ps_options.g then do_info=0
if keep_window then do_info=0
;
; Calculate star title placement variables
; titleplacement,'t',ds_stars,scale_cs=scale_cs
stars=ds_stars
for i=0,n_elements(stars)-1 do $
	stars[i]=startable[where(startable.starid eq stars[i])].name
titleplacement,'t',stars,scale_cs=scale_cs
;
ENDIF	; End of plot preparation of run=1
;
for pt_x=0,num_p_x-1 do begin
for ch_x=0,num_c_x-1 do begin
for bl_x=0,num_b_x-1 do begin
for pt_y=0,num_p_y-1 do begin
for ch_y=0,num_c_y-1 do begin
for bl_y=0,num_b_y-1 do begin
;
;	Set x-axis data
	if ps_options.t then begin
		ch=ch_x
		bl=bl_x
		pt=pt_x
	endif else begin
		ch=ch_y
		bl=bl_y
		pt=pt_y
	endelse
	xchan=x_ds_ch[ch]
	xbase=x_ds_bl[bl]
	xpoint=x_ds_pt[pt]
	case slice of
		'ch':xchan=x_ds_ch
		'bl':xbase=x_ds_bl
		'pt':xpoint=x_ds_pt
	        else:
	endcase
;	If triple data are plotted, OB and CH need to be derived from TR sel.
	if genconfig.numtriple gt 0 then begin
		triple_index=[6,7,28,29,30,31,32,33,58,59]
		index=where(yitem eq triple_index,tr_count)
		if tr_count gt 0 then begin
			xoutbeam=genconfig.triplebeam[0,xtriple]
			xchan=genconfig.triplechan[xchan,0,xtriple]
		endif
	endif
	xdata=dblarr(n_elements(xchan)*n_elements(xbase)*n_elements(xpoint), $
		/nozero)
	xdata[*]=set_plotdata(xitem,xinbeam,xoutbeam,xtriple,xchan,xbase,xpoint)
	xdata_err=xdata
	xdata_err[*]= $
		set_ploterr(xitem,xinbeam,xoutbeam,xtriple,xchan,xbase,xpoint)
;
;	Set y-axis data
	ychan=y_ds_ch[ch_y]
	ybase=y_ds_bl[bl_y]
	ypoint=y_ds_pt[pt_y]
	case slice of
		'ch':ychan=y_ds_ch
		'bl':ybase=y_ds_bl
		'pt':ypoint=y_ds_pt
	        else:
	endcase
	if genconfig.numtriple gt 0 then begin
		index=where(yitem eq triple_index,tr_count)
		if tr_count gt 0 then begin
			youtbeam=genconfig.triplebeam[0,ytriple]
			ychan=genconfig.triplechan[ychan,0,ytriple]
		endif
	endif
	ydata=dblarr(n_elements(ychan)*n_elements(ybase)*n_elements(ypoint), $
		/nozero)
	ydata[*]=set_plotdata(yitem,yinbeam,youtbeam,ytriple,ychan,ybase,ypoint)
	ydata_err=ydata
	ydata_err[*]= $
		set_ploterr(yitem,yinbeam,youtbeam,ytriple,ychan,ybase,ypoint)
;
;	Set z-axis data
	if genconfig.numtriple gt 0 then begin
		index=where(yitem eq triple_index,tr_count)
		if tr_count gt 0 then begin
			youtbeam=genconfig.triplebeam[0,ytriple]
			ychan=genconfig.triplechan[ychan,0,ytriple]
		endif
	endif
	zdata=dblarr(n_elements(ychan)*n_elements(ybase)*n_elements(ypoint), $
		/nozero)
	zdata[*]=set_plotdata(zitem,yinbeam,youtbeam,ytriple,ychan,ybase,ypoint)
;
;	Set ids for all plotted points
	item=yitem
	inbeam=yinbeam
	outbeam=youtbeam
	triple=ytriple
	chan=ychan
	base=ybase
	point=ypoint
	set_sliceids,item,inbeam,outbeam,triple,chan,base,point
;
; 	Automatic flagging; once complete, skip the plotting
	if (edit eq 1 or edit eq 2) then begin
	if class eq 'point' or class eq 'delay' then begin
		MINPOINTS=10
		mv=fltarr(n_elements(Iscan))	; for statistical information
		me=fltarr(n_elements(Iscan))	; for statistical information
		plotscans={y:mv,ye:me}
;		Process on a scan-by-scan basis
	    	FOR n=0,n_elements(Iscan)-1 DO BEGIN
		index=where(point ge Rec0[n] and point le RecN[n],count)
		IF count GT 0 THEN BEGIN
		y=ydata[index]
		e=ydata_err[index]
		p=index
		if edit eq 1 then begin		 	; Edit outliers
;		   Check if last word in REASON indicates a limit
		   words=nameparse(reason)
		   limit=words[n_elements(words)-1]
		   if isnumeric(limit) then limit=float(limit) else limit=0
;
		   index=where(e ge 0,count)
; 		   Do not edit scans with few points (B. Zavala)
;                  if count le MINPOINTS then count=0 (removed: CAH 2011-12-02)
		   if count gt MINPOINTS then begin
			   ye=y[index]
;			   sig=stddev(ye)
			   med=medianve(ye,sig)
			   mv[n]=med
			   me[n]=sig
			   plotscans.y[n]=med
			   plotscans.ye[n]=sig
			   index_outlier=where(abs(y-med) gt (3*sig) $
					and e ge 0,count1)
			   scan_ok=0
			   if sig gt 0 then begin
			   case item[0] of
; 			   Flag all if certain constraint is not met
;				Photonrate
			    8: if sig/med lt 0.1 then scan_ok=1
;				DelayJitter
			   10: begin
			       if med lt limit and med gt 0.1e-6 $
				  and sig lt limit then scan_ok=1
			       if limit eq 0 then scan_ok=1
			       end
;				NATJitter
			   11: if sig lt 0.05 then scan_ok=1
; 				NATCounts
			   12: if sig/med lt 0.1 then scan_ok=1
;			   Default is to use index_outlier
			   else: index=index_outlier
			   endcase
			   endif
			   if scan_ok then index=index_outlier
			   if index[0] ne -1 then count=n_elements(index) $
					     else count=0
		   endif
		endif else if edit eq 2 then begin	; Edit zero/low values
		   index=where(y eq 0,count)
		   if item[0] eq 10 then $
		   index=where(y lt 0.1,count)
		endif
		if count gt 0 then begin
		   if count eq 1 then index=index[0]
		   set_pointflagtable,reason,item[p[index]], $
			inbeam[p[index]],outbeam[p[index]],triple[p[index]], $
			chan[p[index]],base[p[index]], $
			abs(PointTime[point[p[index]]])
		   id=id+count
		endif
		ENDIF
	    	ENDFOR
		if edit eq 1 then begin
;			Temporarily inserted for diagnostics
;			index=where(me gt 0,count)
;			if count gt 0 then begin
;			print,'Median of all values: ',median(mv(index))
;			print,'Median of all median errors: ',median(me(index))
;			print,'Median of normalized errors: ',median(me(index) $
;								    /mv(index))
;			endif
		endif
	endif else if class eq 'metro' then begin
		MINPOINTS=5
	    	for n=0,n_elements(Jscan)-1 do begin
		index=where(point ge Sol0[n] and point le SolN[n],count)
		if count gt 0 then begin
		y=ydata[index]
		e=ydata_err[index]
		p=index
		if edit eq 1 then begin		 	; Edit outliers
		   index=where(e ge 0,count)
		   if count gt MINPOINTS then begin
			   ye=y[index]
			   med=medianve(ye,sig)
;			   sig=stddev(ye)
			   index=where(abs(y-med) gt (5*sig),count)
		   endif
		endif else if edit eq 2 then begin	; Edit zero values
		   index=where(y eq 0,count)
		endif
		if count gt 0 then begin
		   if count eq 1 then index=index[0]
		   set_inchflagtable,reason,item[p[index]],inbeam[p[index]], $
			abs(MetroTime[point[p[index]]])
		   id=id+count
		endif
		endif
	    	endfor
	endif else begin	; all other classes
		index=where(ydata_err gt 0,count)
		if count gt 0 then begin
		x=xdata[index]
		y=ydata[index]
		e=ydata_err[index]
		p=index
		if edit eq 1 then begin
		   	wt=1./e^2
			wt=wt/avg(wt)
			case n_elements(wt) of
		  	 1:coeffs=y
		  	 2:coeffs=poly_fit(x,y,1,measure_errors=e,yfit=yft)
		  	 3:coeffs=poly_fit(x,y,2,measure_errors=e,yfit=yft)
		  	 else:coeffs=poly_fit(x,y,3,measure_errors=e,yfit=yft)
			endcase
		   	sigma=stddev(y-yft)
		   	index=where(abs((y-yft)/sigma) gt 2,count)
	 	endif else index=where(y eq 0,count)
		if count gt 0 then begin
			n=id+count-1
			if count eq 1 then index=index[0]
			case class of
			'scan':begin
			       scanflagtable[id:n].reason=reason
			       scanflagtable[id:n].item=item[p[index]]
			       scanflagtable[id:n].baseline=base[p[index]]
			       scanflagtable[id:n].triple=triple[p[index]]
			       scanflagtable[id:n].channel=chan[p[index]]
			       scanflagtable[id:n].outbeam=outbeam[p[index]]
			       scanflagtable[id:n].inbeam=inbeam[p[index]]
			       scanflagtable[id:n].time= $
				abs(scans[point[p[index]]].time)
			       end
			'bg'  :begin
			       bgflagtable[id:n].reason=reason
			       bgflagtable[id:n].item=item[p[index]]
			       bgflagtable[id:n].channel=chan[p[index]]
			       bgflagtable[id:n].outbeam=outbeam[p[index]]
			       bgflagtable[id:n].time= $
				abs(bgscans[point[p[index]]].time)
			       end
			endcase
			id=n+1
		endif
		endif
	endelse
	goto,SKIPPLOT
	endif
;
;	If there are no valid data, skip the rest unless option f=1
	index=where(xdata_err ge 0 and ydata_err ge 0,count)
	if ps_options.f eq 0 and count eq 0 then goto,SKIPPLOT
	if ps_options.f ne 0 then index=lindgen(n_elements(ydata))
;       We have valid data, so increment the plot number counter
	plot_no=plot_no+1
	numarr[*,plot_no-1]=[pt_x,ch_x,bl_x,pt_y,ch_y,bl_y]
;
;       First, we have to find out about the ranges
	count=n_elements(index)
	jndex=lindgen(count)
	if not xrange_auto and yrange_auto then $
		jndex=where(xdata[index] ge !x.range[0] $
			and xdata[index] le !x.range[1],count)
	if not yrange_auto and xrange_auto then $
		jndex=where(ydata[index] ge !y.range[0] $
			and ydata[index] le !y.range[1],count)
	if count eq 0 then jndex=lindgen(n_elements(index))
	xmin=min(xdata[index[jndex]])
	xmax=max(xdata[index[jndex]])
	ymin=min(ydata[index[jndex]])
	ymax=max(ydata[index[jndex]])
	zmin=min(zdata[index[jndex]])
	zmax=max(zdata[index[jndex]])
;
;       Here we got the range information and can skip the rest if plotting
;       will occur in the second run through the data (All in 1 option).
	if run_no eq 1 then begin
		num_plot=num_plot+1
		if ps_options.g then goto,SKIPPLOT
		if plot_no eq 1 then begin
			axmax=xmax
			axmin=xmin
			aymax=ymax
			aymin=ymin
			azmax=zmax
			azmin=zmin
			p_xdata=xdata
			p_ydata=ydata
			p_xdata_err=xdata_err
			p_ydata_err=ydata_err
			p_item=item
			p_inbeam=inbeam
			p_outbeam=outbeam
			p_triple=triple
			p_chan=chan
			p_base=base
			p_point=point
			p_time=dblarr(n_elements(point),/nozero)
			p_time[*]=datascans[point].time
			p_star=strarr(n_elements(point))
			p_star[*]=datascans[point].starid
		endif else begin
			axmax=max([axmax,xmax])
			axmin=min([axmin,xmin])
			aymax=max([aymax,ymax])
			aymin=min([aymin,ymin])
			azmax=max([azmax,zmax])
			azmin=min([azmin,zmin])
			p_xdata=[p_xdata,xdata]
			p_ydata=[p_ydata,ydata]
			p_xdata_err=[p_xdata_err,xdata_err]
			p_ydata_err=[p_ydata_err,ydata_err]
			p_item=[p_item,item]
			p_inbeam=[p_inbeam,inbeam]
			p_outbeam=[p_outbeam,outbeam]
			p_triple=[p_triple,triple]
			p_chan=[p_chan,chan]
			p_base=[p_base,base]
			p_point=[p_point,point]
			p_time=[p_time,datascans[point].time]
			p_star=[p_star,datascans[point].starid]
		endelse
		goto,SKIPPLOT
	endif
;
;       Set the ranges for plotting
	if ps_options.a and not ps_options.g then begin
		xmax=axmax
		xmin=axmin
		ymax=aymax
		ymin=aymin
		zmax=azmax
		zmin=azmin
	endif
	if xmax eq xmin then begin
		xmax=xmax+1
		xmin=xmin-1
	endif
	if ymax eq ymin then begin
		ymax=ymax+1
		ymin=ymin-1
	endif
	if zmax eq zmin then begin
		zmax=zmax+1
		zmin=zmin-1
	endif
	if class eq 'bg' then ymin=-0.1
	if yitem[0] eq 93 or yitem[0] eq 94 then ymin=0
;	For vis. plots, set lower limit to zero in auto mode
	if yitem[0] ge 24 and yitem[0] le 33 then ymin=0
	if xrange_auto then !x.range=[xmin,xmax] else !x.style=1
	if yrange_auto then !y.range=[ymin,ymax] else !y.style=1
	if zrange_auto then !z.range=[zmin,zmax] else !z.style=1
;
;	Prepare the axis labels
	xlabels=plot_xlabels
	xlabels[0]=plot_xlabels[0]+strcompress(string(xinbeam[0]+1))
	xlabels[1]=plot_xlabels[1]+strcompress(string(xoutbeam[0]+1))
	xlabels[2]=plot_xlabels[2]+strcompress(string(xtriple[0]+1))
	xlabels[3]=plot_xlabels[3]+strcompress(string(xbase[0]+1))
	xlabels[4]=plot_xlabels[4]+strcompress(string(xchan[0]+1))
	xlabels[5]=plot_xlabels[5]+strcompress(string(xpoint[0]+1))
	xlabel=''
	if xlabel_index[0] ne -1 then begin
	   xlabels=xlabels[xlabel_index]
	   for i=0,n_elements(xlabels)-1 do xlabel=xlabel+xlabels[i]
	endif
	ylabels=plot_ylabels	; IB  OB  Tr  Bl  Ch  Pt
	ylabels[0]=plot_ylabels[0]+strcompress(string(yinbeam[0]+1))	; 0
	ylabels[1]=plot_ylabels[1]+strcompress(string(youtbeam[0]+1))	; 1
	ylabels[2]=plot_ylabels[2]+strcompress(string(ytriple[0]+1))	; 2
	ylabels[3]=plot_ylabels[3]+strcompress(string(ybase[0]+1))	; 3
	ylabels[4]=plot_ylabels[4]+strcompress(string(ychan[0]+1))	; 4
	ylabels[5]=plot_ylabels[5]+strcompress(string(ypoint[0]+1))	; 5
	ylabel=''
	if ylabel_index[0] ne -1 then begin
	   ylabels=ylabels[ylabel_index]	; e.g., OB 1 Bl 1 Pt 71
;	   Human-readable labels...
;	   Station labels			; e.g., IB 1
	   if ylabel_index[0] eq 0 then begin
		words=nameparse(ylabels[0],[' ']) ; ignore ref. station
		ib=fix(words[1])
		ylabel=genconfig.stationid[ib-1]
	   endif else $
;	   Baseline labels			; e.g.: OB 1 Bl 1 Pt 71
	   if ylabel_index[0] eq 1 and ylabel_index[1] eq 3 then begin
		ob=fix(strmid(ylabels[0],3,2))
		bl=fix(strmid(ylabels[1],3,2))
		ylabel=genconfig.baselineid[bl-1,ob-1]
		if strmid(ylabel,0,1) eq 'A' and systemid eq 'VLTI' then begin
			words=nameparse(ylabel,'-')
			ylabel=strmid(words[0],1,2)+'-'+strmid(words[1],1,2)
		endif else if systemid eq 'NPOI/6way' then begin
			ylabel=ylabel+ylabels[0]
		endif
		ylabel=ylabel+ylabels[2]	; add Pt info
	   endif else $
;	   Triple labels			; e.g., Tr 1 Pt 71
	   if ylabel_index[0] eq 2 then begin
		tr=fix(strmid(ylabels[0],3,2))
		fBaseFactors=tripleconfig(tr)
		b=genconfig.baselineid[genconfig.triplebase[*,tr-1], $
				       genconfig.triplebeam[*,tr-1]]
		for l=0,2 do if fBaseFactors[l] eq -1 then b[l]=breve(b[l])
		b=strsplit(strjoin(b,'-'),'-',/extract)
		ylabel=strjoin(unique(b),'-')
		if strmid(ylabel,0,1) eq 'A' and systemid eq 'VLTI' then begin
			words=nameparse(ylabel,'-')
			ylabel=strmid(words[0],1,2)+'-'$
			      +strmid(words[1],1,2)+'-'$
			      +strmid(words[2],1,2)+ylabels[1]
		endif else if systemid eq 'NPOI/6way' then begin
			ylabel=ylabel	; work in progress
		endif
	   endif else begin
;	   ...the default
	   for i=0,n_elements(ylabels)-1 do ylabel=ylabel+ylabels[i]
	   endelse
	endif
;	Remove Pt label if data are of a single scan
	if n_elements(scans) eq 1 and strpos(ylabel,'Pt') ge 0 then $
		ylabel=strmid(ylabel,0,strpos(ylabel,'Pt'))
	zlabels=plot_zlabels
	zlabels[0]=plot_zlabels[0]+strcompress(string(yinbeam[0]+1))
	zlabels[1]=plot_zlabels[1]+strcompress(string(youtbeam[0]+1))
	zlabels[2]=plot_zlabels[2]+strcompress(string(ytriple[0]+1))
	zlabels[3]=plot_zlabels[3]+strcompress(string(ybase[0]+1))
	zlabels[4]=plot_zlabels[4]+strcompress(string(ychan[0]+1))
	zlabels[5]=plot_zlabels[5]+strcompress(string(ypoint[0]+1))
	zlabel=''
	if zlabel_index[0] ne -1 then begin
	   zlabels=zlabels[zlabel_index]
	   for i=0,n_elements(zlabels)-1 do zlabel=zlabel+zlabels[i]
	endif
;
	if xlabel eq '' then num_xlabel=0 else num_xlabel=num_plot
	if ylabel eq '' then num_ylabel=0 else num_ylabel=num_plot
	if zlabel eq '' then num_zlabel=0 else num_zlabel=num_plot
	xtitle=ax_items[long(where(item_ids eq xitem[0]),0)]
	ytitle=ax_items[long(where(item_ids eq yitem[0]),0)]
	ztitle=ax_items[long(where(item_ids eq zitem[0]),0)]
	if not ps_options.a and not ps_options.g then begin
		xcomma=', '
		ycomma=', '
		zcomma=', '
;		The following commented for paper on HD 98660
		if 0 then begin
		if !p.multi[2] gt 2 then begin
			xtitle=ytitle+' vs '+xtitle
			ytitle=''
			ycomma=''
		endif
		endif
		if num_xlabel gt 0 then xtitle=xtitle+xcomma+xlabel
		if num_ylabel gt 0 then ytitle=ytitle+ycomma+ylabel
		if num_zlabel gt 0 then ztitle=ztitle+zcomma+zlabel
	endif else if plot_no eq 1 then begin
		titleplacement,'x',ds_stars,xlabel,num_xlabel
		titleplacement,'y',ds_stars,ylabel,num_ylabel
	endif
;
;	Plot frame
;	Image
	if ps_options.g then begin
		if plot_no eq 1 then begin
		xpix=n_elements(ydata)
		ypix=num_plot
		y_image=bytarr(xpix,num_plot)
		y_image_err=fltarr(xpix,num_plot)
		rebin_xfactor=max([!xsize/xpix,1])
		rebin_yfactor=min([20,!ysize/ypix])
		xmargin=[50,20]
		ymargin=[50,(num_title+2)*ypix_per_char]
		xsize=!xsize+total(xmargin)
		ysize=rebin_yfactor*ypix+total(ymargin)
		window,/free,title='Class:'+class,xsize=xsize,ysize=ysize, $
			xpos=!dxsize-!xsize,ypos=!dysize-!ysize
		xpix_t=float(xpix)
		while xpix_t gt !xsize do xpix_t=xpix_t/2
		xfactor=(xsize-total(xmargin))/xpix_t
		plot,indgen(num_plot), $
		     indgen(num_plot),/nodata,/device, $
		     xtitle=ytitle+' image',ytitle='',title='', $
		     xrange=[0,xfactor*xpix/rebin_xfactor], $
		     yrange=[0,num_plot],xminor=-1, $
		     xstyle=1,yticks=num_plot, $
		     ystyle=1,ytickformat='(i2)', $
		     xticklen=-10.0/ysize, $
		     yticklen= -5.0/xsize, $
		     position=[xmargin[0]-1,ymargin[0]-1, $
			       xsize-xmargin[1], $
			       ysize-ymargin[1]]
		titleplacement,'t',ds_stars
		for is=0,n_elements(ds_stars)-1 do begin
			title_index=is/max_star_per_title
			xyouts,title_xoffset[title_index] $
				+(is mod max_star_per_title)*xpix_per_star, $
       				title_yoffset[title_index],ds_stars[is], $
				size=!p.charsize/scale_cs, $
       				/device,color=tci((is mod 30)+2)
		endfor
		endif
;	3D
	endif else if ps_options.d then begin
		if plot_no eq 1 then begin
		pos=[0.1,0.1,0.9,0.9,0.1,0.9]
		plot,xdata,ydata,/nodata,/t3d,position=pos, $
			xtitle=xtitle,ytitle=ytitle,charsize=2.0
		xscale=!x.s
		yscale=!y.s
		t3d,/xzexch
		xrange=!x.range
		!x.range=!z.range
		plot,zdata,ydata,/nodata,/t3d,/noerase,pos=pos,xtitle=ztitle, $
			charsize=2.0
		zscale=!x.s
		!x.range=xrange
		t3d,/xzexch
		t3d,/yzexch
		yrange=!y.range
		!y.range=!z.range
		plot,xdata,zdata,/nodata,/t3d,/noerase,pos=pos
		t3d,/yzexch
		!y.range=yrange
		!x.s=xscale
		!y.s=yscale
		!z.s=zscale
		endif
;	All in 1
	endif else if ps_options.a then begin
		if plot_no eq 1 then begin
		if num_xlabel eq 0 then ymrgn=3 else ymrgn=4
		pos=[ $
		 num_ytitle*xpix_per_ylabel+9*xpix_per_char, $
		 num_xtitle*ypix_per_char+ymrgn*ypix_per_char, $
		 !d.x_vsize-3*xpix_per_char, $
		 !d.y_vsize-(num_title+1)*ypix_per_char]
		!x.title=xtitle
		!y.title=ytitle
		if not overplot then $
		plot,xdata,ydata,/nodata,position=pos,/device,title='', $
			xtype=!x.type,ytype=!y.type
		if not ps_options.p and not overplot then $
		xyouts,1.0-float(ypix_per_char)/!d.x_size,!y.window[1], $
			GenConfig.Date+' '+GenConfig.configid,/normal, $
			orientation=-90,size=!p.charsize/scale_cs
		if ps_options.p and not overplot then $
		xyouts,!x.window[0]+0.05,0.90-float(xpix_per_char)/!d.y_size, $
			GenConfig.Date,/normal,size=!p.charsize/scale_cs
		x1=!x.crange[0] & x2=!x.crange[1]
           	xrange=x2-x1 & x1=x1-0.1*xrange & x2=x2+0.1*xrange
;          	oplot,[x1,x2],[0.0,0.0],psym=0,linestyle=0,thick=1
		endif
;	Standard
	endif else begin
		if max([abs(!y.range[1]),abs(!y.range[0])]) gt 10000 or $
		   max([abs(!y.range[1]),abs(!y.range[0])]) lt 1./10 then $
			xmrgn=14 else xmrgn=8
		if abs((!y.range[1]+!y.range[0]) $
		      /(!y.range[1]-!y.range[0])) gt 10000 then xmrgn=17
	        ymrgn=4
		if !d.name eq 'PS' then begin
;			xmrgn=xmrgn-3
;			ymrgn=ymrgn-2
		endif
		!x.title=xtitle
		!y.title=ytitle
		if polar then begin
		  !x.range=0
		  !y.range=0
		  plot,fltarr(360)+90,findgen(360)/180*!pi, $
			xmargin=[xmrgn,3],title='', $
			ymargin=[ymrgn,1+(num_title)], $
			xtype=!x.type,ytype=!y.type,ytick_get=yv,psym=0, $
			/polar
		endif else begin
		  if ps_options.p and num_plot gt 1 then begin
			!p.title='('+alphabet(plot_no)+')'
			!p.title=''
		  endif else !p.title=''
		  plot,xdata,ydata,/nodata,xmargin=[xmrgn,3], $
			ymargin=[ymrgn,1+(num_title)], $
			xtype=!x.type,ytype=!y.type,ytick_get=yv
		endelse
		if plot_no eq 1 and not ps_options.p then $
		xyouts,1.0-float(ypix_per_char)/!d.x_size,!y.window[1], $
			GenConfig.Date+' '+GenConfig.configid,/normal, $
			orientation=-90,size=!p.charsize/scale_cs
		if plot_no eq 1 and ps_options.p then $
		xyouts,!x.window[0]+0.05,0.90-float(xpix_per_char)/!d.y_size, $
			GenConfig.Date,/normal,size=!p.charsize/scale_cs
		x1=!x.crange[0] & x2=!x.crange[1]
           	xrange=x2-x1 & x1=x1-0.1*xrange & x2=x2+0.1*xrange
           	oplot,[x1,x2],[0.0,0.0],psym=0,linestyle=0,thick=1
;		Some plot specific axis labeling
		if system_id(SystemId) eq 'NPOI' then begin
			case yitem[0] of
			11: 	begin
				ben_rms=[0.35,0.30,0.25,0.20,0.15,0.10,0.05] $
				       *sqrt(2)
				ben_bno=['B0','B1','B2','B3','B4','B5','B6']
				for l=0,n_elements(ben_rms)-1 do $
				if ben_rms[l] gt !y.crange[0] $
				and ben_rms[l] lt !y.crange[1] $
				then xyouts,!x.crange[1] $
					-0.05*(!x.crange[1]-!x.crange[0]), $
					    ben_rms[l],ben_bno[l]
				end
			else:
			endcase
		endif
	endelse
;
	status=0
	plotted=0
;
;	Fill in and plot image here
	if ps_options.g then begin
		if ps_options.f eq 0 then begin
			index=where(ydata_err ge 0,count)
			if count eq 0 then goto,NOIMAGE
			maxv=max(ydata[index])
			minv=min(ydata[index])
		endif else begin
			maxv=max(ydata)
			minv=min(ydata)
		endelse
;		Use color indices 32 to 255 (grey scales in ct0)
		if maxv-minv eq 0 then begin
			maxv=1.0
			minv=-1.0
		endif
		y_image[*,plot_no-1]=byte((ydata-minv)/(maxv-minv)*223+32)
		y_image_err[*,plot_no-1]=ydata_err
;
;		Display if image array complete
		if plot_no eq num_plot then begin
			if ps_options.f eq 0 then begin
				index=where(y_image_err lt 0,count)
				if count gt 0 then y_image[index]=0
			endif
			while xpix gt !xsize do begin
			y_image=y_image[where((indgen(xpix) mod 2) ne 0,count),*]
			xpix=count
			endwhile
			tv,rebin(y_image, $
				 xpix*rebin_xfactor, $
				 ypix*rebin_yfactor,/sample), $
					xmargin[0],ymargin[0]
		endif
		plotted=1
		goto,SKIPPLOT
	endif
;
;       Now we plot one star after the other....................................
;	if class eq 'scan' and ps_options.a then !p.psym=0
	dobgrms=1
	for is=0,n_elements(ds_stars)-1 do begin
;
		ic=where(startable.starid eq ds_stars[is]) & ic=ic[0]
		ds_star=startable[ic].name
		if strlen(strcompress(ds_star,/remove_all)) eq 0 $
				      then ds_star=ds_stars[is]
;		if strlen(strcompress(ds_star,/remove_all)) eq 0 $
;				      then ds_star=startable(ic).var
		if strpos(systemid,'NPOI') ge 0 then ds_star=ds_stars[is]
;
;		We use different plot symbols for different stars
		if class eq 'amoeba' and ps_options.a then begin
			!p.psym=getsymbol(is+1)
		endif
;
;		Find out which scans/points correspond to current star
		stars=datascans[point].starid
		index=where(stars eq ds_stars[is],count)
		if count eq 0 then goto,NODATA
;
;		Set data
		x=xdata[index]
		y=ydata[index]
		z=zdata[index]
		x_err=xdata_err[index]
		y_err=ydata_err[index]
		e_index=index
;
;            	Edit the data
		if (ps_options.f eq 0) or (edit eq 1) then begin
			x_index=where(x_err ge 0,count)
			if count eq 0 then goto,NODATA
			xe=x[x_index]
			ye=y[x_index]
			ze=z[x_index]
			xe_err=x_err[x_index]
			ye_err=y_err[x_index]
			e_index=e_index[x_index]
			y_index=where(ye_err ge 0,count)
			if count eq 0 then goto,NODATA
			xe=xe[y_index]
			ye=ye[y_index]
			ze=ze[y_index]
			ye_err=ye_err[y_index]
			xe_err=xe_err[y_index]
			e_index=e_index[y_index]
		endif else begin
			xe=x
			ye=y
			ze=z
			xe_err=x_err
			ye_err=y_err
		endelse
;
;		Sort the data if neccessary; note that suffix e is reused!
		check=[1,2,19,20,22,23]
		if long(where(check eq xitem),0) eq -1 $
	 		and not ps_options.n then si=sort(xe) $
			else si=lindgen(count)
		x=xe[si]
		y=ye[si]
		z=ze[si]
		x_err=xe_err[si]
		y_err=ye_err[si]
		e_index=e_index[si]
;
;		Add star to star title
		if n_elements(ds_stars) gt 1 $
			and (not ps_options.a or class eq 'seeing') then $
			!p.color=getcolor(ic)
		title_index=is/max_star_per_title
		if not ps_options.p then $
		xyouts,title_xoffset[title_index] $
			+(is mod max_star_per_title)*xpix_per_star, $
;		       title_yoffset(title_index),ds_stars(is), $
		       title_yoffset(title_index),ds_star, $
		       /device,size=!p.charsize/scale_cs
;
;		Add data selection title for All in 1 option
		if ps_options.a then !p.color=getcolor(plot_no-1)
		if class eq 'seeing' then !p.color=tci(frame_color)
		if ps_options.a and (not ps_options.d) then begin
			title_index=(plot_no-1)/max_ylabel_per_title
			if num_ylabel eq 0 then title_index=0
			xyouts,ytitle_xoffset[title_index], $
			       ytitle_yoffset[title_index]+ $
			       ((ovplotno+plot_no-1) mod max_ylabel_per_title) $
					*ypix_per_char, $
			       ylabel,/device,size=!p.charsize
			title_index=(plot_no-1)/max_xlabel_per_title
			if num_xlabel eq 0 then title_index=0
			xyouts,xtitle_xoffset[title_index]+ $
			       ((ovplotno+plot_no-1) mod max_xlabel_per_title) $
					*xpix_per_xlabel, $
			       xtitle_yoffset[title_index], $
			       xlabel,/device,size=!p.charsize
		endif
		if class eq 'seeing' then !p.color=getcolor(ic)
;
;		Preparation for plotting...
		if n_elements(x) gt 100 then !p.psym=3
		if ps_options.e then psym=3 else psym=!p.psym
		if ps_options.l then psym=-abs(psym) else psym=abs(psym)
		if ps_options.d then plots,x,y,z,psym=psym,/t3d else begin
;		Custom option for scaling visibilities
		if ps_options.m and ps_options.v then begin
			mitem=0
			if yitem eq 25 then mitem=57
			if yitem eq 29 then mitem=58
			if yitem eq 33 then mitem=59
			if mitem ne 0 then begin
			ymodel=set_plotdata(mitem,yinbeam,youtbeam, $
					    ytriple,ychan,ybase,ypoint)
			ymodel=ymodel[e_index]
			case mitem of
			59:	begin
				if n_elements(ymodel) eq 1 $
					then ymodel=fltarr(1)+ymodel
				nf=100
				f=findgen(nf+1)/2-nf/4 & r=f
				rad=180/!pi
				for i=0,nf $
					do r[i]=total(((y+f[i]-ymodel)/y_err)^2)
				i=where(r eq min(r)) & i=i[0]
				y=y+f[i]
				end
			else:	begin
				if n_elements(ymodel) eq 1 $
					then ymodel=fltarr(1)+ymodel
				nf=140
				f=findgen(nf+1)/100+(1.0-nf/200.) & r=f
				nf=125
				f=findgen(nf+1)*0.03+0.25 & r=f
				for i=0,nf $
					do r[i]=total(((y*f[i]-ymodel)/y_err)^2)
				i=where(r eq min(r)) & i=i[0]
				y=y*f[i]
				print,'Floating cal. factor=' $
					+string(f[i],format='(f5.2)') $
					+' ('+date+')'
				end
			endcase
			endif
		endif else if ps_options.v then begin
;		Nothing here yet
		endif
;		index=where(x ge !x.crange(0) and x le !x.crange(1) $
;			and y ge !y.crange(0) and y le !y.crange(1),count)
;		if count ge 1 then begin
;		x=x(index)
;		y=y(index)
;		y_err=y_err(index)
;
;		Plot the data
		if polar then oplot,x,y,psym=psym,/polar $
			 else oplot,x,y,psym=psym
;		oploterr modifies the input variable!
		y_err_bck=y_err
		if ps_options.e then begin
			if n_elements(x) gt 1 $
			then oploterror,x,y,y_err,errcolor=!p.color,psym=3 $
			else oploterror,[x[0],x[0]],[y[0],y[0]], $
				[y_err[0],y_err[0]],errcolor=!p.color,psym=3
		endif
		y_err=y_err_bck
;		endif	; Do not overplot region of first plot
;
;		Display the rms for back ground plots
		if class eq 'bg' and not ps_options.a and dobgrms then begin
			if ps_options.f then index=indgen(n_elements(ydata)) $
					else index=where(ydata_err gt 0)
			if n_elements(index) gt 1 then begin
			rms='RMS[%] = '+string(stddev(ydata[index]) $
					      /avg(ydata[index])*100, $
						format='(f5.1)')
			xyouts,!x.crange[0]+0.04*(!x.crange[1]-!x.crange[0]), $
			       !y.crange[0]+0.05*(!y.crange[1]-!y.crange[0]), $
			       rms,color=tci(1),size=!p.charsize/scale_cs
			dobgrms=0
			endif
		endif
;
;		Plot a model if requested
		!p.color=tci(frame_color)
		mitem=0
		if ps_options.m then begin
			if yitem eq 25 then mitem=57
			if yitem eq 29 then mitem=58
			if yitem eq 33 then mitem=59
			if yitem eq 91 then mitem=92
			if yitem eq 94 then mitem=95
			if mitem ne 0 then begin
			ymodel=set_plotdata(mitem,yinbeam,youtbeam, $
					    ytriple,ychan,ybase,ypoint)
			ymodel=ymodel[e_index]
			if n_elements(ymodel) eq 1 then ymodel=fltarr(1)+ymodel
;
;			Fill in more model values for a smoother plot
			if (system_id(systemid) eq 'NPOI' $
			or system_id(systemid) eq 'VLTI' $
			or system_id(systemid) eq 'CHARA') $
			and ps_options.s $
;			and class eq 'scan' $
			and (xitem eq 45 or xitem eq 46) then begin
;			Make copies of scans, genconfig
			s=scans
			g=genconfig
;			Convert uvw to m
			uvw=scans[ypoint].uvw ; #OB,#Ch,#Bl,3
			for i=0,genconfig.numoutbeam-1 do begin
			for j=0,genconfig.numbaseline[i]-1 do begin
			for k=0,2 do uvw[i,*,j,k] $
				      =uvw[i,*,j,k] $
				      *genconfig.wavelength[*,i]
			endfor
			endfor
;			Only data plotted versus channel or lambda
			if yitem eq 33 then begin
				outbeam=genconfig.triplebeam[0,ytriple]
				n=genconfig.triplenumchan[ytriple]
			endif else begin
				outbeam=youtbeam
				n=genconfig.numspecchan[youtbeam]
			endelse
			xdata_n=findgen(n)
			nf=8	; Fill-in multiplication factor
			nc=n*nf
			xdata_nc=findgen(nc)/(nc-1)*(n-1)
			if yitem eq 33 then begin
;				Assume same channels are combined!
				lambda=genconfig.wavelength[g.triplechan[0:n-1,$
						outbeam,ytriple],outbeam]
				chanwi=genconfig.chanwidth[g.triplechan[0:n-1,$
						outbeam,ytriple],outbeam]
			endif else begin
				lambda=genconfig.wavelength[0:n-1,youtbeam]
				chanwi=genconfig.chanwidth[0:n-1,youtbeam]
			endelse
			lambda_nc=spline(xdata_n,lambda,xdata_nc)
			chanwi_nc=spline(xdata_n,chanwi,xdata_nc)
			for ni=0,nf-1 do begin
				if yitem eq 33 then begin
					for k=0,2 do begin
					outbeam=genconfig.triplebeam[k,ytriple]
					obase=genconfig.triplebase[k,ytriple]
					genconfig.wavelength[0:n-1,outbeam]= $
						lambda_nc[ni*n:(ni+1)*n-1]
					genconfig.chanwidth[0:n-1,outbeam]= $
						chanwi_nc[ni*n:(ni+1)*n-1]
;					Convert uvw to [lambda]
					for l=0,2 do $
					scans[ypoint].uvw(outbeam,*,obase,l) $
						     =uvw[outbeam,*,obase,l] $
					/genconfig.wavelength[*,outbeam]
					endfor
				endif else begin
					genconfig.wavelength[0:n-1,outbeam]= $
						lambda_nc[ni*n:(ni+1)*n-1]
					genconfig.chanwidth[0:n-1,outbeam]= $
						chanwi_nc[ni*n:(ni+1)*n-1]
;					Convert uvw to [lambda]
					for k=0,2 do $
					scans[ypoint].uvw(youtbeam,*,ybase,k) $
						     =uvw[youtbeam,*,ybase,k] $
					/genconfig.wavelength[*,youtbeam]
				endelse
;				This does not work if uv inconsistent with coord
;				calcastrom,/quiet,/skipuv
				calcmodel,/noload,/quiet
				y=set_plotdata(mitem,yinbeam,youtbeam, $
					ytriple,ychan,ybase,ypoint)
				if ni eq 0 then ymodel=reform(y) $
					   else ymodel=[ymodel,reform(y)]
			endfor
			if xitem eq 45 then x=lambda_nc*1e6 $
				       else x=xdata_nc+1
			si=sort(x)
			x=x[si]
			ymodel=ymodel[si]
			scans=s
			genconfig=g
			endif	; valid mitem
;
;			Plot the model data
			if n_elements(x) eq 1 then psym=1 else psym=-3
			if ps_options.c then mc=tci(2) else mc=tci(frame_color)
			oplot,x,ymodel,psym=psym,thick=1,color=mc
			if keyword_set(ms1) then begin
				ds=scans
				scans=ms1
				ymodel=set_plotdata(mitem,yinbeam,youtbeam, $
						    ytriple,ychan,ybase,ypoint)
				ymodel=ymodel[e_index]
				scans=ds
				if n_elements(ymodel) eq 1 then $
					ymodel=fltarr(1)+ymodel
				oplot,x,ymodel,psym=-3,linestyle=2
			endif
			if keyword_set(ms2) then begin
				ds=scans
				scans=ms2
				ymodel=set_plotdata(mitem,yinbeam,youtbeam, $
						    ytriple,ychan,ybase,ypoint)
				ymodel=ymodel[e_index]
				scans=ds
				if n_elements(ymodel) eq 1 then $
					ymodel=fltarr(1)+ymodel
				oplot,x,ymodel,psym=-3,linestyle=1
			endif
			endif
		endif
;
;		Plot flagged data (ps_options.f=1)
		if ps_options.f then begin
		!p.color=tci(2)
		index=where(x_err lt 0 or y_err lt 0,count)
		if count ne 0 then begin
			oplot,x[index],y[index],psym=psym
			if ps_options.e then begin
				if n_elements(index) gt 1 then begin
				      oploterror,x[index], $
					y[index],x[index]*0,abs(y_err[index]), $
					errcolor=!p.color
				endif else begin
				      x1=x[index[0]]
				      y1=y[index[0]]
				      e1=abs(y_err[index[0]])
				      oploterror,[x1,x1], $
					[y1,y1],[0,0],[e1,e1], $
					errcolor=!p.color
				endelse
			endif
		endif
		!p.color=tci(frame_color)
		endif
		endelse	; else clause for non-3D plotting
		plotted=1
	NODATA:
	endfor	; End of star plotting loop.....................................
;
	NOIMAGE:
	if not plotted then plot_no=plot_no-1
	SKIPPLOT:
endfor
endfor
endfor
endfor
endfor
endfor
;
ENDFOR	; End of all plotting
;
; Display alert if no data was found to be valid
if plot_no eq 0 and edit eq 0 then begin
	print,'No data for '+Date
endif else if ps_options.m then begin
; Display alert if model was requested but not available, etc.
	if mitem eq 0 then $
		print,'Warning: Must plot calibrated data with model!'
	if n_elements(star_model) eq 0 then begin
		print,'Warning(PLOTDATA): no model!'
	endif else begin
	index=where(ds_stars eq gen_model.starid,count)
	if count eq 0 then $
		print,'Warning(PLOTDATA): model StarID not found!'
	endelse
endif
;
; Set PlotDataInfo variables
if do_info and plot_no gt 0 then begin
	plotscans={x:p_xdata,y:p_ydata,xe:p_xdata_err,ye:p_ydata_err, $
		    item:p_item,star:p_star,time:p_time, $
		    ib:p_inbeam,ob:p_outbeam,tr:p_triple, $
		    ch:p_chan,bl:p_base,pt:p_point}
	plotdata_x=p_xdata
	plotdata_y=p_ydata
	plotdata_y_bck=plotscans.y
endif
;
; Apply the flags to the data
if edit ne 0 then begin
	if id gt id0 then begin
		case class of
			'point':flagpointdata,pointflagtable[id0:id-1],flag=1
			'metro':flaginchdata,inchflagtable[id0:id-1],flag=1
			'delay':flagpointdata,pointflagtable[id0:id-1],flag=1
			'scan' :flagscandata,scanflagtable[id0:id-1],flag=1
			'bg'   :flagbgdata,bgflagtable[id0:id-1],flag=1
		endcase
	endif else print,'No data flagged.'
endif
;
; Reset plot ranges, colors, ...
if xrange_auto then !x.range=0
if yrange_auto then !y.range=0
if zrange_auto then !z.range=0
!p.color=tci(1)
!x.title=''
!y.title=''
;
; Restore input value of overplot
if overplot gt 0 then overplot=overploti
;
end
