pro plotellipse,overplot
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
common FitAstrometry,ellipse_options,orbit_options,e_parms,o_parms
common Constants,c_light,pi_circle,e_euler,i_complex,a_disp,b_disp
;
if n_elements(overplot) eq 0 then overplot=1 else overplot=0
;
if overplot and !d.window eq -1 and !d.name eq 'X' then begin
        print,'***Error(PLOTELLIPSE): no plot window currently open!'
        return
endif
if n_elements(e_parms) eq 0 then begin
	print,'***Error(PLOTELLIPSE): e_parms undefined!'
	return
endif
;
n=90
p=(findgen(n+1)/n)*2*pi_circle
;
r=ellipse(e_parms[2],e_parms[3],p-e_parms[4])
x=r*sin(p)+e_parms[0]
y=r*cos(p)+e_parms[1]
;
; Try to equalize the x and y range
!x.range=[max(x),min(y)]
xl=!x.range[0]-!x.range[1]
!y.range=[min(y),max(y)]
yl=!y.range[1]-!y.range[0]
if yl gt xl then begin
	!x.range=!x.range*yl/xl
	!x.range=!x.range-mean(!x.range)
endif
if yl lt xl then begin
	!x.range=!x.range*xl/yl
	!x.range=!x.range-mean(!x.range)
endif
;
if overplot then oplot,x,y else plot,x,y;, $
;	xrange=[max(x),min(x)],yrange=[min(y),max(y)]
;
end
