pro plotfov,stations=stations,dl=dl,bc=bc,polar=polar,iss=iss
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Plot a diagram indicating the hour angle range as a function of declination
; of a star to be observable with stations. If stations are not specified,
; ignore the delay limits; otherwise, fake the data and flag all data outside
; these limits.
;
common StarBase,startable,notes
common SysConfig,SystemId,Date,MetroConfig,GenConfig,GeoParms,GenInfo,GeoInfo
common LocalRiseSet,date_p,system_p,stars_p,stations_p, $
                times,gst,za_sun,za_moon,ha_moon,az_moon, $
                za_star_p,ha_star_p,az_star_p, $
                sun_ok,moon_ok,zas_ok,sid_ok_p,fdl_ok_p
;
if n_elements(systemid) eq 0 then begin
	systemid=''
	read,prompt='Please enter systemid/instrument: ',systemid
	systemid=strupcase(systemid)
;	systemid='NPOI'
endif
;
if n_elements(polar) eq 0 then polar=0
;
; Call external ISS shadow code if iss=1
if n_elements(iss) eq 0 then iss=0
;
; Save startable
if n_elements(startable) ne 0 then startable_bck=startable
;
; Create list of artificial stars
n=19
n=37
get_startable,'BSC'+string(indgen(n)+1,format='(i4.4)')
startable.dec=-90+findgen(n)*(180/(n-1))
startable.ra=0
parseidldate,systime(),y,m,d
Date=nextdate(constrictordate(y,m,d))
get_sysconfig,stations=stations
;
; Overwrite configuration
if n_elements(dl) ne 0 then genconfig.delaylineid=dl
if n_elements(bc) ne 0 then genconfig.bcinputid=bc
get_stationtable
;
; get_geoparms
startable.ra=ut12gst(0,0)
;
if n_elements(stations) ne 0 then begin
;	fakescans,stations,dutycycle=0.05
;	roseset,uptime
;	riseset now can handle constraints such as FDL, etc.
	riseset,uptime,/force,iss=iss
endif else riseset,uptime,/force,iss=iss
si=where(total(uptime,1) ne 0,count)
ha=uptime/3600+geoparms.longitude/360*24
h=[reform(ha[0,si]),reform(ha[1,reverse(si)])]
d=[startable[si].dec,startable[reverse(si)].dec]
;
; Plot a filled polygon
set_screen
!p.charsize=1.5
!p.psym=0
!p.color=tci(1)
statns=''
for i=0,n_elements(stations)-1 do statns=statns+' '+stations[i]
;
IF polar THEN BEGIN
	hadec=transpose([[h],[d]])
        azel=horizon2azel(equatorial2horizon(hadec2equatorial(hadec)))
        az=reform(azel[0,*])/180*!pi
        za=90-reform(azel[1,*])
	if !d.window lt 0 then window,xsize=500,ysize=500
	n_az=360
	theta=findgen(n_az)/180*!pi
	r=fltarr(n_az)+90
	!x.ticks=2
	!x.tickname=[' ','S',' ']
	!x.tickv=[-90,0,90]
	!y.ticks=2
	!y.tickname=[' ','W',' ']
	!y.tickv=[-90,0,90]
	!p.charsize=1.5
	!x.margin=[3,3]
	!y.margin=[3,3]
	plot,r,theta,/polar,xrange=[-90,90],yrange=[-90,90],xstyle=1,ystyle=1, $
		title=statns
	for i=10,80,10 do begin
		r[*]=i
		oplot,r,theta,psym=0,/polar
		xyouts,r[0]-22,0,string(fix(90-r[0])),color=tci(4)
	endfor
	oplot,fltarr(180),findgen(180)-90
	oplot,findgen(180)-90,fltarr(180)
;
	x=-za*sin(az)
	y=+za*cos(az)
	polyfill,x,y,/line_fill,linestyle=1,thick=3
	!x.range=0
	!y.range=0
;
; 	Plot equatorial grid
	theta=findgen(36)/18*!pi
	usersym,sin(theta),cos(theta),/fill
	times1=times+(startable[0].ra-fix(startable[0].ra))*3600
	for j=0,n-1 do begin
	index=where(sun_ok and zas_ok[*,j],count)
	if count gt 0 and fix(startable[j].dec) mod 10 eq 0 then begin
	!p.color=tci(3)
	if startable[j].dec eq 0 then !p.color=tci(2)
	oplot,za_star_p[index,j],(az_star_p[index,j]+90)/180*!pi,/polar,psym=0
	k=where(abs(times1[index]/3600-nint(times1[index]/3600)) lt 0.06)
	k=where(abs(ha_star_p[index,j]-nint(ha_star_p[index,j])) lt 0.06)
	oplot,za_star_p[index[k],j],(az_star_p[index[k],j]+90)/180*!pi,/polar,psym=8
	endif
	endfor
	!p.color=tci(0)
ENDIF ELSE BEGIN
	window,xsize=500,ysize=640,/free
	plot,[-6,6],[-90,90],/nodata,xtitle='Hour angle',ytitle='Declination', $
		title=statns, $
		xticklen=1,yticklen=1,xthick=0.5,ythick=0.5, $
		xgridstyle=2,ygridstyle=2, $
		xticks=12,xtickv=findgen(13)-6, $
		ytickinterval=10, $
		xrange=[-6,6],yrange=[-90,90],xstyle=1,ystyle=1
	polyfill,h,d,/line_fill,linestyle=1,thick=2
ENDELSE
;
; Restore startable
; if n_elements(startable_bck) ne 0 then startable=startable_bck
;
end
