pro plotimagefluxes,lamda,flux
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Plot spectrum of image cube. Return lambda(microns),fluxes
;
common ChannelImage,channel_images,channel_wavelengths,images_cellsize
;
nl=n_elements(channel_wavelengths)
lamda=channel_wavelengths*1e6	; convert m to microns
flux=fltarr(nl)
for j=0,nl-1 do flux[j]=total(channel_images[*,*,j])
;
if total(!x.range) eq 0 then !x.range=[min(lamda),max(lamda)]
index=where(lamda gt !x.range[0] and lamda lt !x.range[1])
if total(!y.range) eq 0 then !y.range=[0,max(flux[index])]
plot,lamda,flux, $
	xtitle='Wavelength [microns]',ytitle='Flux',charsize=1.5
!y.range=0
;
end
