pro plotjacoby
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Plot visual spectra of stars selected from the Library of Stellar Spectra.
; (JACOBY, HUNTER AND CHRISTIAN 1984; National Space Science Data Center)
;
common PlotJacoby,jacoby_wid,stars,fluxes,lambda
;
window,0,xsize=1024,ysize=500
fluxes=0
lambda=0
;
headers=''
status=dc_read_fixed(!atmospheres_dir+'jacoby/headers.dat',headers,resize=[1], $
	format='(a160)',/col)
stars=strmid(headers,0,17)
jacoby_wid=widget_base(title=' Jacoby ',resource_name='oyster', $
	/column)
row_wid=widget_base(jacoby_wid,/row)
list_wid=widget_list(row_wid,value=stars, $
	event_pro='ww_loadjacoby',ysize=12)
buttons=['He II','He I','H','Sun','Ca I','Ca II','Na I','Fe I']
button1_wid=cw_bgroup(row_wid,buttons,event_funct='ww_jacobylines', $
	/column,/return_name)
buttons=['CH','CN','Mg I','Mg II','Ti II','Sr II','TiO','O_2']
button2_wid=cw_bgroup(row_wid,buttons,event_funct='ww_jacobylines', $
	/column,/return_name)
devices=['Screen','File','PostScript']
device_wid=widget_droplist(jacoby_wid,title='Device:', $
	value=devices,uvalue=devices,event_pro='ww_plotdevice')
combox_wid=cw_bgroup(jacoby_wid,['Range','Quit'],event_funct='ww_jacobycommand',
	/row,/return_name)
widget_control,jacoby_wid,/realize
xmanager,'plot_jacoby',jacoby_wid,/no_block
;
end
