pro plotlehmann,component,minmax
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
common ScanData,scans,bgscans,bufferinfo,positions,velocities,magnitudes
common Constants,c_light,pi_circle,e_euler,i_complex,a_disp,b_disp
common Model,gen_model,star_model,binary_model,gen_error,star_error,binary_error
common PlotVel,plotvel_options
;
RAD=180/pi_circle
;
if n_elements(component) eq 0 then begin
	print,'***Error(PLOTLEHMANN): component undefined!'
	return
endif
if n_elements(binary_model) eq 0 then begin
	print,'***Error(PLOTLEHMANN): no model!'
	return
endif
;
i=whereequal(star_model.component,component)
if n_elements(i) lt 2 then begin
	i=where(component eq star_model.component,count) & i=i[0]
	if count eq 0 then begin
		print,'***Error(PLOTLEHMANN): component not in model!'
		return
	endif
endif
;
; Compute orbital phase using lowest hierarchical level binary component
ci=strpos(binary_model.component,plotvel_options.component)
i=where(ci ge 0)
components=binary_model[i].component
periods=binary_model[i].period
si=sort(strlen(components))
components=components[si]
periods=periods[si]
j=where(periods ne 0) & j=j[0]
i=where(binary_model.component eq components[j]) & i=i[0]
;
p=binary_model[i].period
; The epoch should be close to the median observing epoch
if n_elements(velocities) ge 3 then t=median(velocities.jd)-p/2 $
			       else t=avg(velocities.jd)-p/2
; If you want to plot the periastron...
t=binary_model[i].epoch;-nint((binary_model(i).epoch-min(velocities.jd))/p)*p
n=nint((max(velocities.jd)-min(velocities.jd))/p)+2
n=1
;
num=360/2	; must be less than maxep in function lcmap
if plotvel_options.p then jd=dindgen(num)/num*p+t $
		     else jd=n*dindgen(num)/num*p+t-p
;
x=(jd-binary_model[i].epoch)/binary_model[i].period mod 1
; x=(x-wilson()) mod 1	; Plot versus binary phase
if min(x) lt 0 then x=x+1
;
v=modelvel(jd)
;
; Remove systemic velocities by high-order binary components
index=where(strlen(binary_model.component) $
	 gt strlen(binary_model[i].component))
if index[0] ge 0 then begin
	s=modelvel(jd,binary_model[index].component)
	r=componentparse(topbincomp(),c1,c2)
	if strlen(c1) eq 1 and c1 eq plotvel_options.component then s=s*0
	if strlen(c2) eq 1 and c2 eq plotvel_options.component then s=s*0
	v=v-s
endif
;
; Allow composite component of 2 or more stars, e.g. 'AB'
index=whereequal(star_model.component,component)
if n_elements(index) eq 2 then begin
	v=total(v[*,index]*((fltarr(num)+1)#star_model[index].mass),2) $
	 /total(star_model[index].mass)
	index=0
endif
;
if plotvel_options.p then begin
	x=[x-2,x-1,x,x+1]
	v=[v,v,v,v]
endif
;
if n_params() eq 2 then begin
	minmax=fltarr(2)
	minmax[0]=min(v[*,index])
	minmax[1]=max(v[*,index])
	return
endif
;
!p.linestyle=0
if plotvel_options.p then oplot,x,v[*,index],psym=0 $
		     else oplot,jd,v[*,index],psym=0
!p.linestyle=0
;
end
