pro plotmag,heidi=heidi
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Plots multiple star magnitudes.
;
; Some information on symbols and colors:
; !p.psym=0: no symbol, connect points with lines
;         1: +
;         2: *
;         3: .
;         4: Diamond
;         5: Triangle
;         6: Square
;         7: x
; tek_color
; !p.color=0: black
;          1: white
;          2: red
;          3: green
;          4: blue
;          .
;          .
;         31: <last color index>
;
common ScanData,scans,bgscans,bufferinfo,positions,velocities,magnitudes
common Model,gen_model,star_model,binary_model,gen_error,star_error,binary_error
common PlotMag,plotmag_options
common PlotMagDataInfo,plotscans,plotdata_x,plotdata_y
common Constants,c_light,pi_circle,e_euler,i_complex,a_disp,b_disp
;
if n_elements(heidi) eq 0 then heidi=0
;
; Check data
if n_elements(magnitudes) eq 0 then begin
	print,'***Error(PLOTMAG): no data!'
	return
endif
;
; Prepare PlotvelDataInfo
plotscans=magnitudes
;
; Set character size
!p.charsize=1.0
;
if plotmag_options.a then begin
	plotmag_options_r=plotmag_options.r
	filters=unique(magnitudes.filter)
	plotmag_options.r=0
	!p.multi=[0,1,n_elements(filters)]
endif else filters=plotmag_options.filter
;
; Set margins, number of plots, and axis styles
xvmargin=[4.0,2.0]
yvmargin=[3.0,2.0]/!d.y_ch_size*!d.x_ch_size
if plotmag_options.r and plotmag_options.o then begin
	!p.multi=[0,1,2]
	ymargin1=[yvmargin[0]*0,yvmargin[1]]
	ymargin2=[yvmargin[0],yvmargin[1]*0]
	xstyle1=6
	xstyle2=2
	yfactor=1.5
endif else begin
	ymargin1=yvmargin
	ymargin2=yvmargin
	xstyle1=2
	xstyle2=2
	yfactor=1
endelse
;
; Open a plot window for plotting on the screen
if n_elements(gen_model) ne 0 then star=gen_model.starid else star=' '
if !d.name ne 'PS' then begin
	window,/free,title=star,xsize=!xsize,ysize=!ysize, $
		xpos=!dxsize-!xsize,ypos=!dysize-!ysize
endif else begin
        device,color=plotmag_options.c
	tek_color
	set_ps,page_size='a4'
endelse
if !d.name eq 'PS' then frame_color=0 else frame_color=1
!p.color=tci(frame_color)
;
; Determine whether automatic scaling is requested
if total(abs(!x.range)) eq 0 then xrange_auto=1 else xrange_auto=0
if total(abs(!y.range)) eq 0 then yrange_auto=1 else yrange_auto=0
;
FOR k=0,n_elements(filters)-1 DO BEGIN
;
; Set data
index=where((magnitudes.component eq plotmag_options.component) $
        and (magnitudes.filter eq filters[k]),count)
if count eq 0 then begin
	print,'***Error(PLOTMAG): no data for this component!'
	return
endif
y=magnitudes[index].value
e=magnitudes[index].error
v=magnitudes[index].valuem
if plotmag_options.p and num_binary() gt 0 then begin
	i=where(min(binary_model.period) eq binary_model.period)
	x=(magnitudes[index].jd-binary_model[i].epoch)/binary_model[i].period $
		mod 1
	xtitle='Orbital phase'
;	x=(x-wilson()) mod 1	; Plot versus binary phase
;	xtitle='Binary phase'
	index=where(x lt 0,count)
	if count gt 0 then x[index]=x[index]+1
	if heidi then begin
		xtitle='Longitude'
		v=-(v-mean(v))+mean(v)
		x=x*360
	endif
endif else begin
	x=magnitudes[index].jd
	xtitle='Epoch'
endelse
ytitle1=greek('DELTA')+filters[k]
ytitle2='Residual magnitude'
title=plotmag_options.component+', ' $
	+jd2date(min(magnitudes.jd),/rjd)+' to ' $
	+jd2date(max(magnitudes.jd),/rjd)
if plotmag_options.b then title=''
;
; Set and equalize ranges
if xrange_auto then !x.range=[min(x),max(x)]
if yrange_auto then !y.range=[max(y),min(y)]
;
if plotmag_options.p and not heidi then begin
	x=[x-1,x,x+1]
	y=[y,y,y]
	e=[e,e,e]
	v=[v,v,v]
endif
plotdata_x=x
plotdata_y=y
;
; Set symbol
if plotmag_options.e then !p.psym=3 else !p.psym=1
;
; Plot data
index=where(e gt 0,count)
if count gt 0 then begin
	plot,x[index],y[index], $
	xtitle=xtitle,ytitle=ytitle1,title=title
	if plotmag_options.e then $
		oploterror,x[index],y[index],x[index]*0,e[index]
endif
if plotmag_options.f then begin
	index=where(e le 0,count)
	if count gt 0 then begin
		oplot,x[index],y[index],color=tci(2)
		if plotmag_options.e then $
			oploterror,x[index],y[index],x[index]*0,e[index], $
				errocolor=tci(2)
	endif
endif
;
; Plot model
if plotmag_options.o then begin
	si=sort(x)
	oplot,x[si],v[si],psym=0
;
;	Plot residuals
	if plotmag_options.r then begin
	xs=!x.s & ys=!y.s
	xc=!x.crange & yc=!y.crange
	r=y-v
	index=where(e gt 0,count)
	plot,x[index],r[index],ymargin=ymargin2,xstyle=xstyle2,yrange=[0,0], $
		ytitle=ytitle2,xtitle=xtitle
	if plotmag_options.e then oploterror,x[index],r[index], $
					     x[index]*0,e[index]
	oplot,!x.crange,[0,0],psym=0
	!x.s=xs & !y.s=ys
	!x.crange=xc & !y.crange=yc
	endif
endif
;
ENDFOR
;
; Reset plot variables
if plotmag_options.a then plotmag_options.r=plotmag_options_r
if xrange_auto then !x.range=0
if yrange_auto then !y.range=0
!p.color=tci(1)
!p.multi=0
;
end
