pro plotncal,skip_plot=skip_plot
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; This procedure now comprises three different calibrations of channels
; (Response), baselines (Bias), and stations (APDFlux). It is intended as
; a container for system calibrations, and therefore does not offer axis
; plot selection. It also stores calibration information in the configuration
; variable GenConfig.
;
; This procedure is aware of different scan configurations related to switching
; in and out stations in the NPOI 6-way observing mode. It initializes the
; corresponding information in genconfig.config, using function scanconfig.
;
common StarBase,startable,notes
common DataSelInfo,class,type,slice,ds_nights,ds_stars,ds_x,ds_y,ds_z,ps_options
common PlotDataInfo,plotscans,plotdata_x,plotdata_y,plotdata_y_bck
common SysConfig,SystemId,Date,MetroConfig,GenConfig,GeoParms,GenInfo,GeoInfo
common Tables,ScanTable,BGTable,StationTable
common ScanData,scans,bgscans,bufferinfo,positions,velocities,magnitudes
common PlacementInfo,xpix_per_char,ypix_per_char, $
		     title_yoffset,title_xoffset, $
		     xtitle_xoffset,xtitle_yoffset, $
		     ytitle_xoffset,ytitle_yoffset, $
		     num_title,max_star_per_title,xpix_per_star, $
		     num_xtitle,max_xlabel_per_title,xpix_per_xlabel, $
		     num_ytitle,max_ylabel_per_title,xpix_per_ylabel
common Constants,c_light,pi_circle,e_euler,i_complex,a_disp,b_disp
;
; We added skip_plot so that we can include ncal in a pipeline
if n_elements(skip_plot) eq 0 then skip_plot=0 else skip_plot=1
;
; Check availability of data
if checkdata([1,9]) ne 0 then return
;
; Check data selection
if printselerror(checkplotsel('y')) ne 0 then return
;
; Extract selection of y stream
set_streamsel,'y',item,ds_ib,ds_ob,ds_tr,ds_ch,ds_bl,ds_pt
;
; Extract scan configuration
sconf=''
if strpos(type,'V2Bias')      ne -1 then sconf=strmid(type, 6,strlen(type) -6)
if strpos(type,'TABias')      ne -1 then sconf=strmid(type, 6,strlen(type) -6)
if strpos(type,'APDFlux')     ne -1 then sconf=strmid(type, 7,strlen(type) -7)
if strpos(type,'Response')    ne -1 then sconf=strmid(type, 8,strlen(type) -8)
if strpos(type,'TrackJitter') ne -1 then sconf=strmid(type,11,strlen(type)-11)
if strpos(type,'TrackOffset') ne -1 then sconf=strmid(type,11,strlen(type)-11)
if strlen(sconf) eq 0 then sconf=scanconfig()
sconf=sconf[0]
genconfig.config=''
genconfig.config[0:n_elements(scanconfig(/starlist))-1]=scanconfig(/starlist)
configs=strarr(n_elements(scanconfig(/starlist)))
for i=0,n_elements(scanconfig(/starlist))-1 do begin
	words=nameparse(genconfig.config[i])
	configs[i]=words[0]
endfor
cf=where(sconf eq configs)
if cf[0] lt 0 and strpos(type,'APDFlux') eq -1 then begin
	print,'Warning: fit results will not be stored!'
	print,'Please select one of these in Points drop-down menu: ' $
		+strjoin(scanconfig(/coh),' ')+'!'
endif
genconfig_checksum=''
for i=0,n_tags(genconfig)-1 do genconfig_checksum=genconfig_checksum $
				 +strjoin(string(genconfig.(i)),/single)
;
; For 'Response', normalize to 2 stations per detector
if strpos(type,'Response') ge 0 then begin
	f_response=1.0
	i=scanconfig(sconf)
	if i[0] ne 0 then begin
	n=0
	sids=genconfig.stationid $
		(where(scantable[i[0]].station(0:genconfig.numsid-1) ne 0))
	for i=0,n_elements(sids)-1 do $
	if strpos(strjoin(genconfig.baselineid[*,ds_ob]),sids[i]) ge 0 then n=n+1
	f_response=2.0/n
	endif
endif
;
; Initialize loop ranges
num_c=n_elements(ds_ch)
num_b=n_elements(ds_bl)
if strpos(type,'TABias') ge 0 then num_b=1
if strpos(type,'APDFlux') ge 0 then num_b=1
if strpos(type,'Response') ge 0 then num_b=1
;
; Initialize index counter
numarr=intarr(2,num_b*num_c)
num_plot=0
;
; For option All in 1 we have to go through the data twice to find the
; number of plots in a window (num_plot) and the total range of data values.
; However, we now go through it twice anyway to see how many plots we have.
if ps_options.a then num_run=2 else num_run=2
;
; Determine whether automatic scaling is requested
if total(abs(!x.range)) eq 0 then xrange_auto=1 else xrange_auto=0
if total(abs(!y.range)) eq 0 then yrange_auto=1 else yrange_auto=0
if total(abs(!z.range)) eq 0 then zrange_auto=1 else zrange_auto=0
;
; For squared visibility bias plot, choose logarithmic scale
if strpos(type,'V2Bias') ge 0  and not !v2bias then begin
	!x.type=1
	!y.type=1
endif else if strpos(type,'TABias') ge 0  and not !tabias then begin
	!x.type=1
	!y.type=1
endif else begin
	!x.type=0
	!y.type=0
endelse
xrange_bck=!x.range
yrange_bck=!y.range
if !x.type eq 1 and not xrange_auto then !x.range=10^!x.range
if !y.type eq 1 and not yrange_auto then !y.range=10^!y.range
;
RAD=180/pi_circle
;
; Loops start here!
FOR run_no=1,num_run DO BEGIN
plot_no=0	; Current (sub)plot number; first plot will be no. 1
;
IF run_no eq 2 AND num_plot gt 0 THEN BEGIN
;
num_v=n_elements(unique(numarr[0,0:num_plot-1]))
num_h=n_elements(unique(numarr[1,0:num_plot-1]))
if num_v eq 1 or num_h eq 1 then begin
	num_t=num_h*num_v
	num_v=num_t
	num_h=1
	while num_v/num_h ge 2 do begin
		num_h=num_h+1
		num_v=num_t/num_h
 		if num_v*num_h lt num_t then num_v=num_v+1
	endwhile
endif
; !p.multi=[#plots remaining,#plot columns,#plot rows,#plots stacked in Z,
;           0:left to right and top to bottom;1:top to bottom and left to right]
if ps_options.a or ps_options.d then !p.multi=0 $
				else !p.multi=[0,num_h,num_v,0,1]
;
; For multiple plots, IDL reduces the charsize by a factor of 2
!p.charsize=1.0
if !p.multi[1]*!p.multi[2] le 1 then !p.charsize=1.5
if !p.multi[1] gt 2 or !p.multi[2] gt 2 then begin
	!p.charsize=2.0
	scale_cs=2.0
endif else scale_cs=1.0
if !p.multi[1] gt 4 or !p.multi[2] gt 4 then !p.charsize=1.0
;
; Open a plot window for plotting
IF NOT skip_plot THEN BEGIN
if not ps_options.d and (!d.name ne 'PS') then begin
	window,/free,title=Date+', Class:'+class,xsize=!xsize,ysize=!ysize, $
		xpos=!dxsize-!xsize,ypos=!dysize-!ysize
endif else if not ps_options.d and (!d.name eq 'PS') then begin
	device,color=ps_options.c
	tek_color
	if ps_options.p then begin
		if scale_cs eq 1 then !p.charsize=1.5 else !p.charsize=2.0
	endif
endif else begin
	print,'***Error(PLOTNCAL): invalid selection and/or device name!'
	return
endelse
ENDIF
;
; Calculate star title placement variables
titleplacement,'t',ds_stars
;
ENDIF
;
if !d.name eq 'PS' then frame_color=0 else frame_color=1
!p.color=tci(frame_color)
;
for ich=0,num_c-1 do begin
for ibl=0,num_b-1 do begin
;
; 	Initialize data arrays
	x=fltarr(n_elements(scans))
	y=fltarr(n_elements(scans))
	e=fltarr(n_elements(scans))
	z=fltarr(n_elements(scans))
	t=fltarr(n_elements(scans))
	s=strarr(n_elements(scans))
;
	ch=ds_ch[ich]
	bl=ds_bl[ibl]
;
; 	Set the data
	for st=0,n_elements(ds_stars)-1 do begin
		index=where(scans[ds_pt].starid eq ds_stars[st],count)
		if count ne 0 then begin
		if strpos(type,'Response') ge 0 then begin
			j=where(startable.starid eq ds_stars[st],count)
			if count ne 0 then begin
			s[st]=ds_stars[st]
			x[st]=startable[j].bv
			tt=scans[ds_pt[index]].time
			if x[st] lt 100 then begin
			pr=scans[ds_pt[index]].photonrate(ds_ob,ch) $
			  /cos(scans[ds_pt[index]].za/RAD)
			pr=pr*f_response
			pre=scans[ds_pt[index]].photonrateerr(ds_ob,ch) $
			  /cos(scans[ds_pt[index]].za/RAD)
			pre=pre*f_response
			index=where(pr gt 0 and pre gt 0,count)
			if count gt 1 then begin
				sigma=stddev(pr[index],mean)
			endif else if count eq 1 then begin
				sigma=pre[index]
				mean=pr[index]
			endif
			if count gt 0 then begin
				y[st]=2.5*alog10(mean)+startable[j].mv
				e[st]=2.5*sigma/mean/alog(10)
				t[st]=avg(tt[index])
			endif
			endif
			endif
		endif else if strpos(type,'TrackJitter') ge 0 then begin
			jndex=where(scantable[ds_pt[index]].code eq 1,count)
			if count gt 0 then begin
			p=scans[ds_pt[index[jndex]]].photonrate(ds_ob,ch)
			pe=scans[ds_pt[index[jndex]]].photonrateerr(ds_ob,ch)
	   		i=where(GenConfig.StationId eq $
	    		 strmid(GenConfig.BaselineId[bl,ds_ob],0,3))
	   		j=where(GenConfig.StationId eq $
			 strmid(GenConfig.BaselineId[bl,ds_ob],4,3))
			tj=(sqrt(scans[ds_pt[index[jndex]]].NATJitter(i)^2 $
				+scans[ds_pt[index[jndex]]].NATJitter(j)^2))
			sign=fltarr(n_elements(ds_pt[index[jndex]]))+1
			endex=where(scans[ds_pt[index[jndex]]].NATJitterErr(i) lt 0 $
				 or scans[ds_pt[index[jndex]]].NATJitterErr(j) lt 0,count)
			if count gt 0 then sign[endex]=-1
			tje=(sqrt(scans[ds_pt[index[jndex]]].NATJitterErr(i)^2 $
				 +scans[ds_pt[index[jndex]]].NATJitterErr(j)^2))*sign
			kndex=where(pe gt 0 and tje gt 0,count)
			if count gt 0 then begin
				s[ds_pt[index[jndex[kndex]]]]=ds_stars[st]
				x[ds_pt[index[jndex[kndex]]]]=p[kndex]
				y[ds_pt[index[jndex[kndex]]]]=tj[kndex]
				e[ds_pt[index[jndex[kndex]]]]=tje[kndex]
			endif
			endif
		endif else if strpos(type,'TrackOffset') ge 0 then begin
			jndex=where(scantable[ds_pt[index]].code eq 1,count)
			if count gt 0 then begin
			v=scans[ds_pt[index[jndex]]].vissqec(ds_ob,ch,bl)
			ve=scans[ds_pt[index[jndex]]].vissqecerr(ds_ob,ch,bl)
			o=scans[ds_pt[index[jndex]]].trackoffset(ds_ob,bl)
			oe=o*0+1
			kndex=where(ve gt 0 and oe gt 0,count)
			if count gt 0 then begin
				s[ds_pt[index[jndex[kndex]]]]=ds_stars[st]
				x[ds_pt[index[jndex[kndex]]]]=o[kndex]
				y[ds_pt[index[jndex[kndex]]]]=v[kndex]
				e[ds_pt[index[jndex[kndex]]]]=oe[kndex]
			endif
			endif
		endif else if strpos(type,'V2Bias') ge 0 then begin
;			Photonrate must include back ground
			jndex=where(scantable[ds_pt[index]].code eq 0,count)
			if count gt 0 then begin
			v=scans[ds_pt[index[jndex]]].vissq(ds_ob,ch,bl)
			ve=scans[ds_pt[index[jndex]]].vissqerr(ds_ob,ch,bl)
			p=scans[ds_pt[index[jndex]]].photonrate(ds_ob,ch) $
			 +scans[ds_pt[index[jndex]]].backgndrate(ds_ob,ch)
			pe=scans[ds_pt[index[jndex]]].photonrateerr(ds_ob,ch)
			if not !v2bias then $
			kndex=where(v gt 0 and ve gt 0 $
				and p gt 0 and pe gt 0,count) else $
			kndex=where(ve gt 0 and pe gt 0,count)
			if count gt 1 then sigma=stddev(v[kndex]) else $
			if count eq 1 then sigma=ve[kndex]
			if count gt 0 then begin
				s[ds_pt[index[jndex[kndex]]]]=ds_stars[st]
				x[ds_pt[index[jndex[kndex]]]]=p[kndex]
				y[ds_pt[index[jndex[kndex]]]]=v[kndex]
				e[ds_pt[index[jndex[kndex]]]]=ve[kndex]
			endif
			endif
		endif else if strpos(type,'TABias') ge 0 then begin
;			Photonrate must include back ground
;			Here we use the photonrate of the common beam
			jndex=where(scantable[ds_pt[index]].code eq 0,count)
			if count gt 0 then begin
			v=scans[ds_pt[index[jndex]]].tripleamp(ds_tr,ch)
			ve=scans[ds_pt[index[jndex]]].tripleamperr(ds_tr,ch)
			tb=commonbeam(genconfig.triplebeam[*,ds_tr])
			p=scans[ds_pt[index[jndex]]].photonrate(tb, $
					genconfig.triplechan[ch,0,ds_tr]) $
			 +scans[ds_pt[index[jndex]]].backgndrate(tb, $
					genconfig.triplechan[ch,0,ds_tr])
			pe=scans[ds_pt[index[jndex]]].photonrateerr(tb, $
					    genconfig.triplechan[ch,0,ds_tr])
			if not !tabias then $
			kndex=where(v gt 0 and ve gt 0 $
				and p gt 0 and pe gt 0,count) else $
			kndex=where(ve gt 0 and pe gt 0,count)
			if count gt 1 then sigma=stddev(v[kndex]) else $
			if count eq 1 then sigma=ve[kndex]
			if count gt 0 then begin
				s[ds_pt[index[jndex[kndex]]]]=ds_stars[st]
				x[ds_pt[index[jndex[kndex]]]]=p[kndex]
				y[ds_pt[index[jndex[kndex]]]]=v[kndex]
				e[ds_pt[index[jndex[kndex]]]]=ve[kndex]
			endif
			endif
		endif
		endif
	endfor
	if strpos(type,'APDFlux') ge 0 then begin
		photom,ds_pt+1,y=rrates,e=erates,nonl=ps_options.v
		y=rrates[ds_ob,ch,*]
		e=erates[ds_ob,ch,*]
		x=scans[ds_pt].iscan
		s=scans[ds_pt].starid
	endif
;
;	Concatenate arrays
	index=where(strlen(s) gt 0,count)
	if count eq 0 then goto,SKIPPLOT
	x=x[index]
	y=y[index]
	e=e[index]
	s=s[index]
;
;	If there is no valid data, skip the rest
	index=where(e gt 0,count)
	if count eq 0 then goto,SKIPPLOT
;
;       We have valid data, so increment the plot number counter
	plot_no=plot_no+1
	numarr[*,plot_no-1]=[ibl,ich]
;
;       First, we have to find out about the ranges
	xmin=min(x[index])
	ymin=min(y[index])
	zmin=min(z[index])
	xmax=max(x[index])
	ymax=max(y[index])
	zmax=max(z[index])
;
;       Here we got the range information and can skip the rest if plotting
;       will occur in the second run through the data (All in 1 option).
	IF NOT skip_plot THEN BEGIN
	if run_no eq 1 then begin
		num_plot=num_plot+1
		if plot_no eq 1 then begin
			axmax=xmax
			axmin=xmin
			aymax=ymax
			aymin=ymin
			azmax=zmax
			azmin=zmin
		endif else begin
			axmax=max([axmax,xmax])
			axmin=min([axmin,xmin])
			aymax=max([aymax,ymax])
			aymin=min([aymin,ymin])
			azmax=max([azmax,zmax])
			azmin=min([azmin,zmin])
		endelse
		goto,SKIPPLOT
	endif
;
;  	Set the ranges for plotting
        if ps_options.a then begin
                if n_elements(axmax) eq 0 and not skip_plot then begin
			window,/free
                        xyouts,0.4,0.5,'No data',/normal,charsize=2
                        return
                endif
		xmax=axmax
		xmin=axmin
		ymax=aymax
		ymin=aymin
		zmax=azmax
		zmin=azmin
	endif
	if xrange_auto then !x.range=[xmin,xmax] else !x.style=1
	if strpos(type,'V2Bias'     ) ge 0 then $
	if yrange_auto then !y.range=[ymin,ymax] else !y.style=1
	if strpos(type,'TABias'     ) ge 0 then $
	if yrange_auto then !y.range=[ymin,ymax] else !y.style=1
	if strpos(type,'APDFlux'    ) ge 0 then $
	if yrange_auto then !y.range=[ymin,ymax] else !y.style=1
	if strpos(type,'Response'   ) ge 0 then $
	if yrange_auto then !y.range=[ymax,ymin] else !y.style=1
	if strpos(type,'TrackJitter') ge 0 then $
	if yrange_auto then !y.range=[ymin,ymax] else !y.style=1
	if strpos(type,'TrackOffset') ge 0 then $
	if yrange_auto then !y.range=[ymin,ymax] else !y.style=1
	if zrange_auto then !z.range=[zmin,zmax]
	psym=1
	num_xlabel=0
	num_ylabel=num_plot
	num_zlabel=num_plot
	ax_items=set_axitems(item_ids)
	xtitle=ax_items[0]
	ytitle=ax_items[1]
	ztitle=ax_items[2]
	xlabel=''
	ylabel='OB '+strcompress(string(ds_ob+1))+ $
	      ' CH '+strcompress(string(ch+1))
	if strpos(type,'V2Bias') ge 0 then $
		ylabel=ylabel+' BL '+strcompress(string(bl+1))
	if strpos(type,'TABias') ge 0 then $
		ylabel='TR '+strcompress(string(ds_tr+1)) $
		     +' CH '+strcompress(string(ch+1))
	if strpos(type,'TrackJitter') ge 0 then begin
		xlabel='OB '+strcompress(string(ds_ob+1))+ $
		      ' CH '+strcompress(string(ch+1))
		ylabel='OB '+strcompress(string(ds_ob+1))+ $
		      ' BL '+strcompress(string(bl+1))
		num_xlabel=num_plot
	endif
	if strpos(type,'TrackOffset') ge 0 then begin
		xlabel='OB '+strcompress(string(ds_ob+1))+ $
		      ' BL '+strcompress(string(bl+1))
		ylabel=ylabel+' BL '+strcompress(string(bl+1))
		num_xlabel=num_plot
	endif
	zlabel='CH '+strcompress(string(ch+1))
	if not ps_options.a then begin
		xcomma=', '
		ycomma=', '
		zcomma=', '
		if !p.multi[2] gt 2 then begin
			xtitle=ytitle+' vs '+xtitle
			ytitle=''
			ycomma=''
		endif
		if num_xlabel gt 0 then xtitle=xtitle+xcomma+xlabel
		if num_ylabel gt 0 then ytitle=ytitle+ycomma+ylabel
		if num_zlabel gt 0 then ztitle=ztitle+zcomma+zlabel
	endif else if plot_no eq 1 then begin
		titleplacement,'x',ds_stars,xlabel,num_xlabel
		titleplacement,'y',ds_stars,ylabel,num_ylabel
	endif
	ENDIF
;
;	Plot frame
	IF NOT skip_plot THEN BEGIN
;	3D
	if ps_options.d then begin
		if plot_no eq 1 then begin
		pos=[0.1,0.1,0.9,0.9,0.1,0.9]
		plot,x[where(e gt 0)],y[where(e gt 0)],/nodata,/t3d,position=pos, $
			xtitle=xtitle,ytitle=ytitle
		xscale=!x.s
		yscale=!y.s
		t3d,/xzexch
		xrange=!x.range
		!x.range=!z.range
		plot,z,y,/nodata,/t3d,/noerase,pos=pos, $
				xtitle=ztitle
		zscale=!x.s
		!x.range=xrange
		t3d,/xzexch
		t3d,/yzexch
		yrange=!y.range
		!y.range=!z.range
		plot,x,z,/nodata,/t3d,/noerase,pos=pos
		t3d,/yzexch
		!y.range=yrange
		!x.s=xscale
		!y.s=yscale
		!z.s=zscale
		endif
;	All in 1
	endif else if ps_options.a then begin
		if plot_no eq 1 then begin
		if num_xlabel eq 0 then ymrgn=3 else ymrgn=4
		if max([abs(ymax),abs(ymin)]) gt 10000 then $
			xmrgn=12 else xmrgn=9
		pos=[ $
		 num_ytitle*xpix_per_ylabel+7*xpix_per_char, $
		 num_xtitle*ypix_per_char+ymrgn*ypix_per_char, $
		 !xsize-3*xpix_per_char, $
		 !ysize-(num_title+1)*ypix_per_char]
		if ps_options.p then pos[0]=9*xpix_per_char
		if !d.name eq 'PS' then begin
		plot,x[where(e gt 0)],y[where(e gt 0)],/nodata,/device, $
			xtitle=xtitle,ytitle=ytitle, $
			xtype=!x.type,ytype=!y.type, $
			xmargin=[xmrgn,3],ymargin=[4,1+(num_title/scale_cs)]
		endif else begin
		plot,x[where(e gt 0)],y[where(e gt 0)], $
			/nodata,position=pos,/device, $
			xtitle=xtitle,ytitle=ytitle,xtype=!x.type,ytype=!y.type
		endelse
		if not ps_options.p then $
		xyouts,1.0-float(ypix_per_char)/!d.x_size,!y.window[1], $
			Date,/normal,orientation=-90,size=!p.charsize/scale_cs
		endif
		!p.psym=getsymbol(ich+1)
;	Standard
	endif else begin
		if max([abs(ymax),abs(ymin)]) gt 10000 then $
			xmrgn=12 else xmrgn=10
                !x.title=xtitle
                !y.title=ytitle
		plot,x[where(e gt 0)],y[where(e gt 0)], $
			/nodata,xmargin=[xmrgn,3], $
			ymargin=[4,1+(num_title/scale_cs)], $
			xtype=!x.type,ytype=!y.type,ystyle=!y.style
		if plot_no eq 1 and not ps_options.p then $
		xyouts,1.0-float(ypix_per_char)/!d.x_size,!y.window[1], $
			Date,/normal,orientation=-90,size=!p.charsize/scale_cs
	endelse
	ENDIF
;
;       Now we plot one star after the other
	IF NOT skip_plot THEN BEGIN
	for st=0,n_elements(ds_stars)-1 do begin
;
;		Add star to star title
		!p.color=tci(frame_color)
		if n_elements(ds_stars) gt 1 and not ps_options.a then $
			!p.color=getcolor(st)
		title_index=st/max_star_per_title
		if not ps_options.p then $
		xyouts,title_xoffset[title_index] $
			+(st mod max_star_per_title)*xpix_per_star, $
		       title_yoffset[title_index],ds_stars[st], $
		       /device,size=!p.charsize/scale_cs
;
;		Add data selection title for All in 1 option
		if ps_options.a then !p.color=getcolor(plot_no-1)
		if ps_options.a and (not ps_options.d) $
				and (not ps_options.p) $
				and (!d.name ne 'PS') $
		then begin
			title_index=(plot_no-1)/max_ylabel_per_title
			if num_ylabel eq 0 then title_index=0
			xyouts,ytitle_xoffset[title_index], $
			       ytitle_yoffset[title_index]+ $
			        ((plot_no-1) mod max_ylabel_per_title) $
					*ypix_per_char, $
			       ylabel,/device,size=!p.charsize
			title_index=(plot_no-1)/max_xlabel_per_title
			if num_xlabel eq 0 then title_index=0
			xyouts,xtitle_xoffset[title_index]+ $
				((plot_no-1) mod max_xlabel_per_title) $
					*xpix_per_xlabel, $
			       xtitle_yoffset[title_index], $
			       xlabel,/device,size=!p.charsize
		endif
;
;		Plot the data
;		if ps_options.e then psym=3 else psym=abs(!p.psym)
		if strpos(type,'APDFlux') ge 0 then begin
			index=where(s eq ds_stars[st] and e gt 0,count)
			if ps_options.l then psym=-psym
			if count gt 0 then oplot,x[index],y[index],psym=psym
		endif else if strpos(type,'V2Bias') ge 0 then begin
			index=where(s eq ds_stars[st] and e gt 0,count)
			if count gt 0 then begin
			xs=x[index]
			ys=y[index]
			es=e[index]
			zs=xs*0+float(ch)
			if ps_options.d then plots,xs,ys,zs,/t3d,psym=psym $
			else begin
				oplot,xs,ys,psym=psym
;				IDL refuses to plot a single error bar!
				if ps_options.e then begin
				index=where(es ge ys,count)
;				If err. bar ext. to neg., clip to plot
				if count gt 0 then es[index]=ys[index]-1e-5
				oploterror,[xs,xs],[ys,ys],[xs,xs]*0,[es,es], $
					errcolor=!p.color
				endif
			endelse
			endif
		endif else if strpos(type,'TrackJitter') ge 0 then begin
			index=where(s eq ds_stars[st] and e gt 0,count)
			if count gt 0 then begin
			xs=x[index]
			ys=y[index]
			es=e[index]
			zs=xs*0+float(ch)
			if ps_options.d then plots,xs,ys,zs,/t3d,psym=psym $
			else begin
				if ps_options.l then psym=-abs(psym)
				oplot,xs,ys,psym=psym
;				IDL refuses to plot a single error bar!
				if ps_options.e then begin
				index=where(es ge ys,count)
;				If err. bar ext. to neg., clip to plot
				if count gt 0 then es[index]=ys[index]-1e-5
				oploterror,[xs,xs],[ys,ys],[xs,xs]*0,[es,es], $
					errcolor=!p.color
				endif
			endelse
			endif
		endif else if strpos(type,'TrackOffset') ge 0 then begin
			index=where(s eq ds_stars[st] and e gt 0,count)
			if count gt 0 then begin
			xs=x[index]
			ys=y[index]
			es=e[index]
			zs=xs*0+float(ch)
			if ps_options.d then plots,xs,ys,zs,/t3d,psym=psym $
			else begin
				if ps_options.l then psym=-abs(psym)
				si=sort(xs)
				oplot,xs[si],ys[si],psym=psym
;				IDL refuses to plot a single error bar!
				if ps_options.e then begin
				index=where(es ge ys,count)
;				If err. bar ext. to neg., clip to plot
				if count gt 0 then es[index]=ys[index]-1e-5
				oploterror,[xs,xs],[ys,ys],[xs,xs]*0,[es,es], $
					errcolor=!p.color
				endif
			endelse
			endif
		endif else if strpos(type,'TABias') ge 0 then begin
			index=where(s eq ds_stars[st] and e gt 0,count)
			if count gt 0 then begin
			xs=x[index]
			ys=y[index]
			es=e[index]
			zs=xs*0+float(ch)
			if ps_options.d then plots,xs,ys,zs,/t3d,psym=psym $
			else begin
				oplot,xs,ys,psym=psym
;				IDL refuses to plot a single error bar!
				if ps_options.e then begin
				index=where(es ge ys,count)
;				If err. bar ext. to neg., clip to plot
				if count gt 0 then es[index]=ys[index]-1e-5
				oploterror,[xs,xs],[ys,ys],[xs,xs]*0,[es,es], $
					errcolor=!p.color
				endif
			endelse
			endif
		endif else begin
		z[st]=float(ch)
		if e[st] gt 0 then begin
		if ps_options.d then plots,[x[st]],[y[st]],[z],/t3d,psym=psym $
		else begin
			oplot,[x[st]],[y[st]],psym=psym
;			IDL refuses to plot a single error bar!
			if ps_options.e then $
				oploterror,[x[st],x[st]],[y[st],y[st]], $
					[x[st],x[st]]*0,[e[st],e[st]], $
					errcolor=!p.color
		endelse
		endif
		endelse
	endfor
	ENDIF
;
;	Do a linear fit and print results on screen
	!p.color=tci(frame_color)
	index=where(e gt 0,count)
	if count ge 1 then begin
	if strpos(type,'Response') ge 0 then begin
		if count eq 2 then begin
			slope=(y[index[1]]-y[index[0]]) $
			     /(x[index[1]]-x[index[0]])
			intcp=y[index[0]]-slope*x[index[0]]
			r=[intcp,slope]
			yft=y[index]
			sig=0.0
		endif else r=poly_fit(x[index],y[index],1,yft,ybd,sig,mat)
		cf=where(sconf eq genconfig.config)
		if cf[0] ge 0 then genconfig.response[*,ch,ds_ob,cf]=r
		xrange=!x.crange[1]-!x.crange[0]
		yrange=!y.crange[0]-!y.crange[1]
		xmin=!x.crange[0]+xrange*0.05
		ymin=!y.crange[0]-yrange*0.05
		xyouts,xmin,ymin,'SM='+string(r[0],format='(f4.2)'), $
				charsize=2.0/scale_cs
		xs=x[index] & si=sort(xs) & xs=xs[si] & ys=yft[si]
		oplot,xs,ys,psym=0
	endif else if strpos(type,'V2Bias') ge 0 then begin
		r=[0,0]
		if !x.type eq 1 and !y.type eq 1 then begin
		if max(alog10(x[index]))-min(alog10(x[index])) lt 0.3 then begin
;			Force slope=-1
			slope=-1.0
			intcp=avg(alog10(y[index]))-slope*avg(alog10(x[index]))
			r=[intcp,slope]
			yft=poly(alog10(x[index]),r)
		endif else begin
		if count eq 2 then begin
			slope=(alog10(y[index[1]])-alog10(y[index[0]])) $
			     /(alog10(x[index[1]])-alog10(x[index[0]]))
			intcp=alog10(y[index[0]])-slope*alog10(x[index[0]])
			r=[intcp,slope]
			yft=alog10(y[index])
		endif else begin
;			Fit with slope -1 (general fit follows)
			r=poly_fit(alog10(x[index]),alog10(y[index]*x[index]),0,yft)
			r=[r[0],-1]
			yft=poly(alog10(x[index]),r)
;			General linear fit
			r=poly_fit(alog10(x[index]),alog10(y[index]),1,yft)
		endelse
		endelse
		r=reform(r)
		r[0]=10^r[0]
		for st=0,n_elements(ds_stars)-1 do begin
			cf=where(sconf+' '+ds_stars[st] eq genconfig.config,ncf)
			for icf=0,ncf-1 do genconfig.v2bias[*,bl,ch,ds_ob,cf[icf]]=r
		endfor
		xs=x[index] & si=sort(xs) & xs=xs[si] & ys=10^yft[si]
		xmin=10^float(nint(!x.crange[0])+0.02)
		ymin=10^float(nint(!y.crange[0])+0.05)
		if ps_options.p then begin
			xmin=max(xs)*2
			if ich ge 2 then s=-1 else s=+1
			ymin=min(ys)*(1+0.5*s*(((ich+1) mod 2)-0.5))
		endif
		IF NOT skip_plot THEN BEGIN
		if not ps_options.a and not ps_options.p then $
		xyouts,xmin,ymin,'V!U2!N ='+string(r[0],format='(f6.2)')+ $
		       	'P!E'+string(r[1],format='(f5.2)'), $
				charsize=2.0/scale_cs
		oplot,xs,ys,psym=0
		endif
		ENDIF
	endif else if strpos(type,'TABias') ge 0 then begin
		r=[0,0]
		if !x.type eq 1 and !y.type eq 1 then begin
;		Next line: was 0.3, now 0.1
		if max(alog10(x[index]))-min(alog10(x[index])) lt 0.1 then begin
;			Force slope=-1
			slope=-1.0
			intcp=avg(alog10(y[index]))-slope*avg(alog10(x[index]))
			r=[intcp,slope]
			yft=poly(alog10(x[index]),r)
		endif else begin
		if count eq 2 then begin
			slope=(alog10(y[index[1]])-alog10(y[index[0]])) $
			     /(alog10(x[index[1]])-alog10(x[index[0]]))
			intcp=alog10(y[index[0]])-slope*alog10(x[index[0]])
			r=[intcp,slope]
			yft=alog10(y[index])
		endif else begin
;			General linear fit
			r=poly_fit(alog10(x[index]),alog10(y[index]),1,yft)
;			Next line: was -3, now -5
			if r[1] lt -5 or r[1] gt 0 then begin
;			Fit with slope -1
			r=poly_fit(alog10(x[index]),alog10(y[index]*x[index]),0,yft)
			r=[r[0],-1]
			yft=poly(alog10(x[index]),r)
			endif
		endelse
		endelse
		r=reform(r)
		r[0]=10^r[0]
		for st=0,n_elements(ds_stars)-1 do begin
			cf=where(sconf+' '+ds_stars[st] eq genconfig.config,ncf)
			for icf=0,ncf-1 do genconfig.tabias[*,ch,ds_tr,cf[icf]]=r
		endfor
		xs=x[index] & si=sort(xs) & xs=xs[si] & ys=10^yft[si]
		xmin=10^float(nint(!x.crange[0])+0.02)
		ymin=10^float(nint(!y.crange[0])+0.05)
		IF NOT skip_plot THEN BEGIN
		if not ps_options.a and not ps_options.p then $
		xyouts,xmin,ymin,'V!U2!N ='+string(r[0],format='(f6.2)')+ $
		       	'P!E'+string(r[1],format='(f5.2)'), $
				charsize=2.0/scale_cs
		oplot,xs,ys,psym=0
		endif
		ENDIF
	endif else if strpos(type,'TrackJitter') ge 0 then begin
		pmax=max(x[index])
		r=[1,0,0]
		if pmax gt 1 then begin
			p=findgen(long(pmax))
			r=poly_fit(x[index],y[index],2,yft)
			oplot,p,poly(p,r),psym=0
		endif
		cf=where(sconf eq genconfig.config)
		if cf[0] ge 0 then genconfig.trackcal[*,bl,ch,ds_ob,cf]=r
	endif else if strpos(type,'TrackOffset') ge 0 $
			and not !offsetcal then begin
		a=[0.5,0,32]
		r=curvefit(x[index],y[index],e[index]*0+1,a, $
			function_name='funct_gauss', $
			fita=[1,1,1],/noderiv)
		si=sort(x[index])
		oplot,x[index[si]],r[si],psym=0
		genconfig.offsetcal[*,bl,ch,ds_ob]=a[1:2]
	endif
	endif
;
SKIPPLOT:
endfor
endfor
ENDFOR
;
; Display alert if no data was found to be valid
if plot_no eq 0 then begin
;	window,/free
;	xyouts,0.4,0.5,'No data',/normal,charsize=2
	print,'No data to plot for '+sconf+'.'
endif else if not skip_plot then begin
	title1='OB: '+string(ds_ob+1)
	title2=' Bl: '+retroparse(ds_bl+1)
	title3=' Ch: '+retroparse(ds_ch+1)
	title=title1+title2+title3
	if ps_options.p and ps_options.a then xyouts,0.1,0.04,title,/normal
endif
;
genconfig_checksum1=''
for i=0,n_tags(genconfig)-1 do genconfig_checksum1=genconfig_checksum1 $
				 +strjoin(string(genconfig.(i)),/single)
if genconfig_checksum ne genconfig_checksum1 and not !quiet $
then print,'Fit results stored for '+sconf+'.'
;
; Reset plot variables
if xrange_auto then !x.range=0 else !x.range=xrange_bck
if yrange_auto then !y.range=0 else !y.range=yrange_bck
if zrange_auto then !z.range=0
!x.type=0
!y.type=0
!p.multi=0
!p.color=tci(1)
!x.title=''
!y.title=''
end
