pro plotorbit,overplot=overplot
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Plots multiple star orbits.
;
; Some information on symbols and colors:
; !p.psym=0: no symbol, connect points with lines
;         1: +
;         2: *
;         3: .
;         4: Diamond
;         5: Triangle
;         6: Square
;         7: x
; tek_color
; !p.color=0: black
;          1: white
;          2: red
;          3: green
;          4: blue
;          .
;          .
;         31: <last color index>
;
common ScanData,scans,bgscans,bufferinfo,positions,velocities,magnitudes
common Model,gen_model,star_model,binary_model,gen_error,star_error,binary_error
common PlotOrbit,plotorbit_options
common PlotorbitDataInfo,plotscans,plotdata_x,plotdata_y
common Constants,c_light,pi_circle,e_euler,i_complex,a_disp,b_disp
common PlotOrbLocal,pu,xu,yu,pl,xl,yl
;
forward_function aspect
;
if n_elements(overplot) eq 0 then overplot=0
;
; Check data
if n_elements(positions) eq 0 then begin
	print,'***Error(PLOTORBIT): no data!'
	return
endif
;
; Set character size
!p.charsize=1.5
;
; Set margins, number of plots, and axis styles
!p.multi=0
ymargin1=[8.0,2.0]
ymargin2=[6.0,4.0]/!d.y_ch_size*!d.x_ch_size
xstyle1=2
xstyle2=2
yfactor=1
!y.style=1
;
; Set number of plots
!p.multi=0
;
; Open a plot window for plotting on the screen
if n_elements(gen_model) ne 0 then star=gen_model.starid else star=' '
if not overplot then begin
if !d.name ne 'PS' then begin
	window,/free,title=star,xsize=!xsize,ysize=!ysize, $
		xpos=!dxsize-!xsize,ypos=!dysize-!ysize
endif else begin
        device,color=plotorbit_options.c
	tek_color
	set_ps,page_size='a4'
endelse
endif
if !d.name eq 'PS' then frame_color=0 else frame_color=1
!p.color=tci(frame_color)
;
; Determine whether automatic scaling is requested
if total(abs(!x.range)) eq 0 then xrange_auto=1 else xrange_auto=0
if total(abs(!y.range)) eq 0 then yrange_auto=1 else yrange_auto=0
!x.style=1
!y.style=1
;
; Set data
index=where(positions.component eq plotorbit_options.component,count)
if count eq 0 then begin
	print,'***Error(PLOTORBIT): no data for this component!'
	return
endif
positions_save=positions
positions=positions[index]
rho=positions.rho
theta=positions.theta
if plotorbit_options.j then $
	theta=precess_pa(theta,positions.jy,gen_model.ra,gen_model.dec,-1)
ra=rho*sin(theta)
dec=rho*cos(theta)
era=max([abs(positions.emajor*sin(positions.pa)), $
	 abs(positions.eminor*cos(positions.pa))])
edc=max([abs(positions.emajor*cos(positions.pa)), $
	 abs(positions.eminor*sin(positions.pa))])
;
; Prepare PlotorbitDataInfo
plotscans=positions
plotdata_x=ra
plotdata_y=dec
;
; Set and equalize ranges
if xrange_auto then !x.range=[max(ra+era),min(ra-era)] else !x.style=1
if yrange_auto then !y.range=[min(dec-edc),max(dec+edc)] else !y.style=1
; The Orbit Catalog has (north down, east to the right), so comment next line:
; if not xrange_auto then !x.range=!x.range(reverse(sort(!x.range)))
xrange=!x.range[0]-!x.range[1]
yrange=!y.range[1]-!y.range[0]
drange=xrange-yrange
if drange lt 0 then begin
	!x.range[0]=!x.range[0]-drange/2
	!x.range[1]=!x.range[1]+drange/2
endif else begin
	!y.range[0]=!y.range[0]-drange/2
	!y.range[1]=!y.range[1]+drange/2
endelse
;	if ds_x.item eq 50 and systemid ne 'Keck' and xrange_auto $
;		then !x.range=shift(!x.range,1)
;
; Plot frame
if not overplot then begin
	plot,[ra,ra],[dec,dec],/nodata,xrange=!x.range,yrange=!y.range, $
		xtitle='Right Ascension offset [mas]', $
		ytitle='Declination offset [mas]', $
		position=aspect(1.0,margin=0.15)+0.05, $
		title='';wmcc(plotorbit_options.component)
		pu=!p
		xu=!x
		yu=!y
endif else begin
		!p=pu
		!x=xu
		!y=yu
endelse
;
; Plot dotted cross lines
oplot,!x.crange,[0,0],linestyle=1,psym=0
oplot,[0,0],!y.crange,linestyle=1,psym=0
;
; Plot data
if plotorbit_options.e then begin
	rhom=positions.rhom
	them=positions.thetam
	if plotorbit_options.j then $
		them=precess_pa(them,positions.jy,gen_model.ra,gen_model.dec,-1)
	ram=rhom*sin(them)
	decm=rhom*cos(them)
	n=180
	p=findgen(n+1)*2*pi_circle/n
	n=360
	p=findgen(n+1)*pi_circle/180
	for i=0,n_elements(positions)-1 do begin
;		Note: we do not precess the error ellipse pa!
		r=ellipse(positions[i].emajor,positions[i].eminor, $
			p+positions[i].pa+pi_circle/2)
		x=r*cos(p)+ra[i]
		y=r*sin(p)+dec[i]
;		Plot uncertainty ellipse and red line connecting to orbit
		if overplot then !p.linestyle=2 else linestyle=0
		if positions[i].rho gt 0 then begin
			if !d.name eq 'PS' then thick=2 else thick=1
			oplot,x,y,psym=0,thick=1
			if not overplot then $
			oplot,[ra[i],ram[i]],[dec[i],decm[i]], $
				psym=0,color=tci(2),thick=thick
		endif else if plotorbit_options.f then begin
			oplot,x,y,psym=0,color=tci(2)
			if not overplot then $
			oplot,[ra[i],ram[i]],[dec[i],decm[i]], $
				psym=0,color=tci(2),thick=thick
		endif
		!p.linestyle=0
	endfor
endif else begin
	l=(!y.crange[1]-!y.crange[0])/5
	l=0.5*2	; units of charactersize
	n=45
	p=findgen(n+1)*2*pi_circle/n
	x=l*sin(p)
	y=l*cos(p)
	usersym,x,y,/fill
	index=where(positions.rho gt 0,count)
;	Use psym=8 for user symbol
	psym=8
	if plotorbit_options.t then psym=-psym
	if count gt 0 then oplot,ra[index],dec[index],psym=psym
	if plotorbit_options.f then begin
		index=where(positions.rho lt 0,count)
		if count gt 0 then oplot,ra[index],dec[index],psym=psym,color=tci(2)
	endif
endelse
;
; Code for user requests and object specifics
RAD=180/pi_circle
;
chris=0
if chris then begin
xyouts,ra[2]+15,dec[2]-2,'1998.2',charsize=1.3
xyouts,ra[6]+15,dec[6],'1999.1',charsize=1.3
xyouts,ra[12]+5,dec[12]+3,'2000.8',charsize=1.3
xyouts,ra[13]-2,dec[13],'2002.0',charsize=1.3
xyouts,ra[15]-2,dec[15],'2003.0',charsize=1.3
xyouts,ra[16]+5,dec[16]-5,'2004.2',charsize=1.3
endif
;
ken=0
if ken then begin
for year=1983,2005 do begin
rt=binarypos(julian(year,1,2),'B-C')
x0=rt[0]*sin(rt[1]/RAD)
y0=rt[0]*cos(rt[1]/RAD)
rt=binarypos(julian(year,1,1),'B-C')
x1=rt[0]*sin(rt[1]/RAD)
y1=rt[0]*cos(rt[1]/RAD)
rt=binarypos(julian(year,1,3),'B-C')
x2=rt[0]*sin(rt[1]/RAD)
y2=rt[0]*cos(rt[1]/RAD)
yy0=2.0/sqrt(1.+((y1-y2)/(x2-x1))^2)
xx0=yy0*((y1-y2)/(x2-x1))
y=yy0+y0
x=xx0+x0
oplot,[x,x0],[y,y0],psym=0
y=-yy0+y0
x=-xx0+x0
oplot,[x,x0],[y,y0],psym=0
if year mod 5 eq 0 then begin
yy0=7.0/sqrt(1.+((y1-y2)/(x2-x1))^2)
xx0=yy0*((y1-y2)/(x2-x1))
y=yy0+y0
x=xx0+x0
if year le 1995 or year eq 2005 then xyouts,x,y,string((year-1900) mod 100,forma
y=-yy0+y0
x=-xx0+x0
if year ge 1996 and year lt 2005 then xyouts,x,y,string((year-1900) mod 100,form
endif
endfor
endif
;
beate=0
if beate then begin
rt=binarypos(julian(2009,7,13))
x0=rt[0]*sin(rt[1]/RAD)
y0=rt[0]*cos(rt[1]/RAD)
oplot,[x0,x0],[y0,y0],psym=4
rt=binarypos(jy2jd(1991.2489))
rt=[1260,264.]
x0=rt[0]*sin(rt[1]/RAD)
y0=rt[0]*cos(rt[1]/RAD)
; oplot,[x0,x0],[y0,y0],psym=5
xyouts,-840,-260,'NACO',charsize=1
xyouts,-1120,-100,'Hp',charsize=1
endif
;
uxari_radio=0
if uxari_radio then begin
rt=binarypos(jy2jd(2001.7383))
x0=rt[0]*sin(rt[1]/RAD)
y0=rt[0]*cos(rt[1]/RAD)
oplot,[x0,x0],[y0,y0],psym=4
;rt=binarypos(jy2jd(1991.2489))
;rt=[1260,264.]
;x0=rt(0)*sin(rt(1)/RAD)
;y0=rt(0)*cos(rt(1)/RAD)
; oplot,[x0,x0],[y0,y0],psym=5
;xyouts,-840,-260,'NACO',charsize=1
;xyouts,-1120,-100,'Hp',charsize=1
endif
;
uxari=0
if uxari then begin
;	readmodel,'wd.model'
	n=45
	p=findgen(n+1)*2*pi_circle/n
	l=star_model[0].diameter/2 & l=l*1.25
	x=l*sin(p)
	y=l*cos(p)
	oplot,x,y,psym=0
	l=star_model[1].diameter/2 & l=l*1.25
	x=l*sin(p)
	y=l*cos(p)
;	rt=binarypos(julian(2012,12,5)+0.852) ; for Figure 6
	rt=binarypos(binary_model[0].epoch+2440000.d0+wilson()*binary_model.period)
	x=x+rt[0]*sin(rt[1]/RAD)
	y=y+rt[0]*cos(rt[1]/RAD)
	oplot,x,y,psym=0
endif
;
ups4eri=0
if ups4eri then begin
	n=45
	p=findgen(n+1)*2*pi_circle/n
	l=star_model[0].diameter/2
	x=l*sin(p)
	y=l*cos(p)
	oplot,x,y,psym=0
	l=star_model[1].diameter/2
	x=l*sin(p)
	y=l*cos(p)
	rt=binarypos(binary_model.epoch+2440000.d0+binary_model.period/2)
	x=x+rt[0]*sin(rt[1]/RAD)
	y=y+rt[0]*cos(rt[1]/RAD)
	oplot,x,y,psym=0
endif
;
alpdra=0
if alpdra then begin
	n=45
	p=findgen(n+1)*2*pi_circle/n
	l=star_model[0].diameter/2
	x=l*sin(p)
	y=l*cos(p)
	oplot,x,y,psym=0
	l=star_model[1].diameter/2
	x=l*sin(p)
	y=l*cos(p)
	rt=binarypos(binary_model.epoch+2440000.d0 $
		    +binary_model.period*wilson())
	x=x+rt[0]*sin(rt[1]/RAD)
	y=y+rt[0]*cos(rt[1]/RAD)
	oplot,x,y,psym=0
endif
;
algol=0
if algol then begin
	n=45
	p=findgen(n+1)*2*pi_circle/n
	l=star_model[0].diameter/2
	x=l*sin(p)
	y=l*cos(p)
	oplot,x,y,psym=0
	l=star_model[1].diameter/3
	x=l*sin(p)
	y=l*cos(p)
	rt=binarypos(binary_model[0].epoch+2440000.d0 $
		    +binary_model[0].period*wilson())
	x=x+rt[0]*sin(rt[1]/RAD)
	y=y+rt[0]*cos(rt[1]/RAD)
	oplot,x,y,psym=0
endif
;
; Plot model
if overplot then ls=2 else ls=0
if plotorbit_options.o then plotthiele,plotorbit_options.component,linestyle=ls
if plotorbit_options.l then plotellipse
;
; Reset plot variables
if xrange_auto then !x.range=0
if yrange_auto then !y.range=0
!p.color=tci(1)
;
; Restore full set of position data
positions=positions_save
;
end
