pro plotpollux
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Plot OPTIM3D-STAGGER (Chiavassa+ 2018) NIR spectra from POLLUX homepage.
; Paramaters are: Teff, g, [Fe/H], and [alpha/Fe].
; The spectra have R=20000, delta-lambda=0.0949 @ 1900 nm & 0.125 @ 2500 nm.
; GRAVITY spectra sampling: delta-lambda=0.246 nm.
;
forward_function pollux_models
;
common PlotPolluxObs,fits_file,wave,spec,error,qual,header,h_ext1,h_ext2
common PlotPolluxData,files,regions,r_label,t_grid,g_grid,t_eff,log_g
common PlotPolluxWids,opmenu_t_wid,opmenu_g_wid,m_list_wid
;
wave=0
spec=0
!x.range=[1900,2500]
!y.range=[0,1.2]
;
; STAGGER grid based on 31 regions
regions=strarr(56)
r_label=strarr(56)
t_grid=7000-findgen(7)*500
g_grid=5-findgen(8)*0.5
;
t_grid_str=string(t_grid,format='(i4)')
g_grid_str=string(g_grid,format='(f3.1)')
;
t_tol=240
l_tol=0.25
;
; Get filenames and parameter values
files=specname(findfile(!atmospheres_dir+'pollux/*.xdr'))
n=n_elements(files)
teffs_str=strmid(files,1,4) & teffs=float(teffs_str)
loggs_str=strmid(files,6,4) & loggs=float(loggs_str)
feovh_str=strmid(files,11,5) & feovh=float(feovh_str)
alpha_str=strmid(files,17,4) & alpha=float(alpha_str)
;
; Obtain indices of models for each region
tcount=0
for i=0,6 do begin
for j=0,7 do begin
	index=where(teffs lt (t_grid[i]+t_tol) and teffs gt (t_grid[i]-t_tol) $
		and loggs lt (g_grid[j]+l_tol) and loggs gt (g_grid[j]-l_tol),$
		count)
	tcount=tcount+count
	if count gt 0 then begin
		k=strarr(count)+'K '
		regions[i*6+j]=strjoin(string(index))
		r_label[i*6+j]=t_grid_str[i]+' '+g_grid_str[j]
	endif
endfor
endfor
;
; tcount must be equal the number of models
if tcount ne n then begin
	print,'Error: total models in regions not the same as #models!'
	return
endif
index=where(strlen(regions) gt 0)
regions=regions[index]
r_label=r_label[index]
;
pollux_wid=widget_base(/column,title='POLLUX spectra',resource_name='oyster')
draw_wid=widget_draw(pollux_wid,scr_xsize=1300,scr_ysize=400)
row_wid=widget_base(pollux_wid,/row)
;
t_grid=strtrim(string(fix(t_grid)),1)
g_grid=strtrim(string(g_grid,format='(f3.1)'),1)
opmenu_t_wid=widget_droplist(row_wid,title='T_eff', $
	event_func='pollux_t_event', $
	value=t_grid)
t_eff=t_grid[0]
;
index=where(strmid(r_label,0,4) eq t_eff)
r_logg=strmid(r_label[index],5,3)
opmenu_g_wid=widget_droplist(row_wid,title='log(g)', $
	event_func='pollux_g_event', $
	value=r_logg)
log_g=r_logg[0]
;
models=pollux_models()
m_list_wid=widget_list(row_wid,value=models,uvalue=models, $
	event_func='pollux_models_event',ysize=5)
;
fits_files=findfile('*.fits')
fits_files=['None',fits_files]
fits_files=fits_files[where(strlen(fits_files) gt 0)]
opmenu_d_wid=widget_droplist(row_wid,title='Observed data:', $
	event_func='pollux_obs_event', $
	uvalue=fits_files,value=fits_files)
;
; row_wid=widget_base(pollux_wid,/row)
combox_wid=cw_bgroup(row_wid,/row,/return_name, $
	['H-Line','V-Line','Window'], $
	event_funct='ww_polluxcommand')
;
widget_control,pollux_wid,/realize
xmanager,'pollux',pollux_wid,/no_block
end
