pro plotsplib
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Read and plot spectrum of a star selected from the Library of Stellar Spectra.
; (JACOBY, HUNTER AND CHRISTIAN 1984; National Space Science Data Center)
;
common PlotSplib,splib_wid,stars,fluxes,lambda
;
window,0,xsize=1024,ysize=500
fluxes=0
lambda=0
;
headers=''
status=dc_read_fixed(!catalogs_dir+'splib/headers.dat',headers,resize=[1], $
	format='(a160)',/col)
stars=strmid(headers,0,17)
splib_wid=widget_base(title=' SPLIB ',resource_name='oyster', $
	/column)
row_wid=widget_base(splib_wid,/row)
list_wid=widget_list(row_wid,value=stars, $
	event_pro='ww_loadsplib',ysize=12)
buttons=['He II','He I','H','Sun','Ca I','Ca II','Na I','Fe I']
button1_wid=cw_bgroup(row_wid,buttons,event_funct='ww_spliblines', $
	/column,/return_name)
buttons=['CH','CN','Mg I','Mg II','Ti II','Sr II','TiO','O_2']
button2_wid=cw_bgroup(row_wid,buttons,event_funct='ww_spliblines', $
	/column,/return_name)
devices=['Screen','File','PostScript']
device_wid=widget_droplist(splib_wid,title='Device:', $
	value=devices,uvalue=devices,event_pro='ww_plotdevice')
combox_wid=cw_bgroup(splib_wid,['Range','Quit'],event_funct='ww_splibcommand', $
	/row,/return_name)
widget_control,splib_wid,/realize
xmanager,'plot_splib',splib_wid,/no_block
;
end
