pro plotthiele,component,linestyle=linestyle
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Please note that for multiple systems measured at different epochs,
; no unique orbit can be plotted!
;
common ScanData,scans,bgscans,bufferinfo,positions,velocities,magnitudes
common Constants,c_light,pi_circle,e_euler,i_complex,a_disp,b_disp
common Model,gen_model,star_model,binary_model,gen_error,star_error,binary_error
common PlotOrbit,plotorbit_options
common ModelFit,parameters,ds_options
;
RAD=180/pi_circle
;
if n_elements(component) eq 0 then begin
	print,'***Error(PLOTTHIELE): component undefined!'
	return
endif
if n_elements(binary_model) eq 0 then begin
	print,'***Error(PLOTTHIELE): no model!'
	return
endif
if n_elements(linestyle) eq 0 then linestyle=0
;
i=where(component eq binary_model.component,count) & i=i[0]
if count eq 0 then begin
	print,'***Error(PLOTTHIELE): component not in model!'
	return
endif
;
index=where(positions.component eq component,count)
;
period=binary_model[i].period
; The epoch should be close to the median observing epoch...
if n_elements(positions) ge 3 then t=median(positions[index].jd) $
			      else t=avg(positions[index].jd)
n_cycles=fix((t-binary_model[i].epoch)/period)
t=binary_model[i].epoch+n_cycles*period
; ...unless you want to plot the periastron.
t=binary_model[i].epoch
;
num=360*4
phase=dindgen(num+1)/num
jd0=phase*period+binary_model[i].epoch
jds=phase*period+t
;
; Use shortest wavelength from model
lambda=fltarr(1)+gen_model.wavelengths[0]*1e-6
;
p=modelpos(jds)
pos1=dblarr(num+1,2)
if componentparse(component,comp_1,comp_2) ne 0 then return
tflux=0.d0
for k=0,strlen(comp_1)-1 do begin
	j=where(strmid(comp_1,k,1) eq star_model.component) & j=j[0]
	flux=stellarfluxes(star_model[j],lambda) $
	    *modelfluxes(star_model[j],lambda) & flux=total(flux)
	pos1=pos1+reform(p[*,j,*]*flux,num+1,2)
	tflux=tflux+flux
endfor
pos1=pos1/tflux
pos2=dblarr(num+1,2)
tflux=0.d0
for k=0,strlen(comp_2)-1 do begin
	j=where(strmid(comp_2,k,1) eq star_model.component) & j=j[0]
	flux=stellarfluxes(star_model[j],lambda) $
	    *modelfluxes(star_model[j],lambda) & flux=total(flux)
	pos2=pos2+reform(p[*,j,*]*flux,num+1,2)
	tflux=tflux+flux
endfor
pos2=pos2/tflux
dx=pos2[*,0]-pos1[*,0]
dy=pos2[*,1]-pos1[*,1]
;
if !d.name eq 'PS' then frame_color=0 else frame_color=1
!p.color=tci(frame_color)
;
if plotorbit_options.j then begin
	rho=sqrt(dx^2+dy^2)
	the=atan(dx,dy)
	the=precess_pa(the,jd2jy(jds+2440000L),gen_model.ra,gen_model.dec,-1)
	dx=rho*sin(the)
	dy=rho*cos(the)
endif
oplot,dx,dy,psym=0,linestyle=linestyle,thick=1
;
; Plot epoch of periastron for eccentric orbits
if binary_model[i].eccentricity ne 0 then $
oplot,[dx[0],0],[dy[0],0],psym=0
;
; Identify ascending node
if ds_options.s then begin
the=atan(dx,dy)*rad
if min(abs(the-binary_model[i].ascendingnode)) gt 1 then the=the+360
index=where(abs((the-binary_model[i].ascendingnode)) eq $
	 min(abs(the-binary_model[i].ascendingnode)))
phase_an=phase[index]
if phase_an[0] lt 0 then phase_an[0]=phase_an[0]+1
o_parms=dblarr(8)
o_parms[0]=binary_model[i].eccentricity
o_parms[1]=binary_model[i].inclination/RAD
o_parms[2]=binary_model[i].periastron/RAD
o_parms[3]=binary_model[i].apsidalmotion/RAD
o_parms[4]=binary_model[i].period
o_parms[5]=binary_model[i].epoch
o_parms[6]=1
o_parms[7]=1
v=true2vel(jd0[index],o_parms)
if v[1] lt 0 then begin
	print,'Warning: ascending node 180 degrees off!'
	ascendingnode=(binary_model[i].ascendingnode+180) mod 360
	index=where(abs((the-binary_model[i].ascendingnode)) eq $
		 min(abs(the-binary_model[i].ascendingnode)))
	phase_an=phase[index]
	if phase_an[0] lt 0 then phase_an[0]=phase_an[0]+1
endif
epoch=phase_an*period+t
print,'Epoch of ascending node: ',2440000.d0+jd0[index]
print,'Phase of secondary at ascending node: ',phase_an[0]
oplot,[dx[index],0],[dy[index],0],psym=0,linestyle=2
endif
;
return
;
; For AAS photo release
oplot,dx[40:1800],dy[40:1800],psym=0
;
; Kepler triangles
polyfill,[0,dx[1756:1800],0],[0,dy[1756:1800],0],color=tci(7)
; polyfill,[0,dx(856:900),0],[0,dy(856:900),0],color=tci(7)
polyfill,[0,dx[966:1010],0],[0,dy[966:1010],0],color=tci(7)
;
; Arrow stem
oplot,dx[0:30],dy[0:30],psym=0,thick=2,color=tci(2)
;
; Arrow head
x=[0,-0.9,4.9,-0.9,0]*0.2
y=[0,2.3,0,-2.3,0]*0.2
angle=atan(dy[29]-dy[30],dx[29]-dx[30])
xr=+x*cos(angle)+y*sin(angle)
yr=-x*sin(angle)+y*cos(angle)
usersym,xr,yr,/fill
oplot,[dx[30],dx[30]],[dy[30],dy[30]],psym=8,color=tci(2)
;
; Stellar disks
l=0.4
n=45
p=findgen(n+1)*2*pi_circle/n
x=l*sin(p)
y=l*cos(p)
polyfill,x,y,color=tci(5)
polyfill,x+dx[1800],y+dy[1800],color=tci(5)
; usersym,x,y,/fill
; oplot,[dx(1800),dx(1800)],[dy(1800),dy(1800)],psym=8,color=tci(5)
; oplot,[0,0],[0,0],psym=8,color=tci(5)
;
end
