pro plottlusty
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Plot visual spectra downloaded from TLUSTY homepage.
;
common PlotTlusty,files_wid,files,teffs,loggs,teff,logg,vsini,deltam
;
; window_slide,xsize=8000,xv=1000
;
; Get filenames
files=specname(findfile(!atmospheres_dir+'tlusty/*.vis.7.gz'))
n=n_elements(files)
teffs=strarr(n)
loggs=strarr(n)
for i=0,n-1 do begin
	words=nameparse(files[i],['B','G','g','v'])
	teffs[i]=words[1]
	loggs[i]=words[2]
endfor
teffs=unique(teffs)
loggs=unique(loggs)
nt=n_elements(teffs)
nl=n_elements(loggs)
values=strarr(nt,nl)
for i=0,nt-1 do begin
for j=0,nl-1 do begin
index=where(strpos(files,teffs[i]) eq 1 and strpos(files,loggs[j]) eq 7,count)
if count gt 0 then values[i,j]='X'
endfor
endfor
teff=teffs[0]
logg=loggs[0]
tlabels=string(float(teffs)/1000,format='(f4.1)')
;
tlusty_wid=widget_base(title=' TLUSTY ',resource_name='oyster', $
	/column)
if 0 then begin
row_wid=widget_base(tlusty_wid,/row)
list_wid=widget_list(row_wid,value=teffs, $
	event_pro='ww_tlustyteff',ysize=12)
list_wid=widget_list(row_wid,value=loggs, $
	event_pro='ww_tlustylogg',ysize=12)
files_wid=widget_list(row_wid,value=files, $
	event_pro='ww_loadtlusty',ysize=12)
endif
draw_wid=widget_draw(tlusty_wid, $
	scr_xsize=1800,scr_ysize=200)
table_wid=widget_table(tlusty_wid,value=values, $
	/all_events,event_pro='ww_loadtlusty', $
	row_labels=loggs,column_labels=teffs)
row_wid=widget_base(tlusty_wid,/row)
combox_wid=cw_bgroup(row_wid,/row,/return_name, $
	['H-Line','V-Line','Window', $
	 'CII 4267','OII 4414','HeII 4542','OII 4943','CIII 5696','CIV 5812'], $
	event_funct='ww_tlustycommand')
vsinis=string(indgen(6)*20,format='(i3)')
vsini=0
opmenuv_wid=widget_droplist(row_wid,title='V*sin(i) [km/s]:', $
		event_pro='ww_tlustyvsini',value=vsinis,uvalue=vsinis)
deltams=string((findgen(9)-4)*0.5,format='(f4.1)')
deltam=deltams[0]
opmenum_wid=widget_droplist(row_wid,title='Delta-m:', $
		event_pro='ww_tlustydm',value=deltams,uvalue=deltams)
widget_control,tlusty_wid,/realize
xmanager,'plot_tlusty',tlusty_wid,/no_block
;
end
