pro plotuptime,from_data,stars=stars,stations=stations,polar=polar
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; For the stars in startable and stations in GenConfig, compute rise
; and set times and plot. Use stars and stations to initialize StarTable
; and GenConfig.
;
; Get actual times from scan data if requested (from_data=1).
;
common StarBase,startable,notes
common SysConfig,SystemId,Date,MetroConfig,GenConfig,GeoParms,GenInfo,GeoInfo
common LocalRiseSet,date_p,system_p,stars_p,stations_p, $
                times,gst,za_sun,za_moon,ha_moon,az_moon, $
                za_star_p,ha_star_p,az_star_p, $
                sun_ok,moon_ok,zas_ok,sid_ok_p,fdl_ok_p
;
if n_elements(stars) gt 0 then get_startable,stars
if n_elements(stations) gt 0 $
or n_elements(genconfig) eq 0 then get_sysconfig,stations=stations
if n_elements(polar) eq 0 then polar=0
;
num_stars=n_elements(startable)
if num_stars eq 0 then begin
	print,'***Error(PLOTUPTIME): no stars defined!'
	return
endif
if num_stars gt 40 then begin
	print,'***Error(PLOTUPTIME): too many stars to plot legibly!'
	return
endif
;
if n_elements(from_data) eq 0 then from_data=0
;
riseset,uptime,nighttime
if n_elements(uptime) eq 0 then return
if from_data then roseset,uptime
;
uptime=uptime/3600 & nighttime=nighttime/3600
index=where(uptime[1,*] lt uptime[0,*],count)
if count gt 0 then uptime[0,index]=uptime[0,index]-24
;
!p.multi=0
!p.color=tci(1)
IF NOT polar THEN BEGIN
if !d.window lt 0 then window,xsize=1000,ysize=300
x=findgen(num_stars)
y=fltarr(num_stars) & y[0]=13
xlabels1=startable.starid
xlabels2=xlabels1
if num_stars gt 20 then begin
	xlabels1[where(indgen(num_stars) mod 2 eq 0)]=' '
	xlabels2[where(indgen(num_stars) mod 2 eq 1)]=' '
endif else xlabels2[*]=' '
plot,x,y,/nodata,yrange=[nighttime[0],nighttime[1]], $
   xtickname=xlabels1,xticks=num_stars-1,xtickv=x,xstyle=2, $
   xtitle='Visibility for '+Date $
	 +' ('+strjoin(genconfig.stationid[0:genconfig.numsid-1],' ')+')', $
   ytitle='UT',charsize=1.5,ytickv=findgen(24), $
   yticks=fix(nighttime[1]-nighttime[0]+3)
t_x_c_n=!x.s[0]+(num_stars-1)*!x.s[1]+!d.x_ch_size/!d.x_vsize
t_x_c_d=(t_x_c_n-!x.s[0])/!x.s[1]
irange=fix(!y.crange)
for i=irange[0],irange[1] do begin
	if i gt nighttime[0] and i lt nighttime[1] then color=4 else color=6
	oplot,!x.crange,float([i,i]),psym=0,color=tci(color)
	all=0
	for j=0,num_stars-1 do $
		if i gt uptime[0,j] and i lt uptime[1,j] then all=all+1
	xyouts,t_x_c_d,float(i)-0.2,string(all,format='(i2)'),charsize=1.0
endfor
for i=0,num_stars-1 do begin
	oplot,fltarr(2)+i,uptime[0:1,i],thick=4,psym=0
endfor
ENDIF ELSE BEGIN
if !d.window lt 0 then window,xsize=600,ysize=600
!x.ticks=2
!x.tickname=[' ','S',' ']
!x.tickv=[-90,0,90]
!y.ticks=2
!y.tickname=[' ','W',' ']
!y.tickv=[-90,0,90]
if strupcase(!version.os_name) eq 'HP-UX' then !p.charsize=1.0 $
					  else !p.charsize=1.5
!x.margin=[3,3]
!y.margin=[3,3]
n_az=360
theta=findgen(n_az)/180*!pi
r=fltarr(n_az)+90
plot,r,theta,/polar,xrange=[-90,90],yrange=[-90,90],xstyle=1,ystyle=1, $
   title='Visibility '+Date $
	 +' ('+strjoin(genconfig.stationid[0:genconfig.numsid-1],' ')+')'
; Plot coordinate circles
for i=10,80,10 do begin
	r[*]=i
	oplot,r,theta,psym=0,linestyle=1,/polar
;	xyouts, -20.,r[0]+2,string(fix(90-r[0])),color=tci(4)
	xyouts,r[0]-17,0,string(fix(90-r[0])),color=4
endfor
; Plot coordinate cross
oplot,fltarr(180),findgen(180)-90
oplot,findgen(180)-90,fltarr(180)
theta=findgen(36)/18*!pi
usersym,sin(theta),cos(theta),/fill
ut=systime(/utc)
ut=float(strmid(ut,11,2))+float(strmid(ut,14,2))/60
oplot,za_moon,(az_moon+90)/180*!pi,/polar,psym=0,color=tci(7)
mndex=where(abs(times/3600-ut) eq min(abs(times/3600-ut)))
oplot,za_moon[mndex],(az_moon[mndex]+90)/180*!pi,/polar,psym=8,symsize=2,color=t
for i=0,num_stars-1 do begin
	index=where(sun_ok and zas_ok[*,i] and sid_ok_p[*,i] and fdl_ok_p[*,i],count)
	if count ge 1 then begin
;	Plot moon trail
;	oplot,za_moon_p(index,i),(az_moon_p(index,i)+90)/180*!pi,/polar,psym=0,color=t
;	mndex=where(abs(times/3600-ut) eq min(abs(times/3600-ut)))
;	oplot,za_moon_p(mndex,i),(az_moon_p(mndex,i)+90)/180*!pi,/polar, $
;		psym=8,symsize=2,color=tci(7)
;	Plot star trails
	oplot,za_star_p[index,i],(az_star_p[index,i]+90)/180*!pi,/polar,psym=0
; 	Plot 1hr intervals
	j=where(abs(times[index]/3600-nint(times[index]/3600)) lt 0.06)
	oplot,za_star_p[index[j],i],(az_star_p[index[j],i]+90)/180*!pi,/polar,psym=8
;	Plot current position of stars
	index=where(abs(times/3600-ut) eq min(abs(times/3600-ut)))
	oplot,za_star_p[index,i],(az_star_p[index,i]+90)/180*!pi,/polar, $
		psym=getsymbol(i+1),symsize=1.5,color=tci(3)
;	Print symbol and star label
	oplot,[-85.,-85.],86-[i*6,i*6],psym=getsymbol(i+1),color=tci(3)
	star_label=strtrim(startable[i].name,2)
	if strlen(star_label) eq 0 then $
	star_label=strtrim(startable[i].var,2)
	if strlen(star_label) eq 0 then $
	star_label=strtrim(startable[i].starid,2)
	xyouts,-80.,84-i*6,star_label,color=tci(3)
	endif
endfor
;
; For VINCI observations, overlay shadow map
if system_id(systemid) eq 'VLTI' then $
	vignet,genconfig.stationid
ENDELSE
;
set_screen
;
end
