pro plotuv1,overplot=overplot,ms1=ms1
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; This procedure makes uv-coordinate based plots.
; Original version, superceded by HR version following this one.
; This procedure works better with SAM data, however.
;
common DataSelInfo,class,type,slice,ds_nights,ds_stars,ds_x,ds_y,ds_z,ps_options
common PlotDataInfo,plotscans,plotdata_x,plotdata_y,plotdata_y_bck
common SysConfig,SystemId,Date,MetroConfig,GenConfig,GeoParms,GenInfo,GeoInfo
common ScanData,scans,bgscans,bufferinfo,positions,velocities,magnitudes
common Model,gen_model,star_model,binary_model,gen_error,star_error,binary_error
common Tables,ScanTable,BGTable,StationTable
common StarBase,StarTable,Notes
common PlacementInfo,xpix_per_char,ypix_per_char, $
		     title_yoffset,title_xoffset, $
		     xtitle_xoffset,xtitle_yoffset, $
		     ytitle_xoffset,ytitle_yoffset, $
		     num_title,max_star_per_title,xpix_per_star, $
		     num_xtitle,max_xlabel_per_title,xpix_per_xlabel, $
		     num_ytitle,max_ylabel_per_title,xpix_per_ylabel
common Constants,c_light,pi_circle,e_euler,i_complex,a_disp,b_disp
common LocalPlotUV,is_idx,is_stars
; common LocalPlotUV,model_x,model_y
;
; Check data selection
if printselerror(checkplotsel('x')) ne 0 then return
if printselerror(checkplotsel('y')) ne 0 then return
;
; If overplot=0 then open a new window
do_multi_nights=0
if n_elements(overplot) eq 0 then overplot=0 else do_multi_nights=1
do_multi_nights=0
if overplot eq 0 then begin
	is_idx=0
	is_stars=''
endif
;
if n_elements(ds_stars) eq 0 then begin
	print,'Warning(PLOTUV): no stars selected, using all stars!'
	list_stars,ds_stars
endif
;
set_streamsel,'y',item,ds_ib,ds_ob,ds_tr,ds_ch,ds_bl,ds_pt
ax_items=set_axitems(item_ids,units)
ax_items=ax_items+units
pt=ds_pt
if n_elements(pt) eq 1 then pt=[pt,pt]
;
; Determine number of plots
num_stars=n_elements(ds_stars)
num_h=long(sqrt(num_stars))
if num_h*num_h ne num_stars then begin
	if num_stars-num_h*num_h gt num_h then begin
		num_h=num_h+1
		num_v=num_h
	endif else num_v=num_h+1
endif else num_v=num_h
; !p.multi=[#plots remaining,#plot columns,#plot rows,#plots stacked in Z,
;           0:left to right and top to bottom;1:top to bottom and left to right]
if ps_options.a then !p.multi=0 else !p.multi=[0,num_h,num_v,0,1]
;
; For multiple plots, IDL reduces the charsize by a factor of 2
!p.charsize=1.5
if !p.multi[1]*!p.multi[2] le 1 then !p.charsize=1.5
if !p.multi[1] gt 2 or !p.multi[2] gt 2 then begin
	!p.charsize=2.0
	scale_cs=2.0
endif else scale_cs=1.0
;
; Open a plot window
!xsize=512
!ysize=!xsize*(0.25/0.27)
if !d.name ne 'PS' then begin
	if overplot eq 0 or !d.x_vsize le 4 then begin
	window,/free,title=Date+', Class: uv',xsize=!xsize,ysize=!ysize, $
		xpos=!dxsize-!xsize,ypos=!dysize-!ysize
	endif
endif else if !d.name eq 'PS' then begin
	device,color=ps_options.c
	tek_color
	if ps_options.p then begin
		if scale_cs eq 1 then !p.charsize=1.5 else !p.charsize=2.0
	endif
endif else begin
	print,'***Error(PLOTUV): invalid device name!'
	return
endelse
model_x=0
model_y=0
model_z=0
if !d.name eq 'PS' then frame_color=0 else frame_color=1
!p.color=tci(frame_color)
;
; For option All in 1 we have to go through the data twice to find the
; number of plots in a window (num_plot) and the total range of data values.
if ps_options.a then num_run=2 else num_run=1
;
; Compute some auxilliary variables
titleplacement,'t',' '
;
; All spectrometers or just one?
if ps_options.o then begin
	f_ob=0
	l_ob=GenConfig.NumOutBeam-1
endif else begin
	f_ob=ds_ob
	l_ob=ds_ob
endelse
;
; Compute more auxilliary plot variables
if ps_options.o then num_xlabel=produkt(GenConfig.NumSpecChan) $
	        else num_xlabel=n_elements(ds_ch)
titleplacement,'x',dummy,' ',0
titleplacement,'y',dummy,' ',0
;
if ds_x.item ge 50 and ds_y.item ge 50 then do_uv=1 else do_uv=0
;
; Determine whether automatic scaling is requested
if total(abs(!x.range)) eq 0 then xrange_auto=1 else xrange_auto=0
if total(abs(!y.range)) eq 0 then yrange_auto=1 else yrange_auto=0
;
FOR run_no=1,num_run DO BEGIN
first=1
;
for is=0,n_elements(ds_stars)-1 do begin
;
;       First, we have to find out about the ranges
	if run_no eq 1 then begin
	if not ps_options.a then first=1
	for ob=f_ob,l_ob do begin
		l_bl=n_elements(ds_bl)-1
		l_ch=n_elements(ds_ch)-1
		l_pt=n_elements(pt)-1
		for ib=0,l_bl do begin
		for ic=0,l_ch do begin
		   ibase=ds_bl[ib]
		   ichan=ds_ch[ic]
		   itriple=0
	   	   udata=set_plotdata(ds_x.item,ds_ib,ob,itriple,ds_ch,ibase,pt)
		   vdata=set_plotdata(ds_y.item,ds_ib,ob,itriple,ds_ch,ibase,pt)
;       	   For editing, select VisSqCErr
		   vis_err=set_ploterr(25,ds_ib,ob,itriple,ichan,ibase,pt)
		   index=where(scans[pt].starid eq ds_stars[is],count)
		   if count gt 0 then begin
		        u=udata[index]
		        v=vdata[index]
		        e=vis_err[index]
		        if ps_options.f then begin
				count=n_elements(e)
				index=indgen(count)
			endif else index=where(e gt 0,count)
			if count gt 0 then begin
				if first then begin
					umax=max(u[index])
					umin=min(u[index])
					vmax=max(v[index])
					vmin=min(v[index])
					first=0
				endif else begin
					umax=max([umax,max(u[index])])
					umin=min([umin,min(u[index])])
					vmax=max([vmax,max(v[index])])
					vmin=min([vmin,min(v[index])])
				endelse
			endif
		   endif else begin
			print,'***Warning(PLOTUV): no data for star: ', $
				ds_stars[is]
		   endelse
		endfor
		endfor
	endfor
	if ps_options.a then goto,SKIPPLOT
	endif	; run_no eq 1
;
        if n_elements(umin) eq 0 then begin
		if n_elements(ds_stars) eq 1 and not do_multi_nights then begin
			if !d.name ne 'PS' then begin
;				window,/free
				xyouts,0.4,0.5,'No data',/normal,charsize=2
			endif else print,'No data'
		endif
		goto,SKIPPLOT	; do this if plotting several nights together
	endif
;
;	Prepare frame titles
	if ps_options.o eq 0 then begin
		title0='OB: '+string(ob,format='(i1)')
		title1='Bl: '
		for i=0,n_elements(ds_bl)-1 do $
			title1=title1+strcompress(string(ds_bl[i]+1))
		title1='Bl: '+retroparse(ds_bl+1)
		title2='Ch: '+retroparse(ds_ch+1)
	endif else begin
		title0='OB: '
		for i=f_ob,l_ob do $
			title0=title0+strcompress(string(i+1))
		title1='Bl: '
		for i=0,n_elements(ds_bl)-1 do $
			title1=title1+strcompress(string(ds_bl[i]+1))
		title2='Ch: '+retroparse(ds_ch+1)
	endelse
	if n_elements(ds_nights) gt 1 then begin
		titleo=strtrim(string(n_elements(ds_nights)),2)+' nights '
		if ps_options.o then title0='All OB'
		title0=titleo+title0
		title1=''
		title2=''
	endif
	title=title0
	if strlen(title1) ne 0 then title=title+', '+title1
	if strlen(title2) ne 0 then title=title+', '+title2
;
;	uv plots: equalize scales
	if do_uv and xrange_auto then begin
		dmax=max([umax,vmax,-umin,-vmin])
		dmin=-dmax
		umin=dmin
		umax=dmax
		vmin=dmin
		vmax=dmax
	endif
;
; 	Set plot ranges
	if yrange_auto then !y.range=[vmin,vmax]
	if xrange_auto then !x.range=[umin,umax]
;	uv-coverage is plotted as projected onto the sky, i.e.
;	the u coordinate increases to the left (east)
	if ds_x.item eq 50 and systemid ne 'Keck' and xrange_auto $
		then !x.range=shift(!x.range,1)
;
;	Plot (empty) frame for first star and multiple plots
	if (is eq 0 or not ps_options.a) and overplot eq 0 then $
	plot,udata,vdata,/nodata, $
	 	xtitle=ax_items[long(where(item_ids eq ds_x.item),0)], $
	 	ytitle=ax_items[long(where(item_ids eq ds_y.item),0)]
;
;	Put titles for All-in-1 (but not if paper option is selected)
	if is eq 0 and ps_options.a and not ps_options.p then $
	xyouts,0.1,!y.window[1]+float(ypix_per_char)/!d.y_size/scale_cs, $
		title,/normal,size=!p.charsize/scale_cs
;
;	Put date along side if showing data for one night only
	if is eq 0 and not ps_options.p $
		   and n_elements(ds_nights) eq 1 then $
	xyouts,1.0-float(ypix_per_char)/!d.x_size,!y.window[1], $
		Date,/normal,orientation=-90,size=!p.charsize/scale_cs
;
	if is eq 0 and do_uv then begin
		n=17+3
		c=4
		l=fltarr(n)+c	; units of character size
		if ds_x.item eq 50 and ds_y.item eq 51 then sense=0 else sense=1
		if startable[where(startable.starid eq ds_stars[is])].dec lt 0 $
			then sense=sense-0.5 lt 0
		p=pi_circle*sense-signof(sense-0.5)*findgen(n)/(n-5)*pi_circle
		p[n-3]=pi_circle*(1-sense) & l[n-3]=c-0.2*c
		p[n-2]=pi_circle*(1-sense) & l[n-2]=c+0.2*c
		p[n-1]=p[n-4] & l[n-1]=l[n-4]
		x=l*sin(p)
		y=l*cos(p)
;		Plot curved arrow to indicate Earth's rotation
		usersym,x,y,thick=2
		if do_uv and not ps_options.p then oplot,[0,0],[0,0],psym=8
;
		l=0.5		; units of character size
		n=45
		p=findgen(n+1)*2*pi_circle/n
		x=l*sin(p)
		y=l*cos(p)
;		Use thick dot unless a lot of points have to be plotted
		usersym,x,y,/fill
		!p.psym=8
		if n_elements(ds_ch) gt 100 then !p.psym=3
	endif
	if not do_uv then !p.psym=1
;
;	Prepare for star labels
	num_char_per_label=max(strlen(ds_stars)+1)
	max_num_xlabel=fix((!x.window[1]-!x.window[0]) $
		      /(num_char_per_label*float(xpix_per_char)/!d.x_size))-1
;	Only put label if it hasn't been put before (scount eq 0)
	sindex=where(is_stars eq ds_stars[is],scount)
	if scount eq 0 then begin
		if is_idx eq 0 then is_stars=ds_stars[is] $
			       else is_stars=[is_stars,ds_stars[is]]
	endif
	sindex=where(is_stars eq ds_stars[is])
	if ps_options.a then !p.color=getcolor(sindex[0])
	if n_elements(ds_stars) eq 1 then !p.color=tci(frame_color)
	k=where(startable.starid eq ds_stars[is])
	star_name=startable[k].name
	if not ps_options.a then begin
;		Single star label
		xyouts,!x.window[0], $
		       !y.window[1]+1*float(ypix_per_char)/!d.y_size, $
		       star_name,/normal,size=!p.charsize/scale_cs
	endif else begin
		if not ps_options.p and scount eq 0 then $
		xyouts,!x.window[0] $
			+(2+(is_idx mod max_num_xlabel)*num_char_per_label) $
				    *float(xpix_per_char)/!d.x_size, $
       		       !y.window[1]-(2+is_idx/max_num_xlabel) $
				    *float(ypix_per_char)/!d.y_size, $
			star_name,/normal,size=!p.charsize/scale_cs
	endelse
	if scount eq 0 then is_idx=is_idx+1
	if ps_options.l then !p.psym=-abs(!p.psym) else !p.psym=abs(!p.psym)
;
; 	Now that we have the range, we plot the data for this star
	for ob=f_ob,l_ob do begin
		for ib=0,n_elements(ds_bl)-1 do begin
		nch=0
		for ic=0,n_elements(ds_ch)-1 do begin
		   ibase=ds_bl[ib]
		   ichan=ds_ch[ic]
		   itriple=0
		   udata=set_plotdata(ds_x.item,ds_ib,ob,itriple,ichan,ibase,pt)
		   vdata=set_plotdata(ds_y.item,ds_ib,ob,itriple,ichan,ibase,pt)
;       	   For editing, select VisSqCErr
		   vis_err=set_ploterr(25,ds_ib,ob,itriple,ichan,ibase,pt)
		   index=where(scans[pt].starid eq ds_stars[is])
		   u=udata[index]
		   v=vdata[index]
		   e=vis_err[index]
;            	   Edit the data
		   index=where(e ge 0,count)
		   if count gt 0 then begin
			if ps_options.a then !p.color=getcolor(sindex[0]) $
					else !p.color=getcolor(ob)
			if not ps_options.a and genconfig.numoutbeam eq 1 $
					then !p.color=tci(frame_color)
;			if overplot then !p.color=getcolor(overplot+1)
			oplot,u[index],v[index]
			if do_uv then oplot,-u[index],-v[index]
			if ps_options.e and ds_y.item eq 25 then begin
				if count gt 1 then $
				oploterror,u[index],v[index],u[index]*0,e[index], $
					color=!p.color else $
				oploterror,[u[index],u[index]], $
					 [v[index],v[index]], $
					 [u[index],u[index]]*0, $
					 [e[index],e[index]],color=!p.color
			endif
		   endif
		   if ps_options.f eq 1 then begin
			index=where(e lt 0,count)
			if count ne 0 then begin
			!p.color=tci(2)
			oplot,u[index],v[index]
			if do_uv then oplot,-u[index],-v[index]
			if ps_options.e and ds_y.item eq 25 then begin
			if count gt 1 then $
				oploterror,u[index],v[index], $
					u[index]*0,e[index] $
					else $
				oploterror,[u[0],u[0]],[v[0],v[0]], $
					[u[0],u[0]]*0,[e[0],e[0]]
			endif
			endif
		   endif
		   if ps_options.m then begin
		   if n_elements(star_model) eq 0 then $
			print,'***Error(PLOTUV): no model!' $
		   else if gen_model[0].starid ne ds_stars[is] then $
			print,'***Error(PLOTUV): no model for this star!' $
		   else begin
			mitem=0
			if ds_y.item eq 25 then mitem=57
			if mitem ne 0 then begin
			ymodel=set_plotdata(mitem,ds_ib,ob,itriple,ichan,ibase,pt)
			if n_elements(ymodel) eq 1 then ymodel=fltarr(1)+ymodel
			index=where(scans[pt].starid eq ds_stars[is])
			jndex=where(vis_err[index] gt 0,count)
			if count gt 0 then begin
				nch=nch+1
				x=udata[index[jndex]]
				y=ymodel[index[jndex]]
				su=uniq(x)
				x=x[su]
				y=y[su]
				t=scans[pt].time
				si=sort(x)
				x=x[si]
				y=y[si]
;				Overplot all model values of this bl/ch
;				oplot,x,y,psym=-7,color=tci(frame_color)
				model_x=[model_x,x]
				model_y=[model_y,y]
				if keyword_set(ms1) then begin
				ds=scans
				scans=ms1
				zmodel=set_plotdata(mitem,ds_ib,ob, $
						    itriple,ichan,ibase,pt)
				if n_elements(zmodel) eq 1 then $
					zmodel=fltarr(1)+zmodel
				z=zmodel[index[jndex]]
				scans=ds
				z=z[si]
				model_z=[model_z,z]
				endif
			endif
			endif
		   endelse
		   endif
		endfor
		endfor
	endfor
;	Plot accumulated model data to get data points connected
	!p.color=tci(frame_color)
	if ps_options.m and n_elements(model_x) gt 1 and not do_uv then begin
	x=model_x[1:n_elements(model_x)-1]
	y=model_y[1:n_elements(model_y)-1]
	if keyword_set(ms1) then z=model_z[1:n_elements(model_z)-1]
	if nch gt 1 and ib gt 1 then begin
		si=sort(x)
		oplot,x[si],y[si],psym=0
		if keyword_set(ms1) then $
			oplot,x[si],z[si],psym=0,linestyle=2
	endif else if nch gt 1 then begin
;		Multi-channel, group by channel
		npt=n_elements(x)/nch
		for i=0,npt-1 do begin
			oplot,x[indgen(nch)*npt+i],y[indgen(nch)*npt+i], $
				psym=0
			if keyword_set(ms1) then $
			oplot,x[indgen(nch)*npt+i],z[indgen(nch)*npt+i], $
				psym=0,linestyle=2
		endfor
	endif else begin
;		Single channel
		si=sort(x)
		oplot,x[si],y[si],psym=7*0
		if keyword_set(ms1) then $
		oplot,x[si],z[si],psym=4*0,linestyle=2
	endelse
	model_x=0
	model_y=0
	endif
	SKIPPLOT:	; goto next star
endfor
ENDFOR
;
; Reset plot ranges, colors, ...
if xrange_auto then !x.range=0
if yrange_auto then !y.range=0
!p.multi=0
!p.color=tci(1)
!x.title=''
!y.title=''
;
end
