pro plotvel,overplot=overplot
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Plots multiple star velocities.
;
; Some information (obsolete) on symbols and colors:
; !p.psym=0: no symbol, connect points with lines
;         1: +
;         2: *
;         3: .
;         4: Diamond
;         5: Triangle
;         6: Square
;         7: x
;         8: Star
;         9: Circle
; New procedure for plot symbols: plotsymbol
;    open/filled
;	0/10: +
;	1/11: x
;	2/12: *
;	3/13: Triangle up
;	4/14: Triangle down
;	5/15: Square
;	6/16: Diamond
;	7/17: Pentagon
;	8/18: Star
;	9/19: Circle
;
; tek_color
; !p.color=0: black
;          1: white
;          2: red
;          3: green
;          4: blue
;          .
;          .
;         31: <last color index>
;
common ScanData,scans,bgscans,bufferinfo,positions,velocities,magnitudes
common Model,gen_model,star_model,binary_model,gen_error,star_error,binary_error
common PlotVel,plotvel_options
common PlotVelDataInfo,plotscans,plotdata_x,plotdata_y
common Constants,c_light,pi_circle,e_euler,i_complex,a_disp,b_disp
common PlotVelLocal,pu,xu,yu,pl,xl,yl
;
; keyword overplot may not be needed...
if n_elements(overplot) eq 0 then overplot=0
overplot=0
;
; Check data
if n_elements(velocities) eq 0 then begin
	print,'***Error(PLOTVEL): no data!'
	return
endif
;
; Prepare PlotvelDataInfo
plotscans=velocities
;
; Set character size
!p.charsize=1.5
;
if plotvel_options.a then begin
	overplot=1
	plotvel_options_r=plotvel_options.r
	components=unique(velocities.component)
	components=components[sort(star_model.mass)]
;	plotvel_options.r=0
endif else components=plotvel_options.component
;
; Set margins, number of plots, and axis styles
xvmargin=[8.0,2.0]
yvmargin=[6.0,4.0]/!d.y_ch_size*!d.x_ch_size
if plotvel_options.r and plotvel_options.o then begin
	!p.multi=[0,1,2]
	ymargin1=[yvmargin[0]*0,yvmargin[1]]
	ymargin2=[yvmargin[0],yvmargin[1]*0]
	xstyle1=6
	xstyle2=2
	yfactor=1.5
endif else begin
	!p.multi=0
	ymargin1=yvmargin
	ymargin2=yvmargin
	xstyle1=2
	xstyle2=2
	yfactor=1
endelse
!y.style=1
;
; Open a plot window for plotting on the screen
if n_elements(gen_model) ne 0 then star=gen_model.starid else star=' '
; if not overplot or plotvel_options.a then begin
if !d.name ne 'PS' then begin
	window,/free,title=star,xsize=!xsize,ysize=!ysize, $
		xpos=!dxsize-!xsize,ypos=!dysize-!ysize
endif else begin
        device,color=plotvel_options.c
	tek_color
	page_size=din_size(landscape)
;	set_ps,page_size=page_size,landscape=landscape
	set_ps,page_size='a4',/landscape
endelse
; endif
if !d.name eq 'PS' then frame_color=0 else frame_color=1
!p.color=tci(frame_color)
;
; Determine whether automatic scaling is requested
if total(abs(!x.range)) eq 0 then xrange_auto=1 else xrange_auto=0
if total(abs(!y.range)) eq 0 then yrange_auto=1 else yrange_auto=0
;
FOR k=0,n_elements(components)-1 DO BEGIN
;
; Set data
index=where(velocities.component eq components[k],count)
if count eq 0 then begin
	print,'***Error(PLOTVEL): no data for this component!'
	return
endif
t=velocities[index].jd
y=velocities[index].value
e=velocities[index].error
v=velocities[index].valuem
p=velocities[index].symbol
c=velocities[index].color
jndex=where(c eq 1,count)
if count gt 0 then c[jndex]=frame_color
plotscans=plotscans[index]
count_ho=0
if plotvel_options.p and num_binary() gt 0 then begin
;	Compute orbital phase using lowest hierarchical level binary component
	ci=strpos(binary_model.component,components[k])
	i=where(ci ge 0)
	bin_components=binary_model[i].component
	periods=binary_model[i].period
	si=sort(strlen(bin_components))
	bin_components=bin_components[si]
	periods=periods[si]
	j=where(periods ne 0) & j=j[0]
	i=where(binary_model.component eq bin_components[j]) & i=i[0]
	x=(velocities[index].jd-binary_model[i].epoch)/binary_model[i].period $
		mod 1
	xtitle='Orbital phase'
;	x=(x-wilson()) mod 1	; Plots versus binary phase
;	xtitle='Binary phase'
	index=where(x lt 0,count)
	if count gt 0 then x[index]=x[index]+1
;	Remove systemic velocities by higher-order binary components
	index=where(strlen(binary_model.component) $
		 gt strlen(binary_model[i].component),count_ho)
	if index[0] ge 0 then begin
	s=modelvel(t,binary_model[index].component)
	s=s[*,where(star_model.component eq components[k])]
	r=componentparse(topbincomp(),c1,c2)
	if strlen(c1) eq 1 and c1 eq components[k] then s=s*0
	if strlen(c2) eq 1 and c2 eq components[k] then s=s*0
	v=v-s
	y=y-s
	endif
endif else begin
	x=velocities[index].jd
	xtitle='Epoch'
endelse
ytitle1='Velocity [km/s]'
ytitle2='Residual vel.'
title=wmcc(plotvel_options.component)
if plotvel_options.a then begin
	title=''
	for j=0,n_elements(components) -1 do $
		title=title+' '+wmcc(components[j])
endif
if plotvel_options.b then title=''
;
; Set and equalize ranges
if xrange_auto then !x.range=[min(x),max(x)]
if xrange_auto and n_elements(x) eq 1 then !x.range=[x-0.1,x+0.1]
if yrange_auto then !y.range=[min(y),max(y)]
if yrange_auto then begin
	minmax=fltarr(2)
	plotlehmann,components[k],minmax
	!y.range=[minmax[0]*1.1,minmax[1]*1.1]
	!x.range=[0,1]
endif
;if yrange_auto and plotvel_options.o then !y.range=[min([y,v]),max([y,v])]
if yrange_auto and !y.range[1]-!y.range[0] lt 1 then begin
	!y.range[0]=!y.range[0]-1
	!y.range[1]=!y.range[1]+1
endif
;
plotdata_x=x
plotdata_y=y
if plotvel_options.p then begin
	x=[x-1,x,x+1]
	y=[y,y,y]
	v=[v,v,v]	; model value
	e=[e,e,e]
	p=[p,p,p]	; phase
	c=[c,c,c]
endif
;
; Set symbol
; if plotvel_options.e then !p.psym=3 else !p.psym=1
;
; Plot data
index=where(e gt 0,count)
if count gt 0 then begin
	if not overplot or (plotvel_options.a and k eq 0) then begin
	plot,x[index],y[index], $
		xtitle=xtitle,ytitle=ytitle1,title=title, $
		ymargin=ymargin1,xstyle=xstyle1,/nodata,xticklen=0.04
		pu=!p
		xu=!x
		yu=!y
	endif else begin
		!p=pu
		!x=xu
		!y=yu
	endelse
	for i=0,count-1 do begin
;		if total(p) ne 0 then $
		plotsymbol,p(index(i))
		oplot,[x[index[i]],x[index[i]]], $
		      [y[index[i]],y[index[i]]], $
		      psym=8*0+3,color=tci(c[index[i]])
		if plotvel_options.p then $
		oplot,[x[index[i]],x[index[i]]]+1, $
		      [y[index[i]],y[index[i]]], $
		      psym=8*0+3,color=tci(c[index[i]])
	if plotvel_options.e then begin
		oploterror,[x[index[i]],x[index[i]]], $
		      [y[index[i]],y[index[i]]], $
		      [x[index[i]],x[index[i]]]*0, $
		      [e[index[i]],e[index[i]]], $
			errcolor=tci(c[index[i]]),psym=3
		if plotvel_options.p then $
		oploterror,[x[index[i]],x[index[i]]]+1, $
		      [y[index[i]],y[index[i]]], $
		      [x[index[i]],x[index[i]]]*0, $
		      [e[index[i]],e[index[i]]], $
			errcolor=tci(c[index[i]]),psym=3
	endif
	endfor
endif
if plotvel_options.f then begin
	index=where(e le 0,count)
	if count gt 0 then begin
		oplot,x[index],y[index],color=tci(2)
		if plotvel_options.e then begin
			oploterror,x[index],y[index],x[index]*0,e[index], $
				errcolor=tci(2)
		endif
	endif
endif
;
; Plot dashed line corresponding to rv (systemic velocity)
if count_ho gt 0 then oplot,!x.crange,[0,0],linestyle=1,psym=0 else $
if n_elements(gen_model) ne 0 then $
oplot,!x.crange,[gen_model.rv,gen_model.rv],linestyle=1,psym=0
;
; Plot model
!p.linestyle=k*2
; plotsymbol,k*2
if plotvel_options.o then begin
;
;	Plot orbit
	plotlehmann,components[k]
;
;	Plot residuals
	if plotvel_options.r then begin
	if not overplot or (plotvel_options.a and k eq 0) then $
	axis,xaxis=1,xtickname=replicate(' ',6),xticklen=0.04
	if plotvel_options.a then begin
		if k eq 0 then x=x-0.003 else x=x+0.003
	endif
	r=y-v
	index=where(e gt 0,count)
	if count gt 0 then begin
	rms_vel=stddev(r[index])
	if rms_vel ne 0 then begin
		print,'RMS (km/s) = ',rms_vel
		ymax=(nint(rms_vel+0.5)*4)/5*5 & ymin=-ymax
	endif else begin
		ymax=nint(max(abs(r[index]))+max(e[index]))+1 & ymin=-ymax
	endelse
	print,'Chi^2 (red)= ',total((r[index]/e[index])^2)/count
	if not overplot or (plotvel_options.a and k eq 0) then begin
	plot,x[index],r[index],ymargin=ymargin2,xstyle=xstyle2, $
		yrange=[ymin,ymax], $
		ytitle=ytitle2,xtitle=xtitle,/nodata,xticklen=0.04
		pl=!p
		xl=!x
		yl=!y
	endif else begin
		!p=pl
		!x=xl
		!y=yl
	endelse
	for i=0,count-1 do begin
		if total(p) ne 0 then $
		plotsymbol,p[index[i]]
		oplot,[x[index[i]],x[index[i]]], $
		      [r[index[i]],r[index[i]]], $
		      psym=8,color=tci(c[index[i]])
;		if plotvel_options.e or plotvel_options.a then $
		oploterror,x(index(i)),r(index(i)),x(index(i))*0,e(index(i)), $
				errcolor=tci(c(index(i)))
;		Also plot phase+1 if option Phase is selected
		if plotvel_options.p then begin
		oplot,[x[index[i]],x[index[i]]]+1, $
		      [r[index[i]],r[index[i]]], $
		      psym=8,color=tci(c[index[i]])
;		if plotvel_options.e or plotvel_options.a then $
		oploterror,x(index(i))+1,r(index(i)),x(index(i))*0,e(index(i)), $
				errcolor=tci(c(index(i)))
		endif
	endfor
	oplot,!x.crange,[0,0],psym=0
	endif
	endif
endif
;
ENDFOR
;
; Reset plot variables
; if plotvel_options.a then plotvel_options.r=plotvel_options_r
if xrange_auto then !x.range=0
if yrange_auto then !y.range=0
!p.linestyle=0
!p.color=tci(1)
!p.multi=0
;
end
