pro plotvolvox
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
common StarBase,StarTable,Notes
;
table=startable
index=where(startable.starid ne 'FKV0000',count)
;
rename_starids,'fkv-bsc'
rename_starids,'bsc-hip'
read_catalogs
ra0=startable[index].ra*15l*3600000l
dec0=startable[index].dec*3600000l
;
startable=table
ra=startable[index].ra*15l*3600000l
rae=startable[index].rae*15l*3600000l
dec=startable[index].dec*3600000l
dece=startable[index].dece*3600000l
;
dra=ra-ra0-avg(ra-ra0)
ddec=dec-dec0
;
if !d.name ne 'PS' then window,/free
!p.charsize=1.5
plot,dra,ddec,psym=3,xtitle='RA offset [mas]',ytitle='Dec offset [mas]', $
	title='Current - Hipparcos'
oplot,!x.crange,[0,0],psym=0,linestyle=1
oplot,[0,0],!y.crange,psym=0,linestyle=1
for i=0,count-1 do begin
	oplot,[dra[i]-rae[i]/2,dra[i]+rae[i]/2], $
	      [ddec[i],ddec[i]],psym=0
	oplot,[dra[i],dra[i]], $
	      [ddec[i]-dece[i]/2,ddec[i]+dece[i]/2],psym=0
endfor
if !d.name eq 'PS' then begin
	device,/close
	set_plot,!display
endif
;
end
