function pointindex,star,coherent=coherent
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Return indices into pointdata items from an input selection.
;
common Tables,ScanTable,BGTable,StationTable
common PointData,Rec0,RecN,Iscan,StarId,PointTime, $
        FDLPos,FDLPosErr,MetroPos,MetroPosErr,GeoDelay,GeoDelayErr, $
        DelayJitter,DelayJitterErr,SoftDelay,SoftDelayErr, $
        NATJitter,NATJitterErr,NATCounts,NATCountsErr, $
        GrpDelay,GrpDelayErr,DryDelay,DryDelayErr,WetDelay,WetDelayErr, $
        PhotonRate,PhotonRateErr,VisSq,VisSqErr, $
        ComplexVis,ComplexVisErr,ComplTriple,ComplTripleErr, $
        VisAmp,VisAmpErr,VisPhase,VisPhaseErr, $
        TripleAmp,TripleAmpErr,TriplePhase,TriplePhaseErr
;
if n_elements(coherent) ne 0 then jndex=where(scantable.code eq 1) $
			     else jndex=indgen(n_elements(scantable))
count=n_elements(StarId[jndex])
if n_elements(star) ne 0 then index=where(StarId[jndex] eq star,count) $
			 else index=indgen(count)
;
if count eq 0 then return,-1
return,stringparse(strcompress(strjoin(string(rec0[index[jndex]])+'-' $
				      +string(recn[index[jndex]]),','),/remove))
end
